/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.CulDeSacRoad;
import org.egov.common.entity.edcr.Lane;
import org.egov.common.entity.edcr.NonNotifiedRoad;
import org.egov.common.entity.edcr.NotifiedRoad;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.DcrConstants;
import org.springframework.stereotype.Service;

@Service
public class BuildingHeight
extends FeatureProcess {
    private static final String RULE_EXPECTED_KEY = "buildingheight.expected";
    private static final String RULE_ACTUAL_KEY = "buildingheight.actual";
    private static final String SECURITYZONE_RULE_EXPECTED_KEY = "securityzone.expected";
    private static final String SECURITYZONE_RULE_ACTUAL_KEY = "securityzone.actual";
    private static final String SUB_RULE_32_1A = "32-1A";
    private static final String SUB_RULE_32_3 = "32-3";
    public static final String UPTO = "Up To";
    public static final String DECLARED = "Declared";
    private static final BigDecimal TWELVE = BigDecimal.valueOf(12L);
    private static final BigDecimal TEN = BigDecimal.valueOf(10L);

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan Plan2) {
        return Plan2;
    }

    private void checkBuildingHeight(Plan Plan2) {
        String subRule = SUB_RULE_32_1A;
        String rule = "Height of Building";
        BigDecimal maximumDistanceToRoad = BigDecimal.ZERO;
        maximumDistanceToRoad = this.getMaximimShortestdistanceFromRoad(Plan2, maximumDistanceToRoad);
        for (Block block : Plan2.getBlocks()) {
            HashMap<String, String> details;
            BigDecimal maximumDistanceToRoadEdge = BigDecimal.ZERO;
            BigDecimal maximumSetBackToBuildingLine = BigDecimal.ZERO;
            BigDecimal exptectedDistance = BigDecimal.ZERO;
            BigDecimal actualDistance = BigDecimal.ZERO;
            maximumDistanceToRoadEdge = this.getMaximumDistanceFromRoadEdge(maximumDistanceToRoadEdge, block);
            maximumSetBackToBuildingLine = this.getMaximumDistanceFromSetBackToBuildingLine(maximumSetBackToBuildingLine, block);
            actualDistance = block.getBuilding().getBuildingHeight();
            if (maximumDistanceToRoadEdge != null && maximumDistanceToRoad.compareTo(TWELVE) <= 0) {
                exptectedDistance = maximumSetBackToBuildingLine != null && maximumSetBackToBuildingLine.compareTo(BigDecimal.ZERO) > 0 ? maximumDistanceToRoadEdge.multiply(BigDecimal.valueOf(2L)).add(BigDecimal.valueOf(3L).multiply(maximumSetBackToBuildingLine.divide(BigDecimal.valueOf(0.5), 0, RoundingMode.DOWN))).setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS) : maximumDistanceToRoadEdge.multiply(BigDecimal.valueOf(2L)).setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS);
            }
            if (exptectedDistance.compareTo(BigDecimal.ZERO) <= 0) continue;
            String actualResult = this.getLocaleMessage(RULE_ACTUAL_KEY, actualDistance.toString());
            String expectedResult = this.getLocaleMessage(RULE_EXPECTED_KEY, exptectedDistance.toString());
            if (actualDistance.compareTo(exptectedDistance) > 0) {
                details = new HashMap<String, String>();
                details.put("Byelaw", subRule);
                details.put("Description", "Height of Building for Block " + block.getNumber());
                details.put(UPTO, expectedResult);
                details.put("Provided", actualResult);
                details.put("Status", Result.Not_Accepted.getResultVal());
                this.scrutinyDetail.getDetail().add(details);
                Plan2.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
                continue;
            }
            details = new HashMap();
            details.put("Byelaw", subRule);
            details.put("Description", "Height of Building for Block " + block.getNumber());
            details.put(UPTO, expectedResult);
            details.put("Provided", actualResult);
            details.put("Status", Result.Verify.getResultVal());
            this.scrutinyDetail.getDetail().add(details);
            Plan2.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
        }
    }

    private void checkBuildingInSecurityZoneArea(Plan Plan2) {
        if (Plan2.getPlanInformation().getSecurityZone().booleanValue()) {
            BigDecimal maxBuildingHeight = BigDecimal.ZERO;
            for (Block block : Plan2.getBlocks()) {
                if (maxBuildingHeight.compareTo(BigDecimal.ZERO) != 0 && block.getBuilding().getBuildingHeight().compareTo(maxBuildingHeight) < 0) continue;
                maxBuildingHeight = block.getBuilding().getBuildingHeight();
            }
            if (maxBuildingHeight.compareTo(BigDecimal.ZERO) > 0) {
                this.scrutinyDetail = new ScrutinyDetail();
                this.scrutinyDetail.setKey("Common_Security Zone");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
                String actualResult = this.getLocaleMessage(SECURITYZONE_RULE_ACTUAL_KEY, maxBuildingHeight.toString());
                String expectedResult = this.getLocaleMessage(SECURITYZONE_RULE_EXPECTED_KEY, TEN.toString());
                if (maxBuildingHeight.compareTo(TEN) <= 0) {
                    HashMap<String, String> details = new HashMap<String, String>();
                    details.put("Byelaw", SUB_RULE_32_3);
                    details.put("Description", "Building in Security Zone");
                    details.put("Required", expectedResult);
                    details.put("Provided", actualResult);
                    details.put("Status", Result.Verify.getResultVal());
                    this.scrutinyDetail.getDetail().add(details);
                    Plan2.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
                } else {
                    HashMap<String, String> details = new HashMap<String, String>();
                    details.put("Byelaw", SUB_RULE_32_3);
                    details.put("Description", "Building in Security Zone");
                    details.put("Required", expectedResult);
                    details.put("Provided", actualResult);
                    details.put("Status", Result.Not_Accepted.getResultVal());
                    this.scrutinyDetail.getDetail().add(details);
                    Plan2.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
                }
            }
        } else {
            this.scrutinyDetail = new ScrutinyDetail();
            this.scrutinyDetail.setKey("Common_Security Zone");
            this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
            this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
            this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), DECLARED);
            this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Status");
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("Byelaw", SUB_RULE_32_3);
            details.put("Description", "Building in Security Zone");
            details.put(DECLARED, "No");
            details.put("Status", Result.Verify.getResultVal());
            this.scrutinyDetail.getDetail().add(details);
            Plan2.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
        }
    }

    private BigDecimal getMaximumDistanceFromRoadEdge(BigDecimal maximumDistanceToRoadEdge, Block block) {
        if (block.getBuilding().getDistanceFromBuildingFootPrintToRoadEnd() != null) {
            for (BigDecimal distanceFromroadEnd : block.getBuilding().getDistanceFromBuildingFootPrintToRoadEnd()) {
                if (distanceFromroadEnd.compareTo(maximumDistanceToRoadEdge) <= 0) continue;
                maximumDistanceToRoadEdge = distanceFromroadEnd;
            }
        }
        return maximumDistanceToRoadEdge;
    }

    private BigDecimal getMaximumDistanceFromSetBackToBuildingLine(BigDecimal distanceFromSetbackToBuildingLine, Block block) {
        if (block.getBuilding().getDistanceFromSetBackToBuildingLine() != null) {
            for (BigDecimal distance : block.getBuilding().getDistanceFromSetBackToBuildingLine()) {
                if (distance.compareTo(distanceFromSetbackToBuildingLine) <= 0) continue;
                distanceFromSetbackToBuildingLine = distance;
            }
        }
        return distanceFromSetbackToBuildingLine;
    }

    private BigDecimal getMaximimShortestdistanceFromRoad(Plan Plan2, BigDecimal maximumDistanceToRoad) {
        if (Plan2.getNonNotifiedRoads() != null) {
            for (NonNotifiedRoad nonnotifiedRoad : Plan2.getNonNotifiedRoads()) {
                for (BigDecimal shortDistance : nonnotifiedRoad.getShortestDistanceToRoad()) {
                    if (shortDistance.compareTo(maximumDistanceToRoad) <= 0) continue;
                    maximumDistanceToRoad = shortDistance;
                }
            }
        }
        if (Plan2.getNotifiedRoads() != null) {
            for (NotifiedRoad notifiedRoad : Plan2.getNotifiedRoads()) {
                for (BigDecimal shortDistance : notifiedRoad.getShortestDistanceToRoad()) {
                    if (shortDistance.compareTo(maximumDistanceToRoad) <= 0) continue;
                    maximumDistanceToRoad = shortDistance;
                }
            }
        }
        if (Plan2.getCuldeSacRoads() != null) {
            for (CulDeSacRoad culdRoad : Plan2.getCuldeSacRoads()) {
                for (BigDecimal shortDistance : culdRoad.getShortestDistanceToRoad()) {
                    if (shortDistance.compareTo(maximumDistanceToRoad) <= 0) continue;
                    maximumDistanceToRoad = shortDistance;
                }
            }
        }
        if (Plan2.getLaneRoads() != null) {
            for (Lane lane : Plan2.getLaneRoads()) {
                for (BigDecimal shortDistance : lane.getShortestDistanceToRoad()) {
                    if (shortDistance.compareTo(maximumDistanceToRoad) <= 0) continue;
                    maximumDistanceToRoad = shortDistance;
                }
            }
        }
        return maximumDistanceToRoad;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

