/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.BlockDistances;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.common.entity.edcr.SetBack;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.DcrConstants;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class BlockDistancesService
extends FeatureProcess {
    public static final String SUBRULE_54_3 = "54-3";
    public static final String SUBRULE_55_2 = "55-2";
    public static final String SUBRULE_57_4 = "57-4";
    public static final String SUBRULE_58_3_A = "58-3-a";
    public static final String SUBRULE_59_3 = "59-3";
    public static final String SUBRULE_117_3 = "117-3";
    public static final BigDecimal DIS_7_5 = BigDecimal.valueOf(7.5);
    public static final String BLK_NUMBER = "blkNumber";
    public static final String SUBRULE = "subrule";
    public static final String MIN_DISTANCE = "minimumDistance";
    public static final String OCCUPANCY = "occupancy";
    private static final String SUBRULE_37_1 = "37-1";
    private static final String SUB_RULE_DES = "Minimum distance between blocks %s and %s";
    public static final String MINIMUM_DISTANCE_SETBACK = "Minimum distance should not be less than setback of tallest building or 3m";
    public static final String MINIMUM_DISTANCE_BUILDING = "Minimum distance should not be less than 1/3 of height of tallest building or 18m";
    private static final BigDecimal THREE = BigDecimal.valueOf(3L);

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        this.processDistanceBetweenBlocks(pl);
        return pl;
    }

    public void validateDistanceBetweenBlocks(Plan pl) {
        HashMap<String, String> errors = new HashMap<String, String>();
        ArrayList<String> sourceBlockNumbers = new ArrayList<String>();
        for (Block sourceBlock : pl.getBlocks()) {
            if (sourceBlock.getBuilding() != null) {
                if (sourceBlock.getBuilding().getBuildingHeight().compareTo(BigDecimal.ZERO) == 0) {
                    errors.put(String.format("Block %s building height", sourceBlock.getNumber()), this.edcrMessageSource.getMessage("msg.error.not.defined", (Object[])new String[]{String.format("Block %s building height", sourceBlock.getNumber())}, LocaleContextHolder.getLocale()));
                    pl.addErrors(errors);
                }
                if (sourceBlock.getBuilding().getOccupancies().isEmpty()) {
                    errors.put(String.format("Block %s building occupany", sourceBlock.getNumber()), this.edcrMessageSource.getMessage("msg.error.not.defined", (Object[])new String[]{String.format("Block %s building occupany", sourceBlock.getNumber())}, LocaleContextHolder.getLocale()));
                    pl.addErrors(errors);
                }
            }
            sourceBlockNumbers.add(sourceBlock.getNumber());
            for (Block destinationBlock : pl.getBlocks()) {
                if (sourceBlockNumbers.contains(destinationBlock.getNumber())) continue;
                List distanceBetBlocks = new ArrayList();
                List distanceBtwBlocks = new ArrayList();
                if (!sourceBlock.getDistanceBetweenBlocks().isEmpty()) {
                    for (BlockDistances distanceBetweenBlock : sourceBlock.getDistanceBetweenBlocks()) {
                        if (!distanceBetweenBlock.getBlockNumber().equals(destinationBlock.getNumber())) continue;
                        distanceBetBlocks = distanceBetweenBlock.getDistances();
                    }
                }
                if (!destinationBlock.getDistanceBetweenBlocks().isEmpty()) {
                    for (BlockDistances distanceBetweenBlock : destinationBlock.getDistanceBetweenBlocks()) {
                        if (!distanceBetweenBlock.getBlockNumber().equals(sourceBlock.getNumber())) continue;
                        distanceBtwBlocks = distanceBetweenBlock.getDistances();
                    }
                }
                if (!distanceBetBlocks.isEmpty() || !distanceBtwBlocks.isEmpty()) continue;
                errors.put(String.format("Distance between block %s and block %s", sourceBlock.getNumber(), destinationBlock.getNumber()), this.edcrMessageSource.getMessage("msg.error.not.defined", (Object[])new String[]{String.format("Distance between block %s and block %s", sourceBlock.getNumber(), destinationBlock.getNumber())}, LocaleContextHolder.getLocale()));
                pl.addErrors(errors);
            }
        }
    }

    public void processDistanceBetweenBlocks(Plan pl) {
        if (pl.getBlocks().isEmpty()) {
            return;
        }
        this.validateDistanceBetweenBlocks(pl);
        this.scrutinyDetail = new ScrutinyDetail();
        this.scrutinyDetail.setKey("Common_Distance Between Blocks");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        for (Block b : pl.getBlocks()) {
            for (Block block : pl.getBlocks()) {
                if (b.getNumber() == block.getNumber() || b.getDistanceBetweenBlocks().isEmpty()) continue;
                for (BlockDistances distanceBetweenBlock : b.getDistanceBetweenBlocks()) {
                    if (!distanceBetweenBlock.getBlockNumber().equals(block.getNumber())) continue;
                    boolean valid1 = false;
                    boolean valid2 = false;
                    if (distanceBetweenBlock.getDistances().isEmpty()) continue;
                    BigDecimal minimumDistance = (BigDecimal)distanceBetweenBlock.getDistances().get(0);
                    for (BigDecimal distance : distanceBetweenBlock.getDistances()) {
                        if (distance.compareTo(minimumDistance) >= 0) continue;
                        minimumDistance = distance;
                    }
                    this.validateMinimumDistance(pl, minimumDistance, b, block, valid1, valid2);
                }
            }
        }
    }

    private void setReportOutputDetails(Plan pl, String ruleNo, String ruleDesc, String occupancy, String expected, String actual, String status) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        this.scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
    }

    private void validateMinimumDistance(Plan pl, BigDecimal actualDistance, Block b, Block block, Boolean valid1, Boolean valid2) {
        BigDecimal maxSetBack;
        BigDecimal bHeight = b.getBuilding().getBuildingHeight();
        BigDecimal blockHeight = block.getBuilding().getBuildingHeight();
        HashMap<BigDecimal, Block> blockMap = new HashMap<BigDecimal, Block>();
        blockMap.put(bHeight, b);
        blockMap.put(blockHeight, block);
        List<BigDecimal> blkHeights = Arrays.asList(bHeight, blockHeight);
        BigDecimal maxHeight = (BigDecimal)blkHeights.stream().reduce(BigDecimal::max).get();
        ArrayList<BigDecimal> setBacksValues = new ArrayList<BigDecimal>();
        setBacksValues.add(THREE);
        List setBacks = block.getSetBacks();
        for (SetBack setback : setBacks) {
            if (setback.getRearYard() != null) {
                setBacksValues.add(setback.getRearYard().getHeight());
            }
            if (setback.getSideYard1() != null) {
                setBacksValues.add(setback.getSideYard1().getHeight());
            }
            if (setback.getSideYard2() == null) continue;
            setBacksValues.add(setback.getSideYard2().getHeight());
        }
        BigDecimal dividedHeight = maxHeight.divide(THREE, 2, DcrConstants.ROUNDMODE_MEASUREMENTS);
        List<BigDecimal> heights = Arrays.asList(dividedHeight, BigDecimal.valueOf(18L));
        BigDecimal minHeight = (BigDecimal)heights.stream().reduce(BigDecimal::min).get();
        if (actualDistance.compareTo(minHeight) >= 0) {
            valid1 = true;
        }
        if (actualDistance.compareTo(maxSetBack = (BigDecimal)setBacksValues.stream().reduce(BigDecimal::max).get()) >= 0) {
            valid2 = true;
        }
        if (valid1.booleanValue()) {
            this.setReportOutputDetails(pl, SUBRULE_37_1, String.format(SUB_RULE_DES, b.getNumber(), block.getNumber()), "", MINIMUM_DISTANCE_BUILDING, actualDistance.toString() + "(MTR)", Result.Accepted.getResultVal());
        } else {
            this.setReportOutputDetails(pl, SUBRULE_37_1, String.format(SUB_RULE_DES, b.getNumber(), block.getNumber()), "", MINIMUM_DISTANCE_BUILDING, actualDistance.toString() + "(MTR)", Result.Not_Accepted.getResultVal());
        }
        if (valid2.booleanValue()) {
            this.setReportOutputDetails(pl, SUBRULE_37_1, String.format(SUB_RULE_DES, b.getNumber(), block.getNumber()), "", MINIMUM_DISTANCE_SETBACK, actualDistance.toString() + "(MTR)", Result.Accepted.getResultVal());
        } else {
            this.setReportOutputDetails(pl, SUBRULE_37_1, String.format(SUB_RULE_DES, b.getNumber(), block.getNumber()), "", MINIMUM_DISTANCE_SETBACK, actualDistance.toString() + "(MTR)", Result.Not_Accepted.getResultVal());
        }
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

