/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Measurement;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.RoomHeight;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class BathRoomWaterClosets
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(BathRoomWaterClosets.class);
    private static final String RULE_41_IV = "41-iv";
    public static final String BathroomWaterClosets_DESCRIPTION = "Bathroom Water Closets";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.setKey("Common_Bathroom Water Closets");
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", RULE_41_IV);
        details.put("Description", BathroomWaterClosets_DESCRIPTION);
        BigDecimal minHeight = BigDecimal.ZERO;
        BigDecimal totalArea = BigDecimal.ZERO;
        BigDecimal minWidth = BigDecimal.ZERO;
        for (Block b : pl.getBlocks()) {
            if (b.getBuilding() == null || b.getBuilding().getFloors() == null || b.getBuilding().getFloors().isEmpty()) continue;
            for (Floor f : b.getBuilding().getFloors()) {
                if (f.getBathRoomWaterClosets() == null || f.getBathRoomWaterClosets().getHeights() == null || f.getBathRoomWaterClosets().getHeights().isEmpty() || f.getBathRoomWaterClosets().getRooms() == null || f.getBathRoomWaterClosets().getRooms().isEmpty()) continue;
                if (f.getBathRoomWaterClosets().getHeights() != null && !f.getBathRoomWaterClosets().getHeights().isEmpty()) {
                    minHeight = ((RoomHeight)f.getBathRoomWaterClosets().getHeights().get(0)).getHeight();
                    for (RoomHeight rh : f.getBathRoomWaterClosets().getHeights()) {
                        if (rh.getHeight().compareTo(minHeight) >= 0) continue;
                        minHeight = rh.getHeight();
                    }
                }
                if (f.getBathRoomWaterClosets().getRooms() != null && !f.getBathRoomWaterClosets().getRooms().isEmpty()) {
                    minWidth = ((Measurement)f.getBathRoomWaterClosets().getRooms().get(0)).getWidth();
                    for (Measurement m : f.getBathRoomWaterClosets().getRooms()) {
                        totalArea = totalArea.add(m.getArea());
                        if (m.getWidth().compareTo(minWidth) >= 0) continue;
                        minWidth = m.getWidth();
                    }
                }
                if (minHeight.compareTo(new BigDecimal(2.4)) >= 0 && totalArea.compareTo(new BigDecimal(2.8)) >= 0 && minWidth.compareTo(new BigDecimal(1.2)) >= 0) {
                    details.put("Required", "Height >= 2.4, Total Area >= 2.8, Width >= 1.2");
                    details.put("Provided", "Height >= " + minHeight + ", Total Area >= " + totalArea + ", Width >= " + minWidth);
                    details.put("Status", Result.Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                    continue;
                }
                details.put("Required", "Height >= 2.4, Total Area >= 2.8, Width >= 1.2");
                details.put("Provided", "Height >= " + minHeight + ", Total Area >= " + totalArea + ", Width >= " + minWidth);
                details.put("Status", Result.Not_Accepted.getResultVal());
                scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
            }
        }
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

