/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class Basement
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(Basement.class);
    private static final String RULE_46_6A = "46-6a";
    private static final String RULE_46_6C = "46-6c";
    public static final String BASEMENT_DESCRIPTION_ONE = "Height from the floor to the soffit of the roof slab or ceiling";
    public static final String BASEMENT_DESCRIPTION_TWO = "Minimum height of the ceiling of upper basement above ground level";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.setKey("Common_Basement");
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        HashMap<String, String> details = new HashMap<String, String>();
        BigDecimal minLength = BigDecimal.ZERO;
        if (pl.getBlocks() != null) {
            for (Block b : pl.getBlocks()) {
                if (b.getBuilding() == null || b.getBuilding().getFloors() == null || b.getBuilding().getFloors().isEmpty()) continue;
                for (Floor f : b.getBuilding().getFloors()) {
                    if (f.getNumber() != -1) continue;
                    if (f.getHeightFromTheFloorToCeiling() != null && !f.getHeightFromTheFloorToCeiling().isEmpty()) {
                        minLength = (BigDecimal)f.getHeightFromTheFloorToCeiling().stream().reduce(BigDecimal::min).get();
                        if (minLength.compareTo(BigDecimal.valueOf(2.4)) >= 0) {
                            details.put("Byelaw", RULE_46_6A);
                            details.put("Description", BASEMENT_DESCRIPTION_ONE);
                            details.put("Required", ">= 2.4");
                            details.put("Provided", minLength.toString());
                            details.put("Status", Result.Accepted.getResultVal());
                            scrutinyDetail.getDetail().add(details);
                        } else {
                            details = new HashMap();
                            details.put("Byelaw", RULE_46_6A);
                            details.put("Description", BASEMENT_DESCRIPTION_ONE);
                            details.put("Required", ">= 2.4");
                            details.put("Provided", minLength.toString());
                            details.put("Status", Result.Not_Accepted.getResultVal());
                            scrutinyDetail.getDetail().add(details);
                        }
                    }
                    minLength = BigDecimal.ZERO;
                    if (f.getHeightOfTheCeilingOfUpperBasement() != null && !f.getHeightOfTheCeilingOfUpperBasement().isEmpty()) {
                        minLength = (BigDecimal)f.getHeightOfTheCeilingOfUpperBasement().stream().reduce(BigDecimal::min).get();
                        if (minLength.compareTo(BigDecimal.valueOf(1.2)) >= 0 && minLength.compareTo(BigDecimal.valueOf(1.5)) < 0) {
                            details = new HashMap();
                            details.put("Byelaw", RULE_46_6C);
                            details.put("Description", BASEMENT_DESCRIPTION_TWO);
                            details.put("Required", "Between 1.2 to 1.5");
                            details.put("Provided", minLength.toString());
                            details.put("Status", Result.Accepted.getResultVal());
                            scrutinyDetail.getDetail().add(details);
                        } else {
                            details = new HashMap();
                            details.put("Byelaw", RULE_46_6C);
                            details.put("Description", BASEMENT_DESCRIPTION_TWO);
                            details.put("Required", "Between 1.2 to 1.5");
                            details.put("Provided", minLength.toString());
                            details.put("Status", Result.Not_Accepted.getResultVal());
                            scrutinyDetail.getDetail().add(details);
                        }
                    }
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                }
            }
        }
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

