/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.DcrConstants;
import org.egov.edcr.utility.Util;
import org.springframework.stereotype.Service;

@Service
public class Balcony
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(Balcony.class);
    private static final String FLOOR = "Floor";
    private static final String RULE45_IV = "45-iv";
    private static final String WIDTH_BALCONY_DESCRIPTION = "Minimum width for balcony %s";
    private static final BigDecimal ONE_POINTTWO = BigDecimal.valueOf(1.2);

    @Override
    public Plan validate(Plan plan) {
        return plan;
    }

    @Override
    public Plan process(Plan plan) {
        for (Block block : plan.getBlocks()) {
            if (block.getBuilding() == null) continue;
            ScrutinyDetail scrutinyDetailLanding = new ScrutinyDetail();
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(2), FLOOR);
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(3), "Description");
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(4), "Permissible");
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(5), "Provided");
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(6), "Status");
            scrutinyDetailLanding.setKey("Block_" + block.getNumber() + "_Balcony");
            List floors = block.getBuilding().getFloors();
            for (Floor floor : floors) {
                boolean isTypicalRepititiveFloor = false;
                Map typicalFloorValues = Util.getTypicalFloorValues((Block)block, (Floor)floor, (Boolean)isTypicalRepititiveFloor);
                List balconies = floor.getBalconies();
                if (balconies.isEmpty()) continue;
                for (org.egov.common.entity.edcr.Balcony balcony : balconies) {
                    String value;
                    boolean isAccepted = false;
                    List widths = balcony.getWidths();
                    BigDecimal minWidth = (BigDecimal)widths.stream().reduce(BigDecimal::min).get();
                    if ((minWidth = minWidth.setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS)).compareTo(ONE_POINTTWO.setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS)) >= 0) {
                        isAccepted = true;
                    }
                    String string = value = typicalFloorValues.get("typicalFloors") != null ? (String)typicalFloorValues.get("typicalFloors") : " floor " + floor.getNumber();
                    if (isAccepted) {
                        this.setReportOutputDetailsFloorBalconyWise(plan, RULE45_IV, value, String.format(WIDTH_BALCONY_DESCRIPTION, balcony.getNumber()), ONE_POINTTWO.toString(), String.valueOf(minWidth), Result.Accepted.getResultVal(), scrutinyDetailLanding);
                        continue;
                    }
                    this.setReportOutputDetailsFloorBalconyWise(plan, RULE45_IV, value, String.format(WIDTH_BALCONY_DESCRIPTION, balcony.getNumber()), ONE_POINTTWO.toString(), String.valueOf(minWidth), Result.Not_Accepted.getResultVal(), scrutinyDetailLanding);
                }
            }
        }
        return plan;
    }

    private void setReportOutputDetailsFloorBalconyWise(Plan pl, String ruleNo, String floor, String description, String expected, String actual, String status, ScrutinyDetail scrutinyDetail) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put(FLOOR, floor);
        details.put("Description", description);
        details.put("Permissible", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

