/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.OccupancyTypeHelper;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.common.entity.edcr.SetBack;
import org.egov.common.entity.edcr.Yard;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.DcrConstants;
import org.egov.infra.utils.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class AdditionalFeature
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(AdditionalFeature.class);
    private static final String RULE_38 = "38";
    private static final String RULE_39 = "39";
    private static final String RULE_41_I_A = "41-i-a";
    private static final String RULE_41_I_B = "41-i-b";
    private static final String RULE_47 = "47";
    private static final String RULE_50 = "50";
    private static final String RULE_56 = "56";
    private static final BigDecimal TWO = BigDecimal.valueOf(2L);
    private static final BigDecimal ONE_POINTFIVE = BigDecimal.valueOf(1.5);
    private static final BigDecimal THREE = BigDecimal.valueOf(3L);
    private static final BigDecimal FOUR = BigDecimal.valueOf(4L);
    private static final BigDecimal SIX = BigDecimal.valueOf(6L);
    private static final BigDecimal SEVEN = BigDecimal.valueOf(7L);
    private static final BigDecimal TEN = BigDecimal.valueOf(10L);
    private static final BigDecimal TWELVE = BigDecimal.valueOf(12L);
    private static final BigDecimal NINETEEN = BigDecimal.valueOf(19L);
    private static final BigDecimal ROAD_WIDTH_TWO_POINTFOUR = BigDecimal.valueOf(2.4);
    private static final BigDecimal ROAD_WIDTH_TWO_POINTFOURFOUR = BigDecimal.valueOf(2.44);
    private static final BigDecimal ROAD_WIDTH_THREE_POINTSIX = BigDecimal.valueOf(3.6);
    private static final BigDecimal ROAD_WIDTH_FOUR_POINTEIGHT = BigDecimal.valueOf(4.8);
    private static final BigDecimal ROAD_WIDTH_SIX_POINTONE = BigDecimal.valueOf(6.1);
    private static final BigDecimal ROAD_WIDTH_NINE_POINTONE = BigDecimal.valueOf(9.1);
    private static final BigDecimal ROAD_WIDTH_TWELVE_POINTTWO = BigDecimal.valueOf(12.2);
    private static final int PLOTAREA_100 = 100;
    private static final int PLOTAREA_300 = 300;
    private static final int PLOTAREA_500 = 500;
    private static final int PLOTAREA_1000 = 1000;
    private static final int PLOTAREA_3000 = 3000;
    public static final String OLD = "OLD";
    public static final String NEW = "NEW";
    public static final String OLD_AREA_ERROR = "road width old area";
    public static final String NEW_AREA_ERROR = "road width new area";
    public static final String OLD_AREA_ERROR_MSG = "No construction shall be permitted if the road width is less than 2.4m for old area.";
    public static final String NEW_AREA_ERROR_MSG = "No construction shall be permitted if the road width is less than 6.1m for new area.";
    public static final String NO_OF_FLOORS = "Maximum number of floors allowed";
    public static final String HEIGHT_BUILDING = "Maximum height of building allowed";
    public static final String MIN_PLINTH_HEIGHT = " >= 0.45";
    public static final String MIN_PLINTH_HEIGHT_DESC = "Minimum plinth height";
    public static final String MAX_BSMNT_CELLAR = "Number of basement/cellar allowed";
    public static final String MIN_INT_COURT_YARD = "0.15";
    public static final String MIN_INT_COURT_YARD_DESC = "Minimum interior courtyard";
    public static final String BARRIER_FREE_ACCESS_FOR_PHYSICALLY_CHALLENGED_PEOPLE_DESC = "Barrier free access for physically challenged people";
    public static final String GREEN_BUILDINGS_AND_SUSTAINABILITY_PROVISIONS_ERROR_CODE = "Green buildings and sustainability provisions";
    public static final String GREEN_BUILDINGS_AND_SUSTAINABILITY_PROVISIONS_ERROR_MSG = "Green buildings and sustainability provision should be YES";
    public static final String GREEN_BUILDINGS_AND_SUSTAINABILITY = "Green buildings and sustainability provisions";
    public static final String FIRE_PROTECTION_AND_FIRE_SAFETY_REQUIREMENTS_DESC = "Fire Protection And Fire Safety Requirements";

    @Override
    public Plan validate(Plan pl) {
        HashMap<String, String> errors = new HashMap<String, String>();
        List blocks = pl.getBlocks();
        for (Block block : blocks) {
            if (block.getBuilding() == null || block.getBuilding().getBuildingHeight().compareTo(BigDecimal.ZERO) != 0) continue;
            errors.put(String.format("Block %s building height", block.getNumber()), this.edcrMessageSource.getMessage("msg.error.not.defined", (Object[])new String[]{String.format("Block %s building height", block.getNumber())}, LocaleContextHolder.getLocale()));
            pl.addErrors(errors);
        }
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        HashMap<String, String> errors = new HashMap<String, String>();
        this.validate(pl);
        String typeOfArea = pl.getPlanInformation().getTypeOfArea();
        BigDecimal roadWidth = pl.getPlanInformation().getRoadWidth();
        if (StringUtils.isNotBlank((String)typeOfArea) && roadWidth != null) {
            this.validateNumberOfFloors(pl, errors, typeOfArea, roadWidth);
            this.validateHeightOfBuilding(pl, errors, typeOfArea, roadWidth);
        }
        this.validatePlinthHeight(pl, errors);
        this.validateBarrierFreeAccess(pl, errors);
        this.validateBasement(pl, errors);
        this.validateGreenBuildingsAndSustainability(pl, errors);
        this.validateFireDeclaration(pl, errors);
        return pl;
    }

    private void validateFireDeclaration(Plan pl, HashMap<String, String> errors) {
        OccupancyTypeHelper mostRestrictiveOccupancyType;
        ScrutinyDetail scrutinyDetail = this.getNewScrutinyDetail(FIRE_PROTECTION_AND_FIRE_SAFETY_REQUIREMENTS_DESC);
        OccupancyTypeHelper occupancyTypeHelper = mostRestrictiveOccupancyType = pl.getVirtualBuilding() != null ? pl.getVirtualBuilding().getMostRestrictiveFarHelper() : null;
        if (pl.getBlocks() != null && !pl.getBlocks().isEmpty()) {
            for (Block b : pl.getBlocks()) {
                HashMap<String, String> details;
                if (b.getBuilding() == null || !b.getBuilding().getIsHighRise().booleanValue() && !this.isCommercialAbv750sqm(pl, mostRestrictiveOccupancyType)) continue;
                if (pl.getPlanInformation() != null && !pl.getPlanInformation().getFireProtectionAndFireSafetyRequirements().isEmpty()) {
                    details = new HashMap();
                    details.put("Byelaw", RULE_56);
                    details.put("Description", FIRE_PROTECTION_AND_FIRE_SAFETY_REQUIREMENTS_DESC);
                    details.put("Permissible", "YES/NO/NA");
                    details.put("Provided", pl.getPlanInformation().getFireProtectionAndFireSafetyRequirements());
                    details.put("Status", Result.Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                    continue;
                }
                details = new HashMap<String, String>();
                details.put("Byelaw", RULE_56);
                details.put("Description", FIRE_PROTECTION_AND_FIRE_SAFETY_REQUIREMENTS_DESC);
                details.put("Permissible", "YES/NO/NA");
                details.put("Provided", pl.getPlanInformation().getFireProtectionAndFireSafetyRequirements());
                details.put("Status", Result.Not_Accepted.getResultVal());
                scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
            }
        }
    }

    private boolean isCommercialAbv750sqm(Plan pl, OccupancyTypeHelper mostRestrictiveOccupancyType) {
        return pl.getVirtualBuilding() != null && mostRestrictiveOccupancyType != null && mostRestrictiveOccupancyType.getType() != null && "F".equalsIgnoreCase(mostRestrictiveOccupancyType.getType().getCode()) && pl.getVirtualBuilding().getTotalCoverageArea().compareTo(BigDecimal.valueOf(750L)) > 0;
    }

    private void validateBarrierFreeAccess(Plan pl, HashMap<String, String> errors) {
        ScrutinyDetail scrutinyDetail = this.getNewScrutinyDetail("Barrier Free Access For Physically Challenged People");
        if (pl.getVirtualBuilding() != null && pl.getVirtualBuilding().getMostRestrictiveFarHelper() != null && pl.getVirtualBuilding().getMostRestrictiveFarHelper().getSubtype() != null && !"A-R".equals(pl.getVirtualBuilding().getMostRestrictiveFarHelper().getSubtype().getCode()) && pl.getPlot() != null && pl.getPlot().getArea().compareTo(new BigDecimal(2000)) > 0) {
            if (pl.getPlanInformation() != null && !pl.getPlanInformation().getBarrierFreeAccessForPhyChlngdPpl().isEmpty() && "YES".equals(pl.getPlanInformation().getBarrierFreeAccessForPhyChlngdPpl())) {
                HashMap<String, String> details = new HashMap<String, String>();
                details.put("Byelaw", RULE_50);
                details.put("Description", BARRIER_FREE_ACCESS_FOR_PHYSICALLY_CHALLENGED_PEOPLE_DESC);
                details.put("Permissible", "YES");
                details.put("Provided", "YES");
                details.put("Status", Result.Accepted.getResultVal());
                scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
            } else {
                HashMap<String, String> details = new HashMap<String, String>();
                details.put("Byelaw", RULE_50);
                details.put("Description", BARRIER_FREE_ACCESS_FOR_PHYSICALLY_CHALLENGED_PEOPLE_DESC);
                details.put("Permissible", "YES");
                details.put("Provided", pl.getPlanInformation().getBarrierFreeAccessForPhyChlngdPpl());
                details.put("Status", Result.Not_Accepted.getResultVal());
                scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
            }
        }
    }

    private void validateNumberOfFloors(Plan pl, HashMap<String, String> errors, String typeOfArea, BigDecimal roadWidth) {
        for (Block block : pl.getBlocks()) {
            boolean isAccepted = false;
            ScrutinyDetail scrutinyDetail = this.getNewScrutinyDetailRoadArea("Block_" + block.getNumber() + "_Number of Floors");
            BigDecimal floorAbvGround = block.getBuilding().getFloorsAboveGround();
            String requiredFloorCount = "";
            if (typeOfArea.equalsIgnoreCase(OLD)) {
                if (roadWidth.compareTo(ROAD_WIDTH_TWO_POINTFOUR) < 0) {
                    errors.put(OLD_AREA_ERROR, OLD_AREA_ERROR_MSG);
                    pl.addErrors(errors);
                } else if (roadWidth.compareTo(ROAD_WIDTH_TWO_POINTFOURFOUR) >= 0 && roadWidth.compareTo(ROAD_WIDTH_THREE_POINTSIX) < 0) {
                    isAccepted = floorAbvGround.compareTo(TWO) <= 0;
                    requiredFloorCount = "<= 2";
                } else if (roadWidth.compareTo(ROAD_WIDTH_THREE_POINTSIX) >= 0 && roadWidth.compareTo(ROAD_WIDTH_FOUR_POINTEIGHT) < 0) {
                    isAccepted = floorAbvGround.compareTo(THREE) <= 0;
                    requiredFloorCount = "<= 3";
                } else if (roadWidth.compareTo(ROAD_WIDTH_FOUR_POINTEIGHT) >= 0 && roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) < 0) {
                    isAccepted = floorAbvGround.compareTo(THREE) <= 0;
                    requiredFloorCount = "<= 3";
                } else if (roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) >= 0 && roadWidth.compareTo(ROAD_WIDTH_NINE_POINTONE) < 0) {
                    isAccepted = floorAbvGround.compareTo(FOUR) <= 0;
                    requiredFloorCount = "<= 4";
                }
            }
            if (typeOfArea.equalsIgnoreCase(NEW)) {
                if (roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) < 0) {
                    errors.put(NEW_AREA_ERROR, NEW_AREA_ERROR_MSG);
                    pl.addErrors(errors);
                } else if (roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) >= 0 && roadWidth.compareTo(ROAD_WIDTH_NINE_POINTONE) < 0) {
                    isAccepted = floorAbvGround.compareTo(FOUR) <= 0;
                    requiredFloorCount = "<= 4";
                } else if (roadWidth.compareTo(ROAD_WIDTH_NINE_POINTONE) >= 0 && roadWidth.compareTo(ROAD_WIDTH_TWELVE_POINTTWO) < 0) {
                    isAccepted = floorAbvGround.compareTo(SIX) <= 0;
                    requiredFloorCount = "<= 6";
                }
            }
            if (!errors.isEmpty() || !StringUtils.isNotBlank((String)requiredFloorCount)) continue;
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("Byelaw", RULE_38);
            details.put("Description", NO_OF_FLOORS);
            details.put("Area Type", typeOfArea);
            details.put("Road Width", roadWidth.toString());
            details.put("Permissible", requiredFloorCount);
            details.put("Provided", String.valueOf(block.getBuilding().getFloorsAboveGround()));
            details.put("Status", isAccepted ? Result.Accepted.getResultVal() : Result.Not_Accepted.getResultVal());
            scrutinyDetail.getDetail().add(details);
            pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
        }
    }

    private void validateHeightOfBuilding(Plan pl, HashMap<String, String> errors, String typeOfArea, BigDecimal roadWidth) {
        for (Block block : pl.getBlocks()) {
            BigDecimal permitedHeight;
            List setBacks;
            boolean isAccepted = false;
            String ruleNo = RULE_38;
            ScrutinyDetail scrutinyDetail = this.getNewScrutinyDetailRoadArea("Block_" + block.getNumber() + "_Height of Building");
            String requiredBuildingHeight = "";
            BigDecimal buildingHeight = block.getBuilding().getBuildingHeight();
            if (typeOfArea.equalsIgnoreCase(OLD)) {
                if (roadWidth.compareTo(ROAD_WIDTH_TWO_POINTFOUR) < 0) {
                    errors.put(OLD_AREA_ERROR, OLD_AREA_ERROR_MSG);
                    pl.addErrors(errors);
                } else if (roadWidth.compareTo(ROAD_WIDTH_TWO_POINTFOURFOUR) >= 0 && roadWidth.compareTo(ROAD_WIDTH_THREE_POINTSIX) < 0) {
                    isAccepted = buildingHeight.compareTo(SEVEN) <= 0;
                    requiredBuildingHeight = "<= 7";
                } else if (roadWidth.compareTo(ROAD_WIDTH_THREE_POINTSIX) >= 0 && roadWidth.compareTo(ROAD_WIDTH_FOUR_POINTEIGHT) < 0) {
                    isAccepted = buildingHeight.compareTo(TEN) <= 0;
                    requiredBuildingHeight = "<= 10";
                } else if (roadWidth.compareTo(ROAD_WIDTH_FOUR_POINTEIGHT) >= 0 && roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) < 0) {
                    isAccepted = buildingHeight.compareTo(TEN) <= 0;
                    requiredBuildingHeight = "<= 10";
                } else if (roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) >= 0 && roadWidth.compareTo(ROAD_WIDTH_NINE_POINTONE) < 0) {
                    isAccepted = buildingHeight.compareTo(TWELVE) <= 0;
                    requiredBuildingHeight = "<= 12";
                } else if (roadWidth.compareTo(ROAD_WIDTH_NINE_POINTONE) >= 0) {
                    setBacks = block.getSetBacks();
                    permitedHeight = this.getPermitedHeight(roadWidth, setBacks);
                    isAccepted = buildingHeight.compareTo(permitedHeight) <= 0;
                    requiredBuildingHeight = "<=" + permitedHeight.toString();
                    ruleNo = RULE_39;
                }
            }
            if (typeOfArea.equalsIgnoreCase(NEW)) {
                if (roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) < 0) {
                    errors.put(NEW_AREA_ERROR, NEW_AREA_ERROR_MSG);
                    pl.addErrors(errors);
                } else if (roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) >= 0 && roadWidth.compareTo(ROAD_WIDTH_NINE_POINTONE) < 0) {
                    isAccepted = buildingHeight.compareTo(TWELVE) <= 0;
                    requiredBuildingHeight = "<= 12";
                } else if (roadWidth.compareTo(ROAD_WIDTH_NINE_POINTONE) >= 0 && roadWidth.compareTo(ROAD_WIDTH_TWELVE_POINTTWO) < 0) {
                    isAccepted = buildingHeight.compareTo(NINETEEN) <= 0;
                    requiredBuildingHeight = "<= 19";
                } else if (roadWidth.compareTo(ROAD_WIDTH_TWELVE_POINTTWO) > 0) {
                    setBacks = block.getSetBacks();
                    permitedHeight = this.getPermitedHeight(roadWidth, setBacks);
                    isAccepted = buildingHeight.compareTo(permitedHeight) <= 0;
                    requiredBuildingHeight = "<=" + permitedHeight.toString();
                }
            }
            if (!errors.isEmpty() || !StringUtils.isNotBlank((String)requiredBuildingHeight)) continue;
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("Byelaw", ruleNo);
            details.put("Description", HEIGHT_BUILDING);
            details.put("Area Type", typeOfArea);
            details.put("Road Width", roadWidth.toString());
            details.put("Permissible", requiredBuildingHeight);
            details.put("Provided", String.valueOf(buildingHeight));
            details.put("Status", isAccepted ? Result.Accepted.getResultVal() : Result.Not_Accepted.getResultVal());
            scrutinyDetail.getDetail().add(details);
            pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
        }
    }

    private BigDecimal getPermitedHeight(BigDecimal roadWidth, List<SetBack> setBacks) {
        BigDecimal frontYardHeight = BigDecimal.ZERO;
        for (SetBack setBack : setBacks) {
            Yard frontYard = setBack.getFrontYard();
            frontYardHeight = frontYard != null && frontYard.getMinimumDistance() != null ? frontYard.getMinimumDistance() : frontYardHeight;
        }
        BigDecimal sum = roadWidth.add(frontYardHeight);
        return ONE_POINTFIVE.multiply(sum).setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS);
    }

    private void validatePlinthHeight(Plan pl, HashMap<String, String> errors) {
        for (Block block : pl.getBlocks()) {
            boolean isAccepted = false;
            BigDecimal minPlinthHeight = BigDecimal.ZERO;
            String blkNo = block.getNumber();
            ScrutinyDetail scrutinyDetail = this.getNewScrutinyDetail("Block_" + blkNo + "_Plinth");
            List plinthHeights = block.getPlinthHeight();
            if (!plinthHeights.isEmpty()) {
                minPlinthHeight = (BigDecimal)plinthHeights.stream().reduce(BigDecimal::min).get();
                if (minPlinthHeight.compareTo(BigDecimal.valueOf(0.45)) >= 0) {
                    isAccepted = true;
                }
            } else {
                String plinthHeightLayer = String.format("BLK_%s_PLINTH_HEIGHT", block.getNumber());
                errors.put(plinthHeightLayer, "Plinth height is not defined in layer " + plinthHeightLayer);
                pl.addErrors(errors);
            }
            if (!errors.isEmpty()) continue;
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("Byelaw", RULE_41_I_A);
            details.put("Description", MIN_PLINTH_HEIGHT_DESC);
            details.put("Permissible", MIN_PLINTH_HEIGHT);
            details.put("Provided", String.valueOf(minPlinthHeight));
            details.put("Status", isAccepted ? Result.Accepted.getResultVal() : Result.Not_Accepted.getResultVal());
            scrutinyDetail.getDetail().add(details);
            pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
        }
    }

    private void validateBasement(Plan pl, HashMap<String, String> errors) {
        for (Block block : pl.getBlocks()) {
            OccupancyTypeHelper mostRestrictiveFarHelper;
            boolean isAccepted = false;
            String allowedBsmnt = null;
            String blkNo = block.getNumber();
            ScrutinyDetail scrutinyDetail = this.getNewScrutinyDetail("Block_" + blkNo + "_Basement/Cellar");
            List setBacks = block.getSetBacks();
            List basementSetbacks = setBacks.stream().filter(setback -> setback.getLevel() < 0).collect(Collectors.toList());
            OccupancyTypeHelper occupancyTypeHelper = mostRestrictiveFarHelper = pl.getVirtualBuilding() != null ? pl.getVirtualBuilding().getMostRestrictiveFarHelper() : null;
            if (basementSetbacks.isEmpty()) continue;
            if (mostRestrictiveFarHelper != null && mostRestrictiveFarHelper.getType() != null && ("A-AF".equalsIgnoreCase(mostRestrictiveFarHelper.getSubtype().getCode()) || "A-R".equalsIgnoreCase(mostRestrictiveFarHelper.getSubtype().getCode()) || "F".equalsIgnoreCase(mostRestrictiveFarHelper.getType().getCode())) && pl.getPlot() != null && pl.getPlot().getArea().compareTo(BigDecimal.valueOf(300L)) <= 0) {
                isAccepted = basementSetbacks.size() <= 1;
                allowedBsmnt = "1";
            } else if (mostRestrictiveFarHelper != null && mostRestrictiveFarHelper.getType() != null && mostRestrictiveFarHelper.getSubtype() != null && ("A-AF".equalsIgnoreCase(mostRestrictiveFarHelper.getSubtype().getCode()) || "A-R".equalsIgnoreCase(mostRestrictiveFarHelper.getSubtype().getCode()) || "F".equalsIgnoreCase(mostRestrictiveFarHelper.getType().getCode()))) {
                isAccepted = basementSetbacks.size() <= 2;
                allowedBsmnt = "2";
            }
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("Byelaw", RULE_47);
            details.put("Description", MAX_BSMNT_CELLAR);
            details.put("Permissible", allowedBsmnt);
            details.put("Provided", String.valueOf(basementSetbacks.size()));
            details.put("Status", isAccepted ? Result.Accepted.getResultVal() : Result.Not_Accepted.getResultVal());
            scrutinyDetail.getDetail().add(details);
            pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
        }
    }

    private void validateGreenBuildingsAndSustainability(Plan pl, HashMap<String, String> errors) {
        OccupancyTypeHelper mostRestrictiveFarHelper = pl.getVirtualBuilding() != null ? pl.getVirtualBuilding().getMostRestrictiveFarHelper() : null;
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.setKey("Common_Green buildings and sustainability provisions");
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        if (pl.getPlot() != null && pl.getPlot().getArea().compareTo(BigDecimal.valueOf(100L)) >= 0) {
            if (StringUtils.isNotBlank((String)pl.getPlanInformation().getProvisionsForGreenBuildingsAndSustainability()) && pl.getPlanInformation().getProvisionsForGreenBuildingsAndSustainability().equals("YES")) {
                if (mostRestrictiveFarHelper != null && mostRestrictiveFarHelper.getType() != null && "A".equalsIgnoreCase(mostRestrictiveFarHelper.getType().getCode())) {
                    if (pl.getPlot().getArea().compareTo(BigDecimal.valueOf(100L)) >= 0 && pl.getPlot().getArea().compareTo(BigDecimal.valueOf(500L)) < 0) {
                        this.validate1a(pl, scrutinyDetail);
                        this.validate2a(pl, scrutinyDetail);
                        this.validate2b(pl, scrutinyDetail);
                        this.validate4a(pl, scrutinyDetail);
                    } else if (pl.getPlot().getArea().compareTo(BigDecimal.valueOf(500L)) >= 0 && pl.getPlot().getArea().compareTo(BigDecimal.valueOf(1000L)) < 0) {
                        this.validate1a(pl, scrutinyDetail);
                        this.validate2b(pl, scrutinyDetail);
                        this.validate4a(pl, scrutinyDetail);
                    } else if (pl.getPlot().getArea().compareTo(BigDecimal.valueOf(1000L)) >= 0 && pl.getPlot().getArea().compareTo(BigDecimal.valueOf(3000L)) < 0) {
                        this.validate1a(pl, scrutinyDetail);
                        this.validate2a(pl, scrutinyDetail);
                        this.validate2b(pl, scrutinyDetail);
                        this.validate4a(pl, scrutinyDetail);
                    } else {
                        this.validate1a(pl, scrutinyDetail);
                        this.validate2a(pl, scrutinyDetail);
                        this.validate2b(pl, scrutinyDetail);
                        this.validate4a(pl, scrutinyDetail);
                    }
                } else if (pl.getPlot().getArea().compareTo(BigDecimal.valueOf(100L)) >= 0 && pl.getPlot().getArea().compareTo(BigDecimal.valueOf(500L)) < 0) {
                    this.validate1a(pl, scrutinyDetail);
                    this.validate2b(pl, scrutinyDetail);
                    this.validate4a(pl, scrutinyDetail);
                } else if (pl.getPlot().getArea().compareTo(BigDecimal.valueOf(500L)) >= 0 && pl.getPlot().getArea().compareTo(BigDecimal.valueOf(1000L)) < 0) {
                    this.validate1a(pl, scrutinyDetail);
                    this.validate2a(pl, scrutinyDetail);
                    this.validate2b(pl, scrutinyDetail);
                    this.validate4a(pl, scrutinyDetail);
                } else if (pl.getPlot().getArea().compareTo(BigDecimal.valueOf(1000L)) >= 0 && pl.getPlot().getArea().compareTo(BigDecimal.valueOf(3000L)) < 0) {
                    this.validate1a(pl, scrutinyDetail);
                    this.validate2a(pl, scrutinyDetail);
                    this.validate2b(pl, scrutinyDetail);
                    this.validate4a(pl, scrutinyDetail);
                } else {
                    this.validate1a(pl, scrutinyDetail);
                    this.validate2a(pl, scrutinyDetail);
                    this.validate2b(pl, scrutinyDetail);
                    this.validate4a(pl, scrutinyDetail);
                }
                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
            } else {
                errors.put("Green buildings and sustainability provisions", GREEN_BUILDINGS_AND_SUSTAINABILITY_PROVISIONS_ERROR_MSG);
                pl.addErrors(errors);
            }
        }
    }

    private void validate4a(Plan pl, ScrutinyDetail scrutinyDetail) {
        if (pl.getUtility().getSegregationOfWaste() != null && !pl.getUtility().getSegregationOfWaste().isEmpty()) {
            this.addDetails(scrutinyDetail, "55-4-a", "Segregation of Waste", "Segregation of waste details", "Provided segregation of waste details", Result.Accepted.getResultVal());
        } else {
            this.addDetails(scrutinyDetail, "55-4-a", "Segregation of Waste", "Segregation of waste details", "Not provided segregation of waste details", Result.Not_Accepted.getResultVal());
        }
    }

    private void validate2b(Plan pl, ScrutinyDetail scrutinyDetail) {
        if (pl.getUtility().getSolarWaterHeatingSystems() != null && !pl.getUtility().getSolarWaterHeatingSystems().isEmpty()) {
            this.addDetails(scrutinyDetail, "55-2-b", "Installation of Solar Assisted Water Heating Systems", "Solar assisted water heating system details", "Provided solar assisted water heating system details", Result.Accepted.getResultVal());
        } else {
            this.addDetails(scrutinyDetail, "55-2-b", "Installation of Solar Assisted Water Heating Systems", "Solar assisted water heating system details", "Not provided solar assisted water heating system details", Result.Not_Accepted.getResultVal());
        }
    }

    private void validate2a(Plan pl, ScrutinyDetail scrutinyDetail) {
        if (pl.getUtility().getSolar() != null && !pl.getUtility().getSolar().isEmpty()) {
            this.addDetails(scrutinyDetail, "55-2-a", "Installation of Solar Photovoltaic Panels", "Solar photovoltaic panel details", "Provided solar photovoltaic panel details", Result.Accepted.getResultVal());
        } else {
            this.addDetails(scrutinyDetail, "55-2-a", "Installation of Solar Photovoltaic Panels", "Solar photovoltaic panel details", "Not provided solar photovoltaic panel details", Result.Not_Accepted.getResultVal());
        }
    }

    private void validate1a(Plan pl, ScrutinyDetail scrutinyDetail) {
        if (pl.getUtility().getRainWaterHarvest() != null && !pl.getUtility().getRainWaterHarvest().isEmpty()) {
            this.addDetails(scrutinyDetail, "55-1-a", "Rain Water Harvesting", "Rain water harvesting details", "Provided rain water harvesting", Result.Accepted.getResultVal());
        } else {
            this.addDetails(scrutinyDetail, "55-1-a", "Rain Water Harvesting", "Rain water harvesting details", "Not Provided rain water harvesting", Result.Not_Accepted.getResultVal());
        }
    }

    private void addDetails(ScrutinyDetail scrutinyDetail, String rule, String description, String required, String provided, String status) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", rule);
        details.put("Description", description);
        details.put("Required", required);
        details.put("Provided", provided);
        details.put("Status", status);
        scrutinyDetail.getDetail().add(details);
    }

    private ScrutinyDetail getNewScrutinyDetailRoadArea(String key) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Area Type");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Road Width");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Permissible");
        scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(7), "Status");
        scrutinyDetail.setKey(key);
        return scrutinyDetail;
    }

    private ScrutinyDetail getNewScrutinyDetail(String key) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Permissible");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        scrutinyDetail.setKey(key);
        return scrutinyDetail;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

