/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.egov.common.entity.edcr.AccessoryBlock;
import org.egov.common.entity.edcr.CulDeSacRoad;
import org.egov.common.entity.edcr.Lane;
import org.egov.common.entity.edcr.NonNotifiedRoad;
import org.egov.common.entity.edcr.NotifiedRoad;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class AccessoryBuildingService
extends FeatureProcess {
    private static final String SUBRULE_88_1_DESC = "Maximum area of accessory block %s";
    private static final String SUBRULE_88_3_DESC = "Maximum height of accessory block %s";
    private static final String SUBRULE_88_1 = "88-1";
    private static final String SUBULE_88_3 = "88-3";
    private static final String SUBRULE_88_4 = "88-4";
    private static final String SUBRULE_88_5 = "88-5";
    private static final String MIN_DIS_NOTIFIED_ROAD_FROM_ACC_BLDG = "Minimum distance from accessory block to notified road";
    private static final String MIN_DIS_NON_NOTIFIED_ROAD_FROM_ACC_BLDG = "Minimum distance from accessory building to non notified road";
    private static final String MIN_DIS_CULDESAC_ROAD_FROM_ACC_BLDG = "Minimum distance from accessory building to culdesac road";
    private static final String MIN_DIS_LANE_ROAD_FROM_ACC_BLDG = "Minimum distance from accessory building to lane road";
    private static final String SUBRULE_88_5_DESC = "Minimum distance from accessory block %s to plot boundary";

    @Override
    public Plan validate(Plan plan) {
        return plan;
    }

    private void validateMinimumDistanceOfAccBlkToPlotBndry(Plan pl, HashMap<String, String> errors) {
        if (pl != null && !pl.getAccessoryBlocks().isEmpty()) {
            for (AccessoryBlock accessoryBlock : pl.getAccessoryBlocks()) {
                if (accessoryBlock.getNumber() == null || accessoryBlock.getAccessoryBuilding() == null || !accessoryBlock.getAccessoryBuilding().getDistanceFromPlotBoundary().isEmpty()) continue;
                errors.put(String.format("Accessory block %s distance from plot boundary", accessoryBlock.getNumber()), this.edcrMessageSource.getMessage("msg.error.not.defined", (Object[])new String[]{String.format("Accessory block %s distance from plot boundary", accessoryBlock.getNumber())}, LocaleContextHolder.getLocale()));
                pl.addErrors(errors);
            }
        }
    }

    @Override
    public Plan process(Plan plan) {
        return plan;
    }

    private void processShortestDistanceOfAccBlkFromPlotBoundary(Plan plan) {
        String subRule = SUBRULE_88_5;
        ScrutinyDetail scrutinyDetail3 = new ScrutinyDetail();
        scrutinyDetail3.setKey("Common_Accessory Block - Minimum distance from plot boundary");
        scrutinyDetail3.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail3.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail3.addColumnHeading(Integer.valueOf(3), "Required");
        scrutinyDetail3.addColumnHeading(Integer.valueOf(4), "Provided");
        scrutinyDetail3.addColumnHeading(Integer.valueOf(5), "Status");
        if (plan != null && !plan.getAccessoryBlocks().isEmpty()) {
            for (AccessoryBlock accessoryBlock : plan.getAccessoryBlocks()) {
                boolean valid = false;
                if (accessoryBlock.getAccessoryBuilding() == null || accessoryBlock.getAccessoryBuilding().getDistanceFromPlotBoundary().isEmpty()) continue;
                BigDecimal minimumAccBlkDisFromPlotBoundary = (BigDecimal)accessoryBlock.getAccessoryBuilding().getDistanceFromPlotBoundary().get(0);
                for (BigDecimal disOfAccBlkFromPlotBndry : accessoryBlock.getAccessoryBuilding().getDistanceFromPlotBoundary()) {
                    if (minimumAccBlkDisFromPlotBoundary.compareTo(disOfAccBlkFromPlotBndry) <= 0) continue;
                    minimumAccBlkDisFromPlotBoundary = disOfAccBlkFromPlotBndry;
                }
                if (minimumAccBlkDisFromPlotBoundary.compareTo(BigDecimal.valueOf(1L)) >= 0) {
                    valid = true;
                }
                if (valid) {
                    this.setReportOutputDetails(plan, subRule, String.format(SUBRULE_88_5_DESC, accessoryBlock.getNumber()), String.valueOf(1), minimumAccBlkDisFromPlotBoundary.toString(), Result.Accepted.getResultVal(), scrutinyDetail3);
                    continue;
                }
                this.setReportOutputDetails(plan, subRule, String.format(SUBRULE_88_5_DESC, accessoryBlock.getNumber()), String.valueOf(1), minimumAccBlkDisFromPlotBoundary.toString(), Result.Not_Accepted.getResultVal(), scrutinyDetail3);
            }
        }
    }

    private void processShortestDistanceOfAccBlkFromRoad(Plan plan) {
        String subRule = SUBRULE_88_4;
        ScrutinyDetail scrutinyDetail2 = new ScrutinyDetail();
        scrutinyDetail2.setKey("Common_Accessory Block - Minimum distance from the boundary abutting the road");
        scrutinyDetail2.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail2.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail2.addColumnHeading(Integer.valueOf(3), "Required");
        scrutinyDetail2.addColumnHeading(Integer.valueOf(4), "Provided");
        scrutinyDetail2.addColumnHeading(Integer.valueOf(5), "Status");
        if (plan != null && plan.getPlot() != null && plan.getPlot().getArea() != null && plan.getPlot().getArea().compareTo(BigDecimal.valueOf(0L)) > 0) {
            if (plan.getPlot().getArea().compareTo(BigDecimal.valueOf(125L)) > 0) {
                this.processNotifiedRoads(plan, subRule, scrutinyDetail2);
                this.processNonNotifiedRoadsForPlotExceeding125(plan, subRule, scrutinyDetail2);
                this.processCuldesacRoad(plan, subRule, scrutinyDetail2);
                this.processLaneRoads(plan, subRule, scrutinyDetail2);
            } else if (plan.getPlot().getArea().compareTo(BigDecimal.valueOf(125L)) < 0) {
                this.processNotifiedRoads(plan, subRule, scrutinyDetail2);
                this.processNonNotifiedRoadsPlotLessThan125(plan, subRule, scrutinyDetail2);
                this.processCuldesacRoad(plan, subRule, scrutinyDetail2);
                this.processLaneRoads(plan, subRule, scrutinyDetail2);
            }
        }
    }

    private void processNonNotifiedRoadsPlotLessThan125(Plan plan, String subRule, ScrutinyDetail scrutinyDetail2) {
        if (!plan.getNonNotifiedRoads().isEmpty() && !((NonNotifiedRoad)plan.getNonNotifiedRoads().get(0)).getDistanceFromAccessoryBlock().isEmpty()) {
            boolean valid = false;
            BigDecimal minimumDisFmNonNotifiedRoad = (BigDecimal)((NonNotifiedRoad)plan.getNonNotifiedRoads().get(0)).getDistanceFromAccessoryBlock().get(0);
            for (BigDecimal disFrmAccBldg : ((NonNotifiedRoad)plan.getNonNotifiedRoads().get(0)).getDistanceFromAccessoryBlock()) {
                if (disFrmAccBldg.compareTo(minimumDisFmNonNotifiedRoad) >= 0) continue;
                minimumDisFmNonNotifiedRoad = disFrmAccBldg;
            }
            if (minimumDisFmNonNotifiedRoad.compareTo(BigDecimal.valueOf(2L)) >= 0) {
                valid = true;
            }
            if (valid) {
                this.setReportOutputDetails(plan, subRule, MIN_DIS_NON_NOTIFIED_ROAD_FROM_ACC_BLDG, String.valueOf(2), minimumDisFmNonNotifiedRoad.toString(), Result.Accepted.getResultVal(), scrutinyDetail2);
            } else {
                this.setReportOutputDetails(plan, subRule, MIN_DIS_NON_NOTIFIED_ROAD_FROM_ACC_BLDG, String.valueOf(2), minimumDisFmNonNotifiedRoad.toString(), Result.Not_Accepted.getResultVal(), scrutinyDetail2);
            }
        }
    }

    private void processNonNotifiedRoadsForPlotExceeding125(Plan plan, String subRule, ScrutinyDetail scrutinyDetail2) {
        if (!plan.getNonNotifiedRoads().isEmpty() && !((NonNotifiedRoad)plan.getNonNotifiedRoads().get(0)).getDistanceFromAccessoryBlock().isEmpty()) {
            boolean valid = false;
            BigDecimal minimumDisFmNonNotifiedRoad = (BigDecimal)((NonNotifiedRoad)plan.getNonNotifiedRoads().get(0)).getDistanceFromAccessoryBlock().get(0);
            for (BigDecimal disFrmAccBldg : ((NonNotifiedRoad)plan.getNonNotifiedRoads().get(0)).getDistanceFromAccessoryBlock()) {
                if (disFrmAccBldg.compareTo(minimumDisFmNonNotifiedRoad) >= 0) continue;
                minimumDisFmNonNotifiedRoad = disFrmAccBldg;
            }
            if (minimumDisFmNonNotifiedRoad.compareTo(BigDecimal.valueOf(3L)) >= 0) {
                valid = true;
            }
            if (valid) {
                this.setReportOutputDetails(plan, subRule, MIN_DIS_NON_NOTIFIED_ROAD_FROM_ACC_BLDG, String.valueOf(3), minimumDisFmNonNotifiedRoad.toString(), Result.Accepted.getResultVal(), scrutinyDetail2);
            } else {
                this.setReportOutputDetails(plan, subRule, MIN_DIS_NON_NOTIFIED_ROAD_FROM_ACC_BLDG, String.valueOf(3), minimumDisFmNonNotifiedRoad.toString(), Result.Not_Accepted.getResultVal(), scrutinyDetail2);
            }
        }
    }

    private void processLaneRoads(Plan plan, String subRule, ScrutinyDetail scrutinyDetail2) {
        if (!plan.getLaneRoads().isEmpty() && !((Lane)plan.getLaneRoads().get(0)).getDistanceFromAccessoryBlock().isEmpty()) {
            boolean valid = false;
            BigDecimal minimumDisFmLaneRoad = (BigDecimal)((Lane)plan.getLaneRoads().get(0)).getDistanceFromAccessoryBlock().get(0);
            for (BigDecimal disFrmAccBldg : ((Lane)plan.getLaneRoads().get(0)).getDistanceFromAccessoryBlock()) {
                if (disFrmAccBldg.compareTo(minimumDisFmLaneRoad) >= 0) continue;
                minimumDisFmLaneRoad = disFrmAccBldg;
            }
            if (minimumDisFmLaneRoad.compareTo(BigDecimal.valueOf(1.5)) >= 0) {
                valid = true;
            }
            if (valid) {
                this.setReportOutputDetails(plan, subRule, MIN_DIS_LANE_ROAD_FROM_ACC_BLDG, String.valueOf(1.5), minimumDisFmLaneRoad.toString(), Result.Accepted.getResultVal(), scrutinyDetail2);
            } else {
                this.setReportOutputDetails(plan, subRule, MIN_DIS_LANE_ROAD_FROM_ACC_BLDG, String.valueOf(1.5), minimumDisFmLaneRoad.toString(), Result.Not_Accepted.getResultVal(), scrutinyDetail2);
            }
        }
    }

    private void processCuldesacRoad(Plan pl, String subRule, ScrutinyDetail scrutinyDetail2) {
        if (!pl.getCuldeSacRoads().isEmpty() && !((CulDeSacRoad)pl.getCuldeSacRoads().get(0)).getDistanceFromAccessoryBlock().isEmpty()) {
            boolean valid = false;
            BigDecimal minimumDisFmCuldesacRoad = (BigDecimal)((CulDeSacRoad)pl.getCuldeSacRoads().get(0)).getDistanceFromAccessoryBlock().get(0);
            for (BigDecimal disFrmAccBldg : ((CulDeSacRoad)pl.getCuldeSacRoads().get(0)).getDistanceFromAccessoryBlock()) {
                if (disFrmAccBldg.compareTo(minimumDisFmCuldesacRoad) >= 0) continue;
                minimumDisFmCuldesacRoad = disFrmAccBldg;
            }
            if (minimumDisFmCuldesacRoad.compareTo(BigDecimal.valueOf(2L)) >= 0) {
                valid = true;
            }
            if (valid) {
                this.setReportOutputDetails(pl, subRule, MIN_DIS_CULDESAC_ROAD_FROM_ACC_BLDG, String.valueOf(2), minimumDisFmCuldesacRoad.toString(), Result.Accepted.getResultVal(), scrutinyDetail2);
            } else {
                this.setReportOutputDetails(pl, subRule, MIN_DIS_CULDESAC_ROAD_FROM_ACC_BLDG, String.valueOf(2), minimumDisFmCuldesacRoad.toString(), Result.Not_Accepted.getResultVal(), scrutinyDetail2);
            }
        }
    }

    private void processNotifiedRoads(Plan plan, String subRule, ScrutinyDetail scrutinyDetail2) {
        if (!plan.getNotifiedRoads().isEmpty() && !((NotifiedRoad)plan.getNotifiedRoads().get(0)).getDistanceFromAccessoryBlock().isEmpty()) {
            boolean valid = false;
            BigDecimal minimumDisFmNotifiedRoad = (BigDecimal)((NotifiedRoad)plan.getNotifiedRoads().get(0)).getDistanceFromAccessoryBlock().get(0);
            for (BigDecimal disFrmAccBldg : ((NotifiedRoad)plan.getNotifiedRoads().get(0)).getDistanceFromAccessoryBlock()) {
                if (disFrmAccBldg.compareTo(minimumDisFmNotifiedRoad) >= 0) continue;
                minimumDisFmNotifiedRoad = disFrmAccBldg;
            }
            if (minimumDisFmNotifiedRoad.compareTo(BigDecimal.valueOf(3L)) >= 0) {
                valid = true;
            }
            if (valid) {
                this.setReportOutputDetails(plan, subRule, MIN_DIS_NOTIFIED_ROAD_FROM_ACC_BLDG, String.valueOf(3), minimumDisFmNotifiedRoad.toString(), Result.Accepted.getResultVal(), scrutinyDetail2);
            } else {
                this.setReportOutputDetails(plan, subRule, MIN_DIS_NOTIFIED_ROAD_FROM_ACC_BLDG, String.valueOf(3), minimumDisFmNotifiedRoad.toString(), Result.Not_Accepted.getResultVal(), scrutinyDetail2);
            }
        }
    }

    private void processHeightOfAccessoryBlock(Plan plan) {
        ScrutinyDetail scrutinyDetail1 = new ScrutinyDetail();
        scrutinyDetail1.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail1.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail1.addColumnHeading(Integer.valueOf(3), "Required");
        scrutinyDetail1.addColumnHeading(Integer.valueOf(4), "Provided");
        scrutinyDetail1.addColumnHeading(Integer.valueOf(5), "Status");
        scrutinyDetail1.setKey("Common_Accessory Block - Maximum Height");
        String subRuleDesc = SUBRULE_88_3_DESC;
        String subRule = SUBULE_88_3;
        if (plan != null && !plan.getAccessoryBlocks().isEmpty()) {
            for (AccessoryBlock accessoryBlock : plan.getAccessoryBlocks()) {
                Boolean valid = false;
                if (accessoryBlock.getAccessoryBuilding() == null || accessoryBlock.getAccessoryBuilding().getHeight() == null || accessoryBlock.getAccessoryBuilding().getHeight().compareTo(BigDecimal.valueOf(0L)) <= 0) continue;
                if (accessoryBlock.getAccessoryBuilding().getHeight().compareTo(BigDecimal.valueOf(2.5)) <= 0) {
                    valid = true;
                }
                if (valid.booleanValue()) {
                    this.setReportOutputDetails(plan, subRule, String.format(subRuleDesc, accessoryBlock.getNumber()), BigDecimal.valueOf(2.5) + "(MTR)", accessoryBlock.getAccessoryBuilding().getHeight() + "(MTR)", Result.Accepted.getResultVal(), scrutinyDetail1);
                    continue;
                }
                this.setReportOutputDetails(plan, subRule, String.format(subRuleDesc, accessoryBlock.getNumber()), BigDecimal.valueOf(2.5) + "(MTR)", accessoryBlock.getAccessoryBuilding().getHeight() + "(MTR)", Result.Not_Accepted.getResultVal(), scrutinyDetail1);
            }
        }
    }

    private void processAreaOfAccessoryBlock(Plan plan) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        scrutinyDetail.setKey("Common_Accessory Block - Maximum Area");
        String subRuleDesc = SUBRULE_88_1_DESC;
        String subRule = SUBRULE_88_1;
        if (plan != null && plan.getPlot() != null && plan.getPlot().getArea() != null && plan.getVirtualBuilding() != null && plan.getVirtualBuilding().getTotalCoverageArea() != null && plan.getVirtualBuilding().getTotalCoverageArea().compareTo(BigDecimal.valueOf(0L)) > 0) {
            BigDecimal fifteenPercentOfEmptyArea = plan.getPlot().getArea().subtract(plan.getVirtualBuilding().getTotalCoverageArea()).multiply(BigDecimal.valueOf(0.15));
            if (!plan.getAccessoryBlocks().isEmpty()) {
                for (AccessoryBlock accessoryBlock : plan.getAccessoryBlocks()) {
                    BigDecimal accessoryBlockArea = BigDecimal.ZERO;
                    if (accessoryBlock.getAccessoryBuilding() != null && accessoryBlock.getAccessoryBuilding().getArea() != null && accessoryBlock.getAccessoryBuilding().getArea().compareTo(BigDecimal.valueOf(0L)) > 0) {
                        accessoryBlockArea = accessoryBlock.getAccessoryBuilding().getArea();
                    }
                    Boolean valid = false;
                    if (fifteenPercentOfEmptyArea == null || fifteenPercentOfEmptyArea.compareTo(BigDecimal.ZERO) <= 0 || accessoryBlockArea == null || accessoryBlockArea.compareTo(BigDecimal.ZERO) <= 0) continue;
                    if (fifteenPercentOfEmptyArea.compareTo(accessoryBlockArea) >= 0) {
                        valid = true;
                    }
                    if (valid.booleanValue()) {
                        this.setReportOutputDetails(plan, subRule, String.format(subRuleDesc, accessoryBlock.getNumber()), fifteenPercentOfEmptyArea + "(MTRSQ)", accessoryBlockArea + "(MTRSQ)", Result.Accepted.getResultVal(), scrutinyDetail);
                        continue;
                    }
                    this.setReportOutputDetails(plan, subRule, String.format(subRuleDesc, accessoryBlock.getNumber()), fifteenPercentOfEmptyArea + "(MTRSQ)", accessoryBlockArea + "(MTRSQ)", Result.Not_Accepted.getResultVal(), scrutinyDetail);
                }
            }
        }
    }

    private void setReportOutputDetails(Plan plan, String ruleNo, String ruleDesc, String expected, String actual, String status, ScrutinyDetail scrutinyDetail) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        scrutinyDetail.getDetail().add(details);
        plan.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

