/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dcb.bean;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.dcb.bean.Payment;
import org.egov.infra.exception.ApplicationRuntimeException;

public class ChequePayment
extends Payment {
    private String instrumentNumber;
    private Date instrumentDate;
    private String bankName;
    private String branchName;
    private Long bankId;
    public static final String INSTRUMENTNUMBER = "instrumentNumber";
    public static final String INSTRUMENTDATE = "instrumentDate";
    public static final String BANKNAME = "bankName";
    public static final String BRANCHNAME = "branchName";
    public static final String BANKID = "bankId";
    private static final Logger LOGGER = Logger.getLogger(ChequePayment.class);
    public static final SimpleDateFormat CHEQUE_DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy");

    public static ChequePayment create(Map<String, String> paymentInfo) {
        return new ChequePayment(paymentInfo);
    }

    private ChequePayment(Map<String, String> paymentInfo) {
        this.validate(paymentInfo);
        LOGGER.debug((Object)("-Cheque Payment -paymentInfo " + paymentInfo));
        this.setPaymentMode(Payment.PAYMENTMODE.cheque);
        this.setInstrumentNumber(paymentInfo.get(INSTRUMENTNUMBER));
        try {
            this.setInstrumentDate(CHEQUE_DATE_FORMAT.parse(paymentInfo.get(INSTRUMENTDATE)));
        }
        catch (ParseException e) {
            throw new ApplicationRuntimeException("InstrumentDate-Date Format should be dd-MM-yyyy", (Throwable)e);
        }
        if (paymentInfo.get(BANKID) == null) {
            this.setBankName(paymentInfo.get(BANKNAME));
            this.setBankId(Long.valueOf(paymentInfo.get(BANKID)));
        } else {
            this.setBankId(Long.valueOf(paymentInfo.get(BANKID)));
        }
        if (paymentInfo.get(BRANCHNAME) != null) {
            this.setBranchName(paymentInfo.get(BRANCHNAME));
        }
        LOGGER.debug((Object)("-Cheque Payment is created " + this));
    }

    @Override
    public String toString() {
        return super.toString() + "instrumentNumber " + this.getInstrumentNumber() + " instrumentDate " + this.getInstrumentDate() + " bankName " + this.getBankName() + " branchName " + this.getBranchName();
    }

    public void validate(Map<String, String> paymentInfo) {
        if (paymentInfo != null && paymentInfo.isEmpty()) {
            throw new ApplicationRuntimeException(" paymentInfo is null.Please check. ");
        }
    }

    public String getInstrumentNumber() {
        return this.instrumentNumber;
    }

    public void setInstrumentNumber(String instrumentNumber) {
        this.instrumentNumber = instrumentNumber;
    }

    public Date getInstrumentDate() {
        return this.instrumentDate;
    }

    public void setInstrumentDate(Date instrumentDate) {
        this.instrumentDate = instrumentDate;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public Long getBankId() {
        return this.bankId;
    }

    public void setBankId(Long bankId) {
        this.bankId = bankId;
    }
}

