/*
 * Decompiled with CFR 0.152.
 */
package org.egov.demand.utils;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.egov.collection.handler.BillInfoMarshaller;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.collection.integration.models.BillDetails;
import org.egov.collection.integration.models.BillInfo;
import org.egov.collection.integration.models.BillInfoImpl;
import org.egov.collection.integration.models.BillPayeeDetails;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DemandUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DemandUtils.class);

    private DemandUtils() {
    }

    public static String generateBillXML(EgBill bill, String displayMsg) {
        String xmlData = "";
        try {
            if (bill != null && displayMsg != null) {
                xmlData = BillInfoMarshaller.toXML((Object)DemandUtils.prepareBillInfoXml(bill, displayMsg));
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Generated Bill XML \r\n {}", (Object)xmlData);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Exception in postBillCollectionDetails", (Throwable)ex);
        }
        return xmlData;
    }

    public static BillInfoImpl prepareBillInfoXml(EgBill bill, String displayMsg) {
        BillInfoImpl billInfo = null;
        try {
            if (bill != null) {
                ArrayList<String> collectionModes = new ArrayList<String>();
                if (StringUtils.isNotBlank((CharSequence)bill.getCollModesNotAllowed())) {
                    String[] collModes;
                    for (String collectionMode : collModes = bill.getCollModesNotAllowed().split(",")) {
                        collectionModes.add(collectionMode);
                    }
                }
                billInfo = new BillInfoImpl(bill.getServiceCode(), bill.getFundCode(), bill.getFunctionaryCode(), bill.getFundSourceCode(), bill.getDepartmentCode(), displayMsg, bill.getCitizenName(), bill.getPartPaymentAllowed(), bill.getOverrideAccountHeadsAllowed(), collectionModes, BillInfo.COLLECTIONTYPE.F);
                BillPayeeDetails billPayeeDetails = new BillPayeeDetails(bill.getCitizenName(), bill.getCitizenAddress(), bill.getEmailId());
                BillDetails billDetails = new BillDetails(bill.getId().toString(), bill.getCreateDate(), bill.getConsumerId(), bill.getConsumerType(), bill.getBoundaryNum().toString(), bill.getBoundaryType(), bill.getDescription(), bill.getTotalAmount(), bill.getMinAmtPayable());
                ArrayList<BillPayeeDetails> billPayeeDetList = new ArrayList<BillPayeeDetails>();
                billPayeeDetList.add(billPayeeDetails);
                billInfo.setPayees(billPayeeDetList);
                billInfo.setCallbackForApportioning(bill.getCallBackForApportion());
                for (EgBillDetails egBillDet : bill.getEgBillDetails()) {
                    boolean isActualDemand = egBillDet.getAdditionalFlag() == 1;
                    BillAccountDetails billAccDetails = new BillAccountDetails(egBillDet.getGlcode(), egBillDet.getOrderNo(), egBillDet.getCrAmount(), egBillDet.getDrAmount(), egBillDet.getFunctionCode(), egBillDet.getDescription(), Boolean.valueOf(isActualDemand), egBillDet.getPurpose() != null ? BillAccountDetails.PURPOSE.valueOf((String)egBillDet.getPurpose()) : BillAccountDetails.PURPOSE.OTHERS);
                    billDetails.addBillAccountDetails(billAccDetails);
                }
                billPayeeDetails.addBillDetails(billDetails);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error occurred while preparing Bill Details", (Throwable)ex);
        }
        return billInfo;
    }
}

