/*
 * Decompiled with CFR 0.152.
 */
package org.egov.demand.interfaces;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.demand.utils.DemandUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BillServiceInterface {
    public static final Logger LOGGER = Logger.getLogger(BillServiceInterface.class);
    @Autowired
    private EgBillDao egBillDAO;

    public String getBillXML(Billable billObj) {
        if (billObj == null) {
            throw new ApplicationRuntimeException("Billable object can't be null");
        }
        return this.generateXML(this.generateBill(billObj));
    }

    public String generateXML(EgBill bill) {
        if (bill == null) {
            throw new ApplicationRuntimeException("Bill object can't be null");
        }
        return DemandUtils.generateBillXML(bill, bill.getDisplayMessage());
    }

    public final EgBill generateBill(Billable billObj) {
        EgBill bill = new EgBill();
        bill.setBillNo(billObj.getReferenceNumber());
        bill.setBoundaryNum(billObj.getBoundaryNum().intValue());
        bill.setTransanctionReferenceNumber(billObj.getTransanctionReferenceNumber());
        bill.setBoundaryType(billObj.getBoundaryType());
        bill.setCitizenAddress(billObj.getBillAddress());
        bill.setCitizenName(billObj.getBillPayee());
        bill.setCollModesNotAllowed(billObj.getCollModesNotAllowed());
        bill.setDepartmentCode(billObj.getDepartmentCode());
        bill.setEgBillType(billObj.getBillType());
        bill.setFunctionaryCode(billObj.getFunctionaryCode());
        bill.setFundCode(billObj.getFundCode());
        bill.setFundSourceCode(billObj.getFundSourceCode());
        bill.setIssueDate(new Date());
        bill.setLastDate(billObj.getBillLastDueDate());
        bill.setModule(billObj.getModule());
        bill.setOverrideAccountHeadsAllowed(billObj.getOverrideAccountHeadsAllowed());
        bill.setPartPaymentAllowed(billObj.getPartPaymentAllowed());
        bill.setServiceCode(billObj.getServiceCode());
        bill.setIs_Cancelled("N");
        bill.setIs_History("N");
        bill.setModifiedDate(new Date());
        bill.setTotalAmount(billObj.getTotalAmount());
        bill.setUserId(billObj.getUserId());
        bill.setCreateDate(new Date());
        EgDemand currentDemand = billObj.getCurrentDemand();
        bill.setEgDemand(currentDemand);
        bill.setDescription(billObj.getDescription());
        bill.setDisplayMessage(billObj.getDisplayMessage());
        bill.setEmailId(billObj.getEmailId());
        if (currentDemand != null && currentDemand.getMinAmtPayable() != null) {
            bill.setMinAmtPayable(currentDemand.getMinAmtPayable());
        } else {
            bill.setMinAmtPayable(BigDecimal.ZERO);
        }
        List<EgBillDetails> bd = this.getBilldetails(billObj);
        for (EgBillDetails billdetails : bd) {
            bill.addEgBillDetails(billdetails);
            billdetails.setEgBill(bill);
        }
        bill.setConsumerId(billObj.getConsumerId());
        bill.setConsumerType(billObj.getConsumerType());
        bill.setCallBackForApportion(billObj.isCallbackForApportion());
        this.egBillDAO.create(bill);
        return bill;
    }

    public abstract List<EgBillDetails> getBilldetails(Billable var1);

    public abstract void cancelBill();
}

