/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dcb.bean;

import java.math.BigDecimal;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.commons.Bank;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.dcb.bean.AtmPayment;
import org.egov.dcb.bean.CashPayment;
import org.egov.dcb.bean.ChequePayment;
import org.egov.dcb.bean.CreditCardPayment;
import org.egov.dcb.bean.DDPayment;
import org.egov.dcb.bean.OnlinePayment;
import org.egov.infra.exception.ApplicationRuntimeException;

public abstract class Payment {
    public static final String CHEQUE = "cheque";
    public static final String DD = "dd";
    public static final String CREDITCARD = "creditcard";
    public static final String ATMCARD = "atmcard";
    public static final String ONLINE = "online";
    public static final String CASH = "cash";
    public static final String BANK_TO_BANK = "banktobank";
    public static final String PAIDBY = "paidBy";
    public static final String AMOUNT = "amount";
    private BigDecimal amount;
    private PAYMENTMODE paymentMode;
    private String paidBy;
    private BankHibernateDAO bankHibernateDAO;
    private String depositedInBankCode;
    private String paymentReferenceNoFromBank;
    private static final Logger LOGGER = Logger.getLogger(Payment.class);

    public static Payment create(String type, Map<String, String> paymentInfo) {
        LOGGER.debug((Object)("-Creating payment ---" + type + " paymentInfo " + paymentInfo));
        Payment.validate(type, paymentInfo);
        Payment payment = null;
        if (type.equals(CHEQUE)) {
            payment = ChequePayment.create(paymentInfo);
        } else if (type.equals(DD)) {
            payment = DDPayment.create(paymentInfo);
        } else if (type.equals(CREDITCARD)) {
            payment = CreditCardPayment.create(paymentInfo);
        } else if (type.equals(ATMCARD)) {
            payment = AtmPayment.create(paymentInfo);
        } else if (type.equals(ONLINE)) {
            payment = OnlinePayment.create(paymentInfo);
        } else if (type.equals(CASH)) {
            payment = CashPayment.create();
        }
        payment.setAmount(new BigDecimal(paymentInfo.get(AMOUNT)));
        payment.setPaidBy(paymentInfo.get(PAIDBY));
        LOGGER.debug((Object)("Created payment=" + payment));
        return payment;
    }

    public String toString() {
        return "amount=" + this.getAmount() + " paymentMode=" + (Object)((Object)this.getPaymentMode()) + " paidBy=" + this.getPaidBy() + " depositedInBankCode=" + this.depositedInBankCode + " paymentRef=" + this.paymentReferenceNoFromBank;
    }

    private static void validate(String type, Map<String, String> paymentInfo) {
        if (type == null || type.isEmpty() || paymentInfo == null) {
            throw new ApplicationRuntimeException(" Either the type or PaymentInfo Map is null .Please Check " + type + " " + paymentInfo);
        }
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getPaidBy() {
        return this.paidBy;
    }

    public void setPaidBy(String paidBy) {
        this.paidBy = paidBy;
    }

    protected Long fetchBankIDFromCodeOrName(String bankCodeOrName) {
        Bank bank = this.bankHibernateDAO.getBankByCode(bankCodeOrName);
        if (bank == null) {
            bank = this.bankHibernateDAO.getBankByCode(bankCodeOrName);
        }
        return new Long(bank.getId().intValue());
    }

    public String getPaymentReferenceNoFromBank() {
        return this.paymentReferenceNoFromBank;
    }

    public void setPaymentReferenceNoFromBank(String paymentReferenceNoFromBank) {
        this.paymentReferenceNoFromBank = paymentReferenceNoFromBank;
    }

    public String getDepositedInBankCode() {
        return this.depositedInBankCode;
    }

    public void setDepositedInBankCode(String depositedInBankCode) {
        this.depositedInBankCode = depositedInBankCode;
    }

    public PAYMENTMODE getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PAYMENTMODE paymentMode) {
        this.paymentMode = paymentMode;
    }

    public BankHibernateDAO getBankHibernateDAO() {
        return this.bankHibernateDAO;
    }

    public void setBankHibernateDAO(BankHibernateDAO bankHibernateDAO) {
        this.bankHibernateDAO = bankHibernateDAO;
    }

    public static enum PAYMENTMODE {
        cash,
        cheque,
        dd,
        cc,
        b2b,
        atm,
        online;

    }
}

