/*
 * Decompiled with CFR 0.152.
 */
package org.egov.demand.integration;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.egov.InvalidAccountHeadException;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.ReceiptAccountInfo;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.dao.EgBillDetailsDao;
import org.egov.demand.dao.EgBillReceiptDao;
import org.egov.demand.model.BillReceipt;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.hibernate.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BillTaxCollection {
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    @Qualifier(value="egBillDetailsDAO")
    private EgBillDetailsDao egBillDetailsDAO;
    @Autowired
    private EgBillReceiptDao egBillReceiptDAO;

    public BillReceipt linkBillToReceipt(BillReceiptInfo bri) throws InvalidAccountHeadException, ObjectNotFoundException {
        BillReceipt billRecpt = null;
        try {
            if (bri != null) {
                billRecpt = new BillReceipt();
                EgBill egBill = this.egBillDAO.findById(Long.valueOf(bri.getBillReferenceNum()), false);
                List<EgBillDetails> billDetList = this.egBillDetailsDAO.getBillDetailsByBill(egBill);
                BigDecimal totalCollectedAmt = this.calculateTotalCollectedAmt(bri, billDetList);
                billRecpt.setBillId(egBill);
                billRecpt.setReceiptAmt(totalCollectedAmt);
                billRecpt.setReceiptNumber(bri.getReceiptNum());
                billRecpt.setReceiptDate(bri.getReceiptDate());
                billRecpt.setCollectionStatus(bri.getReceiptStatus().getCode());
                billRecpt.setIsCancelled(Boolean.FALSE);
                billRecpt.setCreatedBy(bri.getCreatedBy());
                billRecpt.setModifiedBy(bri.getModifiedBy());
                billRecpt.setCreatedDate(new Date());
                billRecpt.setModifiedDate(new Date());
                this.egBillReceiptDAO.create(billRecpt);
            }
        }
        catch (ApplicationRuntimeException e) {
            throw new ApplicationRuntimeException("Exception in linkBillToReceipt" + (Object)((Object)e));
        }
        return billRecpt;
    }

    public EgBill updateBillDetails(BillReceiptInfo bri) throws InvalidAccountHeadException {
        EgBill egBill = null;
        try {
            if (bri != null) {
                egBill = this.egBillDAO.findById(Long.valueOf(bri.getBillReferenceNum()), false);
                List<EgBillDetails> billDetList = this.egBillDetailsDAO.getBillDetailsByBill(egBill);
                BigDecimal totalCollectedAmt = this.calculateTotalCollectedAmt(bri, billDetList);
                for (EgBillDetails billDet : billDetList) {
                    Boolean glCodeExist = false;
                    for (ReceiptAccountInfo acctDet : bri.getAccountDetails()) {
                        if (!billDet.getGlcode().equals(acctDet.getGlCode())) continue;
                        glCodeExist = true;
                        billDet.setCollectedAmount(acctDet.getCrAmount());
                        billDet.setCrAmount(acctDet.getCrAmount());
                        billDet.setDrAmount(acctDet.getDrAmount());
                        billDet.setOrderNo(1);
                        this.egBillDetailsDAO.update(billDet);
                    }
                    if (glCodeExist.booleanValue()) continue;
                    throw new InvalidAccountHeadException("GlCode does not exist for " + billDet.getGlcode());
                }
                egBill.setTotalCollectedAmount(totalCollectedAmt);
                this.egBillDAO.update(egBill);
            }
        }
        catch (ApplicationRuntimeException e) {
            throw new ApplicationRuntimeException("Exception in updateBillDetails" + (Object)((Object)e));
        }
        return egBill;
    }

    public BigDecimal calculateTotalCollectedAmt(BillReceiptInfo bri, List<EgBillDetails> billDetList) throws InvalidAccountHeadException {
        BigDecimal totalCollAmt = BigDecimal.ZERO;
        try {
            if (bri != null && billDetList != null) {
                for (EgBillDetails billDet : billDetList) {
                    Boolean glCodeExist = false;
                    for (ReceiptAccountInfo acctDet : bri.getAccountDetails()) {
                        if (!billDet.getGlcode().equals(acctDet.getGlCode())) continue;
                        glCodeExist = true;
                        totalCollAmt = totalCollAmt.add(acctDet.getCrAmount());
                    }
                    if (glCodeExist.booleanValue()) continue;
                    throw new InvalidAccountHeadException("GlCode does not exist for " + billDet.getGlcode());
                }
            }
        }
        catch (ApplicationRuntimeException e) {
            throw new ApplicationRuntimeException("Exception in calculate Total Collected Amt" + (Object)((Object)e));
        }
        return totalCollAmt;
    }
}

