/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dcb.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.egov.DCBException;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.dcb.bean.DCBDisplayInfo;
import org.egov.dcb.bean.DCBRecord;
import org.egov.dcb.bean.DCBReport;
import org.egov.dcb.bean.Receipt;
import org.egov.dcb.bean.ReceiptDetail;
import org.egov.dcb.service.DCBService;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.dao.EgDemandReasonMasterDao;
import org.egov.demand.dao.EgReasonCategoryDao;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReasonMaster;
import org.egov.demand.model.EgReasonCategory;
import org.egov.demand.model.EgdmCollectedReceipt;
import org.egov.infra.admin.master.entity.Module;
import org.springframework.beans.factory.annotation.Autowired;

public class DCBServiceImpl
implements DCBService {
    private static final Logger LOGGER = Logger.getLogger(DCBServiceImpl.class);
    @Autowired
    private EgReasonCategoryDao egReasonCategoryDAO;
    @Autowired
    private EgDemandReasonMasterDao egDemandReasonMasterDAO;
    @Autowired
    private DemandGenericDao demandGenericDAO;
    @Autowired
    private InstallmentHibDao installmentDAO;
    private Billable billable;

    public DCBServiceImpl() {
    }

    public DCBServiceImpl(Billable billable) {
        this.billable = billable;
    }

    @Override
    public DCBReport getCurrentDCBAndReceipts(DCBDisplayInfo dcbDispInfo) {
        this.validate();
        LOGGER.info((Object)("getCurrentDCBAndReceipts() called for: " + this.billable.getConsumerId()));
        DCBReport dcbReport = new DCBReport();
        this.populateDCB(dcbDispInfo, dcbReport);
        this.populateReceipts(dcbReport);
        LOGGER.info((Object)("getCurrentDCBAndReceipts() returned: " + dcbReport));
        return dcbReport;
    }

    @Override
    public DCBReport getCurrentDCBOnly(DCBDisplayInfo dcbDispInfo) {
        this.validate();
        LOGGER.info((Object)("getCurrentDCBOnly() called for: " + this.billable.getConsumerId()));
        DCBReport dcbReport = new DCBReport();
        this.populateDCB(dcbDispInfo, dcbReport);
        LOGGER.info((Object)("getCurrentDCBOnly() returned: " + dcbReport));
        return dcbReport;
    }

    @Override
    public DCBReport getReceiptsOnly() {
        this.validate();
        LOGGER.info((Object)("getReceiptsOnly() called for: " + this.billable.getConsumerId()));
        DCBReport dcbReport = new DCBReport();
        this.populateReceipts(dcbReport);
        LOGGER.info((Object)("getReceiptsOnly() returned: " + dcbReport));
        return dcbReport;
    }

    private void populateDCB(DCBDisplayInfo dcbDispInfo, DCBReport report) {
        EgDemand egDemand = this.billable.getCurrentDemand();
        List<EgDemandReasonMaster> reasonMaster = this.prepareReasonMasters(egDemand, dcbDispInfo);
        List<String> fieldNames = this.prepareFieldNames(reasonMaster, dcbDispInfo);
        Module module = this.getModuleFromDemand(egDemand);
        Map<Installment, DCBRecord> dcbReportMap = new TreeMap<Installment, DCBRecord>();
        dcbReportMap = this.iterateDCB(this.demandGenericDAO.getDCB(egDemand, module), dcbReportMap, fieldNames, egDemand);
        report.setFieldNames(fieldNames);
        report.setRecords(dcbReportMap);
        LOGGER.debug((Object)"Got DCB...");
    }

    private void populateReceipts(DCBReport report) {
        List<InstallmentReceiptTuple> tuples = this.enumerateTuples();
        Map<Installment, List<Receipt>> receipts = this.consolidateTuplesInstallmentWise(tuples);
        Map<Receipt, List<ReceiptDetail>> receiptBreakups = this.consolidateTuplesReceiptWise(tuples);
        report.setReceipts(receipts);
        report.backfillReceiptDetails(receiptBreakups);
        LOGGER.debug((Object)"Got receipts...");
    }

    Map<Installment, DCBRecord> iterateDCB(List dcbList, Map<Installment, DCBRecord> dcbReportMap, List<String> fieldNames, EgDemand dmd) {
        if (dcbList != null && fieldNames != null && !fieldNames.isEmpty()) {
            Installment installment = null;
            HashMap<String, BigDecimal> demands = null;
            HashMap<String, BigDecimal> collections = null;
            HashMap<String, BigDecimal> rebates = null;
            int i = 0;
            while (i < dcbList.size()) {
                Object[] dcbData2;
                Object[] dcbData = (Object[])dcbList.get(i);
                installment = this.installmentDAO.findById(Integer.parseInt(dcbData[0].toString()), false);
                DCBRecord dcbRecord = null;
                demands = new HashMap<String, BigDecimal>();
                collections = new HashMap<String, BigDecimal>();
                rebates = new HashMap<String, BigDecimal>();
                this.initDemandAndCollectionMap(fieldNames, demands, collections, rebates);
                int j = i;
                while (j < dcbList.size() && dcbData[0].equals((dcbData2 = (Object[])dcbList.get(i))[0])) {
                    dcbRecord = this.prepareDCMap(dcbData2, dcbRecord, demands, collections, rebates, dmd, fieldNames);
                    dcbReportMap.put(installment, dcbRecord);
                    ++j;
                    ++i;
                }
            }
        }
        return dcbReportMap;
    }

    DCBRecord prepareDCMap(Object[] dcbData2, DCBRecord dcbRecord, Map<String, BigDecimal> demands, Map<String, BigDecimal> collections, Map<String, BigDecimal> rebates, EgDemand dmd, List<String> fieldNames) {
        if (dcbData2 != null && dmd != null) {
            String reason = this.getReason(dcbData2, fieldNames);
            if (reason != null && demands != null && demands.containsKey(reason)) {
                demands.put(reason, demands.get(reason).add(new BigDecimal(dcbData2[1].toString())));
                collections.put(reason, collections.get(reason).add(new BigDecimal(dcbData2[2].toString())));
                rebates.put(reason, rebates.get(reason).add(new BigDecimal(dcbData2[5].toString())));
            }
            dcbRecord = new DCBRecord(demands, collections, rebates);
        }
        return dcbRecord;
    }

    String getReason(Object[] dcbData2, List<String> fieldNames) {
        String reason = "";
        if (dcbData2 != null && fieldNames != null && !fieldNames.isEmpty()) {
            EgReasonCategory reasonCategory = this.egReasonCategoryDAO.findById(Long.valueOf(dcbData2[4].toString()), false);
            EgDemandReasonMaster reasonMaster = this.egDemandReasonMasterDAO.findById(Long.valueOf(dcbData2[3].toString()), false);
            if (reasonCategory != null && fieldNames != null && fieldNames.contains(reasonCategory.getName())) {
                reason = reasonCategory.getName();
            } else if (reasonMaster != null && fieldNames != null && fieldNames.contains(reasonMaster.getReasonMaster())) {
                reason = reasonMaster.getReasonMaster();
            }
        }
        return reason;
    }

    void initDemandAndCollectionMap(List<String> prepareFieldNames, Map<String, BigDecimal> demand, Map<String, BigDecimal> collection, Map<String, BigDecimal> rebates) {
        if (prepareFieldNames != null && !prepareFieldNames.isEmpty()) {
            for (String fieldName : prepareFieldNames) {
                demand.put(fieldName, BigDecimal.ZERO);
                collection.put(fieldName, BigDecimal.ZERO);
                rebates.put(fieldName, BigDecimal.ZERO);
            }
        }
    }

    List<String> prepareFieldNames(List<EgDemandReasonMaster> dmdReasonMasters, DCBDisplayInfo dcbDisPlayInfo) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (dmdReasonMasters != null && !dmdReasonMasters.isEmpty()) {
            List<String> reasonCatgoryCodes = null;
            if (dcbDisPlayInfo != null && dcbDisPlayInfo.getReasonCategoryCodes() != null && !dcbDisPlayInfo.getReasonCategoryCodes().isEmpty()) {
                reasonCatgoryCodes = dcbDisPlayInfo.getReasonCategoryCodes();
                fieldNames.addAll(this.getNamesFromCodes(reasonCatgoryCodes));
            }
            for (EgDemandReasonMaster reasonMaster : dmdReasonMasters) {
                String categoryReason;
                if (reasonMaster == null || reasonMaster.getEgReasonCategory() == null || fieldNames.contains(categoryReason = reasonMaster.getEgReasonCategory().getName())) continue;
                fieldNames.add(reasonMaster.getReasonMaster());
            }
        }
        return fieldNames;
    }

    public List<String> getNamesFromCodes(List<String> reasonCatgoryCodes) {
        ArrayList<String> categoryMasters = new ArrayList<String>();
        for (String reasonMasterCode : reasonCatgoryCodes) {
            categoryMasters.add(this.demandGenericDAO.getReasonCategoryByCode(reasonMasterCode).getName());
        }
        return categoryMasters;
    }

    List<EgDemandReasonMaster> prepareReasonMasters(EgDemand demand, DCBDisplayInfo dcbDisPlayInfo) {
        List<String> RsonMasterCodes = null;
        List<EgDemandReasonMaster> reasonMsters = null;
        if (demand != null) {
            Module module = this.getModuleFromDemand(demand);
            if (module == null) {
                throw new DCBException(" EgModule are missing for the provided EgDemand Id =" + demand.getId());
            }
            if (dcbDisPlayInfo != null && dcbDisPlayInfo.getReasonMasterCodes() != null && !dcbDisPlayInfo.getReasonMasterCodes().isEmpty()) {
                RsonMasterCodes = dcbDisPlayInfo.getReasonMasterCodes();
            }
            reasonMsters = RsonMasterCodes == null || RsonMasterCodes.isEmpty() ? this.getEgdemandReasonMasters(module) : this.getEgdemandReasonMasters(RsonMasterCodes, module);
        }
        return reasonMsters;
    }

    List<EgDemandReasonMaster> getEgdemandReasonMasters(List<String> demandReasonMsterCodes, Module module) {
        ArrayList<EgDemandReasonMaster> reasonMsters = null;
        if (demandReasonMsterCodes != null && !demandReasonMsterCodes.isEmpty() && module != null) {
            reasonMsters = new ArrayList<EgDemandReasonMaster>();
            for (String dmdReasonMasterCode : demandReasonMsterCodes) {
                EgDemandReasonMaster dmdReasonMaster = this.demandGenericDAO.getDemandReasonMasterByCode(dmdReasonMasterCode, module);
                if (dmdReasonMaster == null) continue;
                reasonMsters.add(dmdReasonMaster);
            }
        }
        return reasonMsters;
    }

    Module getModuleFromDemand(EgDemand demand) {
        Module module = null;
        List demandRsonMastersList = new ArrayList();
        if (demand != null) {
            demandRsonMastersList = this.demandGenericDAO.getEgDemandReasonMasterIds(demand);
            if (demandRsonMastersList == null || demandRsonMastersList.isEmpty()) {
                throw new DCBException("EgDemandReasonMasters missing for the provided EgDemand Id " + demand.getId());
            }
            module = this.egDemandReasonMasterDAO.findById(Long.valueOf(demandRsonMastersList.get(0).toString()), false).getEgModule();
        }
        return module;
    }

    List<EgDemandReasonMaster> getEgdemandReasonMasters(Module module) {
        List<EgDemandReasonMaster> reasonMsters = null;
        if (module != null) {
            reasonMsters = this.demandGenericDAO.getDemandReasonMasterByModule(module);
        }
        return reasonMsters;
    }

    private List<InstallmentReceiptTuple> enumerateTuples() {
        ArrayList<InstallmentReceiptTuple> allReceiptTuples = new ArrayList<InstallmentReceiptTuple>();
        InstallmentReceiptTuple tuple = null;
        List<EgDemand> allDemands = this.billable.getAllDemands();
        if (allDemands != null) {
            for (EgDemand demand : allDemands) {
                for (EgDemandDetails det : demand.getEgDemandDetails()) {
                    for (EgdmCollectedReceipt collReceipt : det.getEgdmCollectedReceipts()) {
                        tuple = new InstallmentReceiptTuple(det.getEgDemandReason().getEgInstallmentMaster(), Receipt.mapFrom(collReceipt));
                        allReceiptTuples.add(tuple);
                    }
                }
            }
        }
        Collections.sort(allReceiptTuples);
        LOGGER.info((Object)("enumerateTuples() returned: " + allReceiptTuples));
        return allReceiptTuples;
    }

    private Map<Installment, List<Receipt>> consolidateTuplesInstallmentWise(List<InstallmentReceiptTuple> tuples) {
        HashMap<Installment, List<Receipt>> consolidated = new HashMap<Installment, List<Receipt>>();
        for (InstallmentReceiptTuple t : tuples) {
            ArrayList<Receipt> receiptsForInstallment = (ArrayList<Receipt>)consolidated.get(t.installment);
            if (receiptsForInstallment == null) {
                receiptsForInstallment = new ArrayList<Receipt>();
                consolidated.put(t.installment, receiptsForInstallment);
            }
            if (receiptsForInstallment.contains(t.receipt)) continue;
            receiptsForInstallment.add(t.receipt);
        }
        LOGGER.info((Object)("consolidateTuplesInstallmentWise() returned: " + consolidated));
        return consolidated;
    }

    private Map<Receipt, List<ReceiptDetail>> consolidateTuplesReceiptWise(List<InstallmentReceiptTuple> tuples) {
        HashMap<Receipt, List<ReceiptDetail>> consolidated = new HashMap<Receipt, List<ReceiptDetail>>();
        ArrayList<ReceiptDetail> breakups = null;
        for (InstallmentReceiptTuple t : tuples) {
            breakups = (ArrayList<ReceiptDetail>)consolidated.get(t.receipt);
            if (breakups == null) {
                breakups = new ArrayList<ReceiptDetail>();
                consolidated.put(t.receipt, breakups);
            }
            ReceiptDetail det = t.receipt.getReceiptDetails().get(0);
            breakups.add(det);
        }
        LOGGER.info((Object)("consolidateTuplesReceiptWise() returned: " + consolidated));
        return consolidated;
    }

    @Override
    public void setBillable(Billable billable) {
        this.billable = billable;
    }

    private void validate() {
        if (this.billable == null) {
            throw new IllegalStateException("Please call the setBillable() method first!");
        }
    }

    private static class InstallmentReceiptTuple
    implements Comparable<InstallmentReceiptTuple> {
        private final Installment installment;
        private final Receipt receipt;

        private InstallmentReceiptTuple(Installment installment, Receipt receipt) {
            this.installment = installment;
            this.receipt = receipt;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.installment).append(":").append(this.receipt);
            return sb.toString();
        }

        @Override
        public int compareTo(InstallmentReceiptTuple other) {
            return this.installment.compareTo(other.installment);
        }
    }
}

