/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dcb.bean;

import java.util.Map;
import org.egov.collection.integration.models.PaymentInfoCard;
import org.egov.dcb.bean.Payment;
import org.egov.infra.exception.ApplicationRuntimeException;

public class CreditCardPayment
extends Payment {
    public static final String CREDITCARDNO = "creditCardNo";
    public static final String CREDIRCARDEXPIRYMONTH = "creditCardStartMonth";
    public static final String CREDIRCARDEXPIRYYEAR = "crediCardtExpireYear";
    public static final String CVV = "cvv";
    public static final String CARDTYPE = "CardType";
    public static final String CARDTYPE_VISA = "V";
    public static final String CARDTYPE_MASTER = "M";
    public static final String CARDTYPE_OTHER = "O";
    public static final String TRANSACTIONNUMBER = "transactionNumber";
    private String creditCardNo;
    private String cvv;
    private String transactionNumber;
    private String expMonth;
    private String expYear;
    public PaymentInfoCard.CARDTYPE cardType;

    static CreditCardPayment create(Map<String, String> paymentInfo) {
        return new CreditCardPayment(paymentInfo);
    }

    private CreditCardPayment(Map<String, String> paymentInfo) {
        this.validate(paymentInfo);
        this.setPaymentMode(Payment.PAYMENTMODE.cc);
        this.setCreditCardNo(paymentInfo.get(CREDITCARDNO));
        this.setTransactionNumber(paymentInfo.get(TRANSACTIONNUMBER));
        this.setCardTypeIfAvailable(paymentInfo);
        this.setCVVIfAvailable(paymentInfo);
        this.setExpiryDateIfAvailable(paymentInfo);
    }

    @Override
    public String toString() {
        return super.toString() + "creditCardNo " + this.getCreditCardNo().substring(this.getCreditCardNo().length() - 4, this.getCreditCardNo().length()) + " Expiry Month " + this.getExpMonth() + " Expiry Year " + this.getExpYear();
    }

    public void validate(Map<String, String> paymentInfo) {
        if (paymentInfo == null || paymentInfo.isEmpty()) {
            throw new ApplicationRuntimeException(" paymentInfo is null.Please check. ");
        }
    }

    private void setCardTypeIfAvailable(Map<String, String> paymentInfo) {
        if (paymentInfo.get(CARDTYPE) != null) {
            if (paymentInfo.get(CARDTYPE).equals(CARDTYPE_MASTER)) {
                this.setCardType(PaymentInfoCard.CARDTYPE.M);
            } else if (paymentInfo.get(CARDTYPE).equals(CARDTYPE_VISA)) {
                this.setCardType(PaymentInfoCard.CARDTYPE.V);
            }
        }
    }

    private void setExpiryDateIfAvailable(Map<String, String> paymentInfo) {
        String expMonth = paymentInfo.get(CREDIRCARDEXPIRYMONTH);
        String expYear = paymentInfo.get(CREDIRCARDEXPIRYYEAR);
        if (expMonth != null && !expMonth.isEmpty()) {
            this.setExpMonth(expMonth);
        }
        if (expYear != null && !expYear.isEmpty()) {
            this.setExpYear(expYear);
        }
    }

    private void setCVVIfAvailable(Map<String, String> paymentInfo) {
        String cvv = paymentInfo.get(CVV);
        if (cvv != null && !cvv.isEmpty()) {
            this.setCvv(cvv);
        }
    }

    public String getCreditCardNo() {
        return this.creditCardNo;
    }

    public void setCreditCardNo(String creditCardNo) {
        this.creditCardNo = creditCardNo;
    }

    public String getCvv() {
        return this.cvv;
    }

    public void setCvv(String cvv) {
        this.cvv = cvv;
    }

    public String getTransactionNumber() {
        return this.transactionNumber;
    }

    public void setTransactionNumber(String transactionNumber) {
        this.transactionNumber = transactionNumber;
    }

    public String getExpMonth() {
        return this.expMonth;
    }

    public void setExpMonth(String expMonth) {
        this.expMonth = expMonth;
    }

    public String getExpYear() {
        return this.expYear;
    }

    public void setExpYear(String expYear) {
        this.expYear = expYear;
    }

    public PaymentInfoCard.CARDTYPE getCardType() {
        return this.cardType;
    }

    public void setCardType(PaymentInfoCard.CARDTYPE cardType) {
        this.cardType = cardType;
    }
}

