/*
 * Decompiled with CFR 0.152.
 */
package org.egov.demand.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.Installment;
import org.egov.demand.dao.DepreciationMasterDao;
import org.egov.demand.model.DepreciationMaster;
import org.egov.infra.admin.master.entity.Module;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="depreciationMasterDAO")
@Transactional(readOnly=true)
public class DepreciationMasterHibDao
implements DepreciationMasterDao {
    @PersistenceContext
    private EntityManager entityManager;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public DepreciationMaster getDepreciationMaster(Module mod, Integer year) {
        Query qry = this.getCurrentSession().createQuery("from DepreciationMaster DM where DM.module=:mod and DM.year=:year ");
        qry.setEntity("mod", (Object)mod);
        qry.setInteger("year", year.intValue());
        return (DepreciationMaster)qry.uniqueResult();
    }

    @Override
    public DepreciationMaster getNonHistDepMasterByModuleInsYr(Module mod, Integer year, Installment insYear) {
        Query qry = this.getCurrentSession().createQuery("from DepreciationMaster DM where DM.module=:mod and DM.year=:year and DM.IsHistory='N' and DM.startInstallment=:insYear ");
        qry.setEntity("mod", (Object)mod);
        qry.setInteger("year", year.intValue());
        qry.setEntity("insYear", (Object)insYear);
        return (DepreciationMaster)qry.uniqueResult();
    }

    @Override
    public List getDepreciationsForModule(Module mod) {
        Query qry = this.getCurrentSession().createQuery("from DepreciationMaster DM where DM.module=:module");
        qry.setEntity("module", (Object)mod);
        return qry.list();
    }

    @Override
    public List getDepreciationsForModulebyHistory(Module mod) {
        Query qry = this.getCurrentSession().createQuery("from DepreciationMaster DM where DM.module=:module and DM.IsHistory='N'");
        qry.setEntity("module", (Object)mod);
        return qry.list();
    }

    @Override
    public Float getDepreciationPercent(Integer year) {
        Query qry = this.getCurrentSession().createQuery("select DM.depreciationPct from DepreciationMaster DM where DM.year=:year");
        qry.setInteger("year", year.intValue());
        return (Float)qry.uniqueResult();
    }

    @Override
    public List getAllNonHistoryDepreciationRates() {
        Query qry = this.getCurrentSession().createQuery("from DepreciationMaster DM where  and DM.IsHistory='N'");
        return qry.list();
    }

    @Override
    public Float getLeastDepreciationPercent(Integer year) {
        Float leastDeprePercent = null;
        if (year != null && year != 0) {
            Float deprePercent = this.getDepreciationPercent(year);
            if (deprePercent == null || deprePercent.floatValue() == 0.0f) {
                Query qry = this.getCurrentSession().createQuery("select min(DM.year) from DepreciationMaster DM ");
                Integer leastDepreYear = (Integer)qry.uniqueResult();
                leastDeprePercent = this.getDepreciationPercent(leastDepreYear);
            } else {
                leastDeprePercent = deprePercent;
            }
        }
        return leastDeprePercent;
    }

    @Override
    public DepreciationMaster findById(Integer id, boolean lock) {
        return null;
    }

    @Override
    public List<DepreciationMaster> findAll() {
        return null;
    }

    @Override
    public DepreciationMaster create(DepreciationMaster depreciationMaster) {
        return null;
    }

    @Override
    public void delete(DepreciationMaster depreciationMaster) {
    }

    @Override
    public DepreciationMaster update(DepreciationMaster depreciationMaster) {
        return null;
    }
}

