/*
 * Decompiled with CFR 0.152.
 */
package org.egov.demand.service;

import java.util.List;
import org.apache.log4j.Logger;
import org.egov.demand.dao.DepreciationMasterDao;
import org.egov.demand.model.DepreciationMaster;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.springframework.beans.factory.annotation.Autowired;

public class DCBMasterService {
    private static final Logger LOGGER = Logger.getLogger(DCBMasterService.class);
    @Autowired
    private DepreciationMasterDao depreciationMasterDAO;

    public void updateDepreciationMaster(DepreciationMaster dm) {
        LOGGER.info((Object)("inside updateDepreciationMaster" + dm));
        this.depreciationMasterDAO.update(dm);
        LOGGER.info((Object)"update Depreciation Master");
    }

    public List<DepreciationMaster> getDepreciationsForModule(Module module) {
        LOGGER.debug((Object)"inside getDepreciationsForModule.");
        return this.depreciationMasterDAO.getDepreciationsForModule(module);
    }

    public void createDepreciationMaster(DepreciationMaster dm) {
        LOGGER.debug((Object)("inside createDepreciationMaster" + dm));
        this.depreciationMasterDAO.create(dm);
        LOGGER.debug((Object)"created DepreciationMaster");
    }

    public List getAllDepreciationRates() {
        try {
            List<DepreciationMaster> retList = this.depreciationMasterDAO.findAll();
            return retList;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception in  getAllDepreciationRates", (Throwable)e);
        }
    }

    public void deleteDepreciationMaster(DepreciationMaster dm) {
        this.depreciationMasterDAO.delete(dm);
    }

    public DepreciationMaster getDepreciationById(Integer id) {
        return this.depreciationMasterDAO.findById(id, false);
    }

    public List<DepreciationMaster> getDepreciationsForModulebyHistory(Module module) {
        return this.depreciationMasterDAO.getDepreciationsForModulebyHistory(module);
    }

    public List getAllNonHistoryDepreciationRates() {
        try {
            return this.depreciationMasterDAO.findAll();
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception in  getAllDepreciationRates", (Throwable)e);
        }
    }
}

