/*
 * Decompiled with CFR 0.152.
 */
package org.egov.demand.integration;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.egov.InvalidAccountHeadException;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.ReceiptAccountInfo;
import org.egov.collection.integration.models.ReceiptInstrumentInfo;
import org.egov.collection.integration.services.BillingIntegrationService;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.dao.EgBillDetailsDao;
import org.egov.demand.dao.EgBillReceiptDao;
import org.egov.demand.dao.EgdmCollectedReceiptDao;
import org.egov.demand.model.BillReceipt;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.demand.model.EgDemandReasonMaster;
import org.egov.demand.model.EgdmCollectedReceipt;
import org.egov.demand.utils.DemandConstants;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.hibernate.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class TaxCollection
implements BillingIntegrationService {
    private static final Logger LOGGER = Logger.getLogger(TaxCollection.class);
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private EgBillDetailsDao egBillDetailsDAO;
    @Autowired
    private EgBillReceiptDao egBillReceiptDAO;
    @Autowired
    private EgdmCollectedReceiptDao egdmCollectedReceiptDAO;
    @Autowired
    private DemandGenericDao demandGenericDAO;
    @Autowired
    private InstallmentHibDao installmentHibDao;

    public void updateReceiptDetails(Set<BillReceiptInfo> billReceipts) throws ApplicationRuntimeException {
        LOGGER.debug((Object)"updateReceiptDetails : Receipt Details Updating Started...");
        for (BillReceiptInfo bri : billReceipts) {
            try {
                LOGGER.debug((Object)"-----updateReceiptDetails is called----------------");
                this.updateNewReceipt(bri);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exception while updating receipt details in billing system", (Throwable)e);
                throw new ApplicationRuntimeException("", (Throwable)e);
            }
        }
        LOGGER.debug((Object)"updateReceiptDetails : Receipt Details Updating Finished...");
    }

    private void updateNewReceipt(BillReceiptInfo bri) throws InvalidAccountHeadException, ObjectNotFoundException {
        LOGGER.info((Object)"-----updateNewReceipt is called----------------");
        this.linkBillToReceipt(bri);
        this.updateBillDetails(bri);
        this.updateDemandDetails(bri);
        LOGGER.info((Object)"--end of Updation of all the Demand ");
    }

    BillReceipt linkBillToReceipt(BillReceiptInfo bri) throws InvalidAccountHeadException, ObjectNotFoundException {
        LOGGER.debug((Object)"-----Start of linkBillToReceipt----------------");
        BillReceipt billRecpt = null;
        if (bri == null) {
            throw new ApplicationRuntimeException(" BillReceiptInfo Object is null ");
        }
        EgBill egBill = this.egBillDAO.findById(Long.valueOf(bri.getBillReferenceNum()), false);
        if (egBill == null) {
            throw new ApplicationRuntimeException(" EgBill Object is null for the Bill Number" + bri.getBillReferenceNum());
        }
        List<EgBillDetails> billDetList = this.egBillDetailsDAO.getBillDetailsByBill(egBill);
        BigDecimal totalCollectedAmt = this.calculateTotalCollectedAmt(bri, billDetList);
        if (bri.getEvent() == null) {
            throw new ApplicationRuntimeException(" Event in BillReceiptInfo Object is Null");
        }
        if (bri.getEvent().equals("RECEIPT_CREATED")) {
            billRecpt = this.prepareBillReceiptBean(bri, egBill, totalCollectedAmt);
            this.egBillReceiptDAO.create(billRecpt);
        } else if (bri.getEvent().equals("RECEIPT_CANCELLED")) {
            billRecpt = this.updateBillReceiptForCancellation(bri, egBill, totalCollectedAmt);
        }
        LOGGER.debug((Object)"-----End of linkBillToReceipt----------------");
        return billRecpt;
    }

    BillReceipt prepareBillReceiptBean(BillReceiptInfo bri, EgBill egBill, BigDecimal totalCollectedAmt) {
        BillReceipt billRecpt = null;
        if (bri != null && egBill != null && totalCollectedAmt != null) {
            billRecpt = new BillReceipt();
            billRecpt.setBillId(egBill);
            billRecpt.setReceiptAmt(totalCollectedAmt);
            billRecpt.setReceiptNumber(bri.getReceiptNum());
            billRecpt.setReceiptDate(bri.getReceiptDate());
            billRecpt.setCollectionStatus(bri.getReceiptStatus().getCode());
            billRecpt.setCreatedBy(bri.getCreatedBy());
            billRecpt.setModifiedBy(bri.getModifiedBy());
            billRecpt.setCreatedDate(new Date());
            billRecpt.setModifiedDate(new Date());
            billRecpt.setIsCancelled(Boolean.FALSE);
        }
        return billRecpt;
    }

    BillReceipt updateBillReceiptForCancellation(BillReceiptInfo bri, EgBill egBill, BigDecimal totalCollectedAmt) {
        BillReceipt billRecpt = null;
        if (bri == null) {
            throw new ApplicationRuntimeException(" BillReceiptInfo Object is null ");
        }
        if (egBill != null && totalCollectedAmt != null) {
            billRecpt = this.egBillReceiptDAO.getBillReceiptByEgBill(egBill);
            if (billRecpt == null) {
                throw new ApplicationRuntimeException(" Bill receipt Object is null for the EgBill " + egBill.getId());
            }
            if (bri.getEvent().equals("RECEIPT_CANCELLED")) {
                billRecpt.setIsCancelled(Boolean.TRUE);
            }
        } else {
            throw new ApplicationRuntimeException(" EgBill Object is null for the Bill Number" + bri.getBillReferenceNum() + "in updateBillReceiptForCancellation method");
        }
        billRecpt.setReceiptAmt(totalCollectedAmt.subtract(billRecpt.getReceiptAmt()));
        return billRecpt;
    }

    EgBill updateBillDetails(BillReceiptInfo bri) throws InvalidAccountHeadException {
        LOGGER.debug((Object)"-----Start of updateBillDetails----------------");
        EgBill egBill = null;
        if (bri == null) {
            throw new ApplicationRuntimeException(" BillReceiptInfo Object is null ");
        }
        egBill = this.egBillDAO.findById(Long.valueOf(bri.getBillReferenceNum()), false);
        List<EgBillDetails> billDetList = this.egBillDetailsDAO.getBillDetailsByBill(egBill);
        if (bri.getEvent() != null && bri.getEvent().equals("RECEIPT_CREATED")) {
            BigDecimal totalCollectedAmt = this.calculateTotalCollectedAmt(bri, billDetList);
            egBill = this.updateBill(bri, egBill, totalCollectedAmt);
        } else if (bri.getEvent() != null && bri.getEvent().equals("INSTRUMENT_BOUNCED")) {
            egBill = this.updateBillForChqBounce(bri, egBill, this.getTotalChequeAmt(bri));
        } else if (bri.getEvent() != null && bri.getEvent().equals("RECEIPT_CANCELLED")) {
            this.updateBillByCancelledRct(bri, egBill, bri.getTotalAmount());
        }
        LOGGER.debug((Object)"-----End of updateBillDetails----------------");
        return egBill;
    }

    public EgBill updateBillForChqBounce(BillReceiptInfo bri, EgBill egBill, BigDecimal totalChqAmt) {
        BigDecimal zeroVal = BigDecimal.ZERO;
        if (totalChqAmt != null && !totalChqAmt.equals(zeroVal) && egBill != null) {
            ArrayList<EgBillDetails> billList = new ArrayList<EgBillDetails>(egBill.getEgBillDetails());
            Collections.reverse(billList);
            BigDecimal carry = totalChqAmt;
            for (EgBillDetails billdet : billList) {
                BigDecimal balanceAmt = BigDecimal.ZERO;
                BigDecimal remAmount = BigDecimal.ZERO;
                balanceAmt = this.getEgBillDetailCollection(billdet);
                if (balanceAmt == null || balanceAmt.compareTo(zeroVal) <= 0) continue;
                if (carry.compareTo(zeroVal) > 0 && carry.subtract(balanceAmt).compareTo(zeroVal) > 0) {
                    carry = carry.subtract(balanceAmt);
                    remAmount = balanceAmt;
                } else if (carry.compareTo(zeroVal) > 0 && carry.subtract(balanceAmt).compareTo(zeroVal) <= 0) {
                    remAmount = carry;
                    carry = BigDecimal.ZERO;
                }
                if (remAmount.compareTo(zeroVal) <= 0) continue;
                billdet.setCollectedAmount(remAmount);
                this.egBillDetailsDAO.update(billdet);
            }
            egBill.setTotalCollectedAmount(totalChqAmt);
            this.egBillDAO.update(egBill);
        }
        return egBill;
    }

    EgBill updateBillByCancelledRct(BillReceiptInfo bri, EgBill egBill, BigDecimal totalCollectedAmt) throws InvalidAccountHeadException {
        if (bri != null && egBill != null && totalCollectedAmt != null) {
            ArrayList<EgBillDetails> billList = new ArrayList<EgBillDetails>(egBill.getEgBillDetails());
            Collections.reverse(billList);
            for (EgBillDetails billDet : billList) {
                BigDecimal balanceAmt = this.getEgBillDetailCollection(billDet);
                Boolean glCodeExist = false;
                for (ReceiptAccountInfo acctDet : bri.getAccountDetails()) {
                    if (!billDet.getGlcode().equals(acctDet.getGlCode())) continue;
                    glCodeExist = true;
                    billDet.setCollectedAmount(acctDet.getCrAmount().subtract(balanceAmt));
                    this.egBillDetailsDAO.update(billDet);
                }
                if (glCodeExist.booleanValue()) continue;
                throw new InvalidAccountHeadException("GlCode does not exist for " + billDet.getGlcode());
            }
            egBill.setTotalCollectedAmount(totalCollectedAmt);
            this.egBillDAO.update(egBill);
        }
        return egBill;
    }

    private EgBill updateBill(BillReceiptInfo bri, EgBill egBill, BigDecimal totalCollectedAmt) throws InvalidAccountHeadException {
        if (bri != null) {
            for (EgBillDetails billDet : egBill.getEgBillDetails()) {
                Boolean glCodeExist = false;
                for (ReceiptAccountInfo acctDet : bri.getAccountDetails()) {
                    if (!billDet.getGlcode().equals(acctDet.getGlCode())) continue;
                    glCodeExist = true;
                    BigDecimal amtCollected = billDet.getCollectedAmount();
                    if (amtCollected == null) {
                        amtCollected = BigDecimal.ZERO;
                    }
                    billDet.setCollectedAmount(acctDet.getCrAmount().subtract(amtCollected));
                    this.egBillDetailsDAO.update(billDet);
                }
                if (glCodeExist.booleanValue()) continue;
                throw new InvalidAccountHeadException("GlCode does not exist for " + billDet.getGlcode());
            }
            egBill.setTotalCollectedAmount(totalCollectedAmt);
            this.egBillDAO.update(egBill);
        }
        return egBill;
    }

    public BigDecimal calculateTotalCollectedAmt(BillReceiptInfo bri, List<EgBillDetails> billDetList) throws InvalidAccountHeadException {
        return bri.getTotalAmount();
    }

    public BigDecimal getTotalChequeAmt(BillReceiptInfo bri) {
        BigDecimal totalCollAmt = BigDecimal.ZERO;
        try {
            if (bri != null) {
                for (ReceiptInstrumentInfo rctInst : bri.getBouncedInstruments()) {
                    if (rctInst.getInstrumentAmount() == null) continue;
                    totalCollAmt = totalCollAmt.add(rctInst.getInstrumentAmount());
                }
            }
        }
        catch (ApplicationRuntimeException e) {
            throw new ApplicationRuntimeException("Exception in calculate Total Collected Amt" + (Object)((Object)e));
        }
        return totalCollAmt;
    }

    public BigDecimal getEgBillDetailCollection(EgBillDetails billdet) {
        BigDecimal collectedAmt = billdet.getCollectedAmount();
        if (billdet.getCollectedAmount() == null) {
            collectedAmt = BigDecimal.ZERO;
        }
        return collectedAmt;
    }

    public abstract void updateDemandDetails(BillReceiptInfo var1);

    protected abstract Module module();

    protected Installment getInstallmentForDate(Date date) {
        return this.installmentHibDao.getInsatllmentByModuleForGivenDate(this.module(), date);
    }

    protected Installment getCurrentInstallment() {
        return this.getInstallmentForDate(new Date());
    }

    protected List<Installment> getAllInstallments() {
        return this.installmentHibDao.getInsatllmentByModule(this.module());
    }

    protected EgDemandReasonMaster getDemandReasonMaster(String code) {
        return this.demandGenericDAO.getDemandReasonMasterByCode(code, this.module());
    }

    public EgDemandDetails getDemandDetail(EgDemand egDemand, Installment instl, String code) {
        EgDemandDetails dmdDet = null;
        List<EgDemandDetails> dmdDetList = this.demandGenericDAO.getDmdDetailList(egDemand, instl, this.module(), this.getDemandReasonMaster(code));
        if (!dmdDetList.isEmpty()) {
            dmdDet = dmdDetList.get(0);
        }
        return dmdDet;
    }

    protected EgDemandReason getCurrentReason(String categoryCode, String reasonMasterCode) {
        EgDemandReason reason = this.demandGenericDAO.getEgDemandReasonByCodeInstallmentModule(reasonMasterCode, this.getCurrentInstallment(), this.module(), categoryCode);
        return reason;
    }

    protected EgdmCollectedReceipt persistCollectedReceipts(EgDemandDetails egDemandDetails, String receiptNumber, BigDecimal receiptAmount, Date receiptDate, BigDecimal reasonAmount) {
        EgdmCollectedReceipt egDmCollectedReceipt = new EgdmCollectedReceipt();
        egDmCollectedReceipt.setReceiptNumber(receiptNumber);
        egDmCollectedReceipt.setReceiptDate(receiptDate);
        egDmCollectedReceipt.setAmount(receiptAmount);
        egDmCollectedReceipt.setReasonAmount(reasonAmount);
        egDmCollectedReceipt.setStatus(DemandConstants.NEWRECEIPT);
        egDmCollectedReceipt.setEgdemandDetail(egDemandDetails);
        this.egdmCollectedReceiptDAO.create(egDmCollectedReceipt);
        return egDmCollectedReceipt;
    }

    protected void updateReceiptStatusWhenCancelled(String receiptNumber) {
        List<EgdmCollectedReceipt> egdmCollectedReceipts = this.demandGenericDAO.getAllEgdmCollectedReceipts(receiptNumber);
        if (egdmCollectedReceipts != null && !egdmCollectedReceipts.isEmpty()) {
            for (EgdmCollectedReceipt egDmCollectedReceipt : egdmCollectedReceipts) {
                egDmCollectedReceipt.setStatus(DemandConstants.CANCELLED_RECEIPT);
                egDmCollectedReceipt.setUpdatedTime(new Date());
                this.egdmCollectedReceiptDAO.update(egDmCollectedReceipt);
            }
        }
    }

    public void apportionPaidAmount(String billReferenceNumber, BigDecimal actualAmountPaid, ArrayList<ReceiptDetail> receiptDetails) {
        this.apportionCollection(billReferenceNumber, actualAmountPaid, receiptDetails);
    }

    public void apportionCollection(String billRefNo, BigDecimal amtPaid, List<ReceiptDetail> receiptDetails) {
    }
}

