/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dcb.bean;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.egov.commons.Installment;
import org.egov.dcb.bean.Payment;
import org.egov.dcb.bean.ReceiptDetail;
import org.egov.demand.model.EgdmCollectedReceipt;

public class Receipt {
    private static final String REASON_CODE_NA = "N/A";
    private static final String TO_STRING_SEP = "#";
    private String receiptNumber = null;
    private Date receiptDate = null;
    private BigDecimal receiptAmt = null;
    private String paymentMode;
    private List<Payment> payments;
    private List<ReceiptDetail> receiptDetails = new ArrayList<ReceiptDetail>();
    private Character receiptStatus = null;
    private String consumerCode;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.receiptNumber).append(TO_STRING_SEP).append(this.receiptAmt).append(TO_STRING_SEP).append(this.paymentMode).append(TO_STRING_SEP).append(this.receiptDetails).append(TO_STRING_SEP).append(this.receiptStatus);
        return sb.toString();
    }

    public static Receipt mapFrom(EgdmCollectedReceipt collReceipt) {
        Receipt r = new Receipt();
        r.setReceiptNumber(collReceipt.getReceiptNumber());
        r.setReceiptAmt(collReceipt.getAmount());
        r.setReceiptDate(collReceipt.getReceiptDate());
        r.setReceiptStatus(collReceipt.getStatus());
        r.addReceiptDetail(new ReceiptDetail(collReceipt.getEgdemandDetail().getEgDemandReason().getEgInstallmentMaster(), collReceipt.getReasonAmount(), collReceipt.getEgdemandDetail().getEgDemandReason().getEgDemandReasonMaster().getCode()));
        return r;
    }

    public BigDecimal getAmountForInstallment(Installment i) {
        BigDecimal amount = BigDecimal.ZERO;
        for (ReceiptDetail detail : this.receiptDetails) {
            if (!i.equals((Object)detail.getInstallment())) continue;
            amount = amount.add(detail.getAmount());
        }
        return amount;
    }

    public void populateDetails(Map<Installment, BigDecimal> breakup) {
        for (Map.Entry<Installment, BigDecimal> pair : breakup.entrySet()) {
            this.addReceiptDetail(new ReceiptDetail(pair.getKey(), pair.getValue(), REASON_CODE_NA));
        }
    }

    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public Date getReceiptDate() {
        return this.receiptDate;
    }

    public void setReceiptDate(Date receiptDate) {
        this.receiptDate = receiptDate;
    }

    public BigDecimal getReceiptAmt() {
        return this.receiptAmt;
    }

    public void setReceiptAmt(BigDecimal receiptAmt) {
        this.receiptAmt = receiptAmt;
    }

    public List<Payment> getPayments() {
        return this.payments;
    }

    public void setPayments(List<Payment> payments) {
        this.payments = payments;
    }

    public List<ReceiptDetail> getReceiptDetails() {
        return this.receiptDetails;
    }

    public void addReceiptDetail(ReceiptDetail receiptDetail) {
        this.receiptDetails.add(receiptDetail);
    }

    public void setReceiptDetails(List<ReceiptDetail> receiptDetails) {
        this.receiptDetails = receiptDetails;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Receipt other = (Receipt)obj;
        return this.receiptNumber != null && other != null && this.receiptNumber.equals(other.receiptNumber);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.receiptNumber == null ? 0 : this.receiptNumber.hashCode());
        return result;
    }

    public Character getReceiptStatus() {
        return this.receiptStatus;
    }

    public void setReceiptStatus(Character receiptStatus) {
        this.receiptStatus = receiptStatus;
    }

    public String getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(String paymentMode) {
        this.paymentMode = paymentMode;
    }

    public String getConsumerCode() {
        return this.consumerCode;
    }

    public void setConsumerCode(String consumerCode) {
        this.consumerCode = consumerCode;
    }
}

