/*
 * Decompiled with CFR 0.152.
 */
package org.egov.demand.dao;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillType;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="egBillDAO")
@Transactional(readOnly=true)
@Scope(value="prototype")
public class EgBillHibernateDao
implements EgBillDao {
    @PersistenceContext
    private EntityManager entityManager;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public EgBillType getBillTypeByCode(String code) {
        Query qry = this.getCurrentSession().createQuery("from EgBillType bt where bt.code =:BTCODE");
        qry.setString("BTCODE", code);
        qry.setMaxResults(1);
        return (EgBillType)qry.uniqueResult();
    }

    @Override
    public EgBill findById(Long id, boolean lock) {
        return (EgBill)this.getCurrentSession().get(EgBill.class, (Serializable)id);
    }

    @Override
    public List<EgBill> findAll() {
        return this.getCurrentSession().createQuery("from EgBill").list();
    }

    @Override
    public EgBill create(EgBill egBill) {
        this.getCurrentSession().saveOrUpdate((Object)egBill);
        this.getCurrentSession().flush();
        return egBill;
    }

    @Override
    public void delete(EgBill egBill) {
        this.getCurrentSession().delete((Object)egBill);
    }

    @Override
    public EgBill update(EgBill egBill) {
        this.getCurrentSession().saveOrUpdate((Object)egBill);
        this.getCurrentSession().flush();
        return egBill;
    }
}

