/*
 * Decompiled with CFR 0.152.
 */
package org.egov.demand.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.egov.commons.Installment;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgDemandDetails;

public class EgDemand
implements Serializable,
Cloneable {
    private Long id;
    private Installment egInstallmentMaster;
    private BigDecimal baseDemand = BigDecimal.ZERO;
    private String isHistory;
    private Date createDate;
    private Date modifiedDate;
    private Set<EgDemandDetails> egDemandDetails = new HashSet<EgDemandDetails>(0);
    private Set<EgBill> egBills = new HashSet<EgBill>(0);
    private BigDecimal amtCollected = BigDecimal.ZERO;
    private Character status;
    private BigDecimal minAmtPayable = BigDecimal.ZERO;
    private BigDecimal amtRebate = BigDecimal.ZERO;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        EgDemand other = (EgDemand)obj;
        return this.id != null && other != null && this.id.equals(other.id);
    }

    public Object clone() {
        EgDemand clone = null;
        try {
            clone = (EgDemand)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
        clone.setId(null);
        clone.setEgBills(new HashSet<EgBill>());
        clone.setEgDemandDetails(new HashSet<EgDemandDetails>());
        for (EgDemandDetails det : this.egDemandDetails) {
            clone.addEgDemandDetails((EgDemandDetails)det.clone());
        }
        return clone;
    }

    public Character getStatus() {
        return this.status;
    }

    public void setStatus(Character status) {
        this.status = status;
    }

    public BigDecimal getMinAmtPayable() {
        return this.minAmtPayable;
    }

    public void setMinAmtPayable(BigDecimal minAmtPayable) {
        this.minAmtPayable = minAmtPayable;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Installment getEgInstallmentMaster() {
        return this.egInstallmentMaster;
    }

    public void setEgInstallmentMaster(Installment egInstallmentMaster) {
        this.egInstallmentMaster = egInstallmentMaster;
    }

    public BigDecimal getBaseDemand() {
        return this.baseDemand;
    }

    public void setBaseDemand(BigDecimal baseDemand) {
        this.baseDemand = baseDemand;
    }

    public void addBaseDemand(BigDecimal amount) {
        this.setBaseDemand(this.getBaseDemand().add(amount));
    }

    public String getIsHistory() {
        return this.isHistory;
    }

    public void setIsHistory(String isHistory) {
        this.isHistory = isHistory;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public Set<EgBill> getEgBills() {
        return this.egBills;
    }

    public void setEgBills(Set<EgBill> egBills) {
        this.egBills = egBills;
    }

    public Set<EgDemandDetails> getEgDemandDetails() {
        return this.egDemandDetails;
    }

    public void setEgDemandDetails(Set<EgDemandDetails> egDemandDetails) {
        this.egDemandDetails = egDemandDetails;
    }

    public void addEgBill(EgBill egBill) {
        this.getEgBills().add(egBill);
    }

    public void removeEgBill(EgBill egBill) {
        this.getEgBills().remove(egBill);
    }

    public void addEgDemandDetails(EgDemandDetails egDemandDetails) {
        this.getEgDemandDetails().add(egDemandDetails);
    }

    public void removeEgDemandDetails(EgDemandDetails egDemandDetails) {
        this.getEgDemandDetails().remove(egDemandDetails);
    }

    public BigDecimal getAmtCollected() {
        return this.amtCollected;
    }

    public void setAmtCollected(BigDecimal amtCollected) {
        this.amtCollected = amtCollected;
    }

    public void addCollected(BigDecimal amount) {
        if (this.getAmtCollected() != null) {
            this.setAmtCollected(this.getAmtCollected().add(amount != null ? amount : BigDecimal.ZERO));
        } else {
            this.setAmtCollected(amount);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id).append("|").append(this.egInstallmentMaster).append("|").append(this.baseDemand).append("|").append(this.amtCollected).append("|").append(this.egDemandDetails).append("|").append(this.amtRebate);
        return sb.toString();
    }

    public BigDecimal getAmtRebate() {
        return this.amtRebate;
    }

    public void setAmtRebate(BigDecimal amtRebate) {
        this.amtRebate = amtRebate;
    }

    public void addRebateAmt(BigDecimal rebateAmt) {
        if (this.getAmtRebate() != null) {
            this.setAmtRebate(this.getAmtRebate().add(rebateAmt != null ? rebateAmt : BigDecimal.ZERO));
        } else {
            this.setAmtRebate(rebateAmt);
        }
    }
}

