/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dcb.bean;

import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.dcb.bean.Payment;
import org.egov.infra.exception.ApplicationRuntimeException;

public class OnlinePayment
extends Payment {
    public static final String TRANSACTION_NUMBER = "transactionNumber";
    private String transactionNumber;
    private static final Logger LOGGER = Logger.getLogger(OnlinePayment.class);

    public static OnlinePayment create(Map<String, String> paymentInfo) {
        return new OnlinePayment(paymentInfo);
    }

    private OnlinePayment(Map<String, String> paymentInfo) {
        this.validate(paymentInfo);
        LOGGER.debug((Object)("-Online Payment -paymentInfo " + paymentInfo));
        this.setTransactionNumber(paymentInfo.get(TRANSACTION_NUMBER));
        this.setPaymentMode(Payment.PAYMENTMODE.online);
        LOGGER.debug((Object)("--- Online Payment is created " + this));
    }

    @Override
    public String toString() {
        return super.toString() + " transactionNumber " + this.getTransactionNumber();
    }

    public void validate(Map<String, String> paymentInfo) {
        if (paymentInfo != null && paymentInfo.isEmpty()) {
            throw new ApplicationRuntimeException(" paymentInfo is null.Please check. ");
        }
    }

    public String getTransactionNumber() {
        return this.transactionNumber;
    }

    public void setTransactionNumber(String transactionNumber) {
        this.transactionNumber = transactionNumber;
    }
}

