/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dcb.bean;

import java.util.Map;
import org.egov.dcb.bean.Payment;
import org.egov.infra.exception.ApplicationRuntimeException;

public class AtmPayment
extends Payment {
    public static final String TRANSACTIONNUMBER = "transactionNumber";
    public static final String BANKCODE = "bankcode";
    private String transactionNumber;
    private Long bankId;

    static AtmPayment create(Map<String, String> paymentInfo) {
        return new AtmPayment(paymentInfo);
    }

    private AtmPayment(Map<String, String> paymentInfo) {
        this.validate(paymentInfo);
        this.setPaymentMode(Payment.PAYMENTMODE.atm);
        this.setTransactionNumber(paymentInfo.get(TRANSACTIONNUMBER));
        this.setBankId(this.fetchBankIDFromCodeOrName(paymentInfo.get(BANKCODE)));
    }

    @Override
    public String toString() {
        return this.bankId + ", " + this.transactionNumber + ", " + super.toString();
    }

    public void validate(Map<String, String> paymentInfo) {
        if (paymentInfo == null || paymentInfo.isEmpty()) {
            throw new ApplicationRuntimeException(" paymentInfo is null.Please check. ");
        }
    }

    public String getTransactionNumber() {
        return this.transactionNumber;
    }

    public void setTransactionNumber(String transactionNumber) {
        this.transactionNumber = transactionNumber;
    }

    public Long getBankId() {
        return this.bankId;
    }

    public void setBankId(Long bankId) {
        this.bankId = bankId;
    }
}

