/*
 * Decompiled with CFR 0.152.
 */
package org.egov.demand.dao;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.EgwStatus;
import org.egov.commons.Installment;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.dao.EgBillReceiptDao;
import org.egov.demand.model.BillReceipt;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.demand.model.EgDemandReasonMaster;
import org.egov.demand.model.EgReasonCategory;
import org.egov.demand.model.EgdmCollectedReceipt;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="demandGenericDAO")
public class DemandGenericHibDao
implements DemandGenericDao {
    @Autowired
    private EgBillReceiptDao egBillReceiptDAO;
    @PersistenceContext
    private EntityManager entityManager;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public List<EgDemandReasonMaster> getDemandReasonMasterByModule(Module module) {
        List<EgDemandReasonMaster> list = new ArrayList<EgDemandReasonMaster>();
        Query qry = null;
        if (module != null) {
            qry = this.getCurrentSession().createQuery(" from EgDemandReasonMaster where egModule =:module ");
            qry.setEntity("module", (Object)module);
            list = qry.list();
        }
        return list;
    }

    @Override
    public List<EgDemandReasonMaster> getDemandReasonMasterByCategoryAndModule(EgReasonCategory egReasonCategory, Module module) {
        List<EgDemandReasonMaster> list = new ArrayList<EgDemandReasonMaster>();
        Query qry = null;
        if (egReasonCategory != null && module != null) {
            qry = this.getCurrentSession().createQuery(" from EgDemandReasonMaster where egModule =:module and egReasonCategory =:egReasonCategory   ");
            qry.setEntity("module", (Object)module);
            qry.setEntity("egReasonCategory", (Object)egReasonCategory);
            list = qry.list();
        }
        return list;
    }

    @Override
    public EgDemandReasonMaster getDemandReasonMasterByCode(String code, Module module) {
        EgDemandReasonMaster egDemandReasonMaster = null;
        Query qry = null;
        if (code != null && !code.equals("") && module != null) {
            qry = this.getCurrentSession().createQuery(" from EgDemandReasonMaster ReasonMaster where  ReasonMaster.egModule =:module and  ReasonMaster.code =:code  ");
            qry.setEntity("module", (Object)module);
            qry.setString("code", code);
            egDemandReasonMaster = (EgDemandReasonMaster)qry.uniqueResult();
        }
        return egDemandReasonMaster;
    }

    @Override
    public List<EgDemandReason> getDemandReasonByInstallmentAndModule(Installment installment, Module module) {
        List<EgDemandReason> list = new ArrayList<EgDemandReason>();
        Query qry = null;
        if (installment != null && module != null) {
            qry = this.getCurrentSession().createQuery(" select DmdReason from EgDemandReason DmdReason , EgDemandReasonMaster master  where DmdReason.egDemandReasonMaster.id = master.id and master.egModule =:module and DmdReason.egInstallmentMaster =:installment   ");
            qry.setEntity("module", (Object)module);
            qry.setEntity("installment", (Object)installment);
            list = qry.list();
        }
        return list;
    }

    @Override
    public List<EgDemandReason> getDemandReasonByDemandReasonMaster(EgDemandReasonMaster egDemandReasonMaster) {
        List<EgDemandReason> list = new ArrayList<EgDemandReason>();
        Query qry = null;
        if (egDemandReasonMaster != null) {
            qry = this.getCurrentSession().createQuery(" from EgDemandReason DmdReason  where  DmdReason.egDemandReasonMaster =:egDemandReasonMaster  ");
            qry.setEntity("egDemandReasonMaster", (Object)egDemandReasonMaster);
            list = qry.list();
        }
        return list;
    }

    @Override
    public List<EgReasonCategory> getEgReasonCategoryByCode(String code) {
        List<EgReasonCategory> list = new ArrayList<EgReasonCategory>();
        Query qry = null;
        if (code != null && !code.equals("")) {
            qry = this.getCurrentSession().createQuery(" from EgReasonCategory  where code =:code ");
            qry.setString("code", code);
            list = qry.list();
        }
        return list;
    }

    @Override
    public EgDemandReason getDmdReasonByDmdReasonMsterInstallAndMod(EgDemandReasonMaster demandReasonMaster, Installment installment, Module module) {
        EgDemandReason egDemandReason = null;
        Query qry = null;
        if (demandReasonMaster != null && installment != null && module != null) {
            qry = this.getCurrentSession().createQuery(" select DmdReason from EgDemandReason DmdReason left join fetch DmdReason.egDemandReasonMaster reasonMaster where reasonMaster = :demandReasonMaster and reasonMaster.egModule =:module and DmdReason.egInstallmentMaster =:installment   ");
            qry.setEntity("demandReasonMaster", (Object)demandReasonMaster);
            qry.setEntity("module", (Object)module);
            qry.setEntity("installment", (Object)installment);
            if (qry.list().size() == 1) {
                egDemandReason = (EgDemandReason)qry.uniqueResult();
            } else if (qry.list().size() > 1) {
                egDemandReason = (EgDemandReason)qry.list().get(0);
            }
        }
        return egDemandReason;
    }

    @Override
    public List<EgDemandDetails> getDemandDetailsForDemand(EgDemand demand, EgwStatus status) {
        StringBuffer qryStr = new StringBuffer(2000);
        List<EgDemandDetails> list = new ArrayList<EgDemandDetails>();
        Query qry = null;
        if (demand != null) {
            qryStr.append(" select DmdDetails from EgDemand egdemand left join egdemand.egDemandDetails DmdDetails  where egdemand =:demand  ");
            if (status != null) {
                qryStr.append(" and DmdDetails.egwStatus =:status ");
            }
            qry = this.getCurrentSession().createQuery(qryStr.toString());
            qry.setEntity("demand", (Object)demand);
            if (status != null) {
                qry.setEntity("status", (Object)status);
            }
            list = qry.list();
        }
        return list;
    }

    @Override
    public List<EgDemandDetails> getDemandDetailsForDemandAndReasons(EgDemand demand, List<EgDemandReason> demandReasonList) {
        List<EgDemandDetails> list = new ArrayList<EgDemandDetails>();
        Query qry = null;
        if (demand != null && demandReasonList != null && demandReasonList.size() > 0) {
            qry = this.getCurrentSession().createQuery("select DmdDetails from EgDemand egdemand left join egdemand.egDemandDetails DmdDetails  where egdemand =:demand and DmdDetails.egDemandReason in (:demandReasonList) ");
            qry.setEntity("demand", (Object)demand);
            qry.setParameterList("demandReasonList", demandReasonList);
            list = qry.list();
        }
        return list;
    }

    @Override
    public List<EgBill> getAllBillsForDemand(EgDemand demand, String includeHistory, String includeCancelled) {
        List<EgBill> list = new ArrayList<EgBill>();
        Query qry = null;
        StringBuffer qryStr = new StringBuffer(2000);
        if (includeHistory != null && !includeHistory.equals("") && includeHistory != null && !includeCancelled.equals("")) {
            qryStr.append("from EgBill egBill  where  egBill.is_History =:includeHistory and egBill.is_Cancelled =:includeCancelled ");
            if (demand != null) {
                qryStr.append(" and egBill.egDemand =:demand ");
            }
            qryStr.append(" order by createDate desc ");
            qry = this.getCurrentSession().createQuery(qryStr.toString());
            if (demand != null) {
                qry.setEntity("demand", (Object)demand);
            }
            qry.setString("includeHistory", includeHistory);
            qry.setString("includeCancelled", includeCancelled);
            list = qry.list();
        }
        return list;
    }

    @Override
    public List getBillsByBillNumber(String BillNo, Module module) {
        Query qry = null;
        List list = new ArrayList();
        if (BillNo != null && !BillNo.equals("0") && module != null) {
            qry = this.getCurrentSession().createQuery("from EgBill egBill  where billNo =:BillNo and module =:module ");
            qry.setString("BillNo", BillNo);
            qry.setEntity("module", (Object)module);
            list = qry.list();
        }
        return list;
    }

    @Override
    public List getDmdAmtAndCollAmt(EgDemand egDemand, Installment installment) {
        List list = new ArrayList();
        if (egDemand != null && installment != null) {
            StringBuffer strBuf = new StringBuffer(2000);
            strBuf.append(" select dmdRes.ID_INSTALLMENT, sum(dmdDet.amount), sum(dmdDet.amt_collected) ").append(" from eg_demand_details dmdDet,eg_demand_reason dmdRes ,eg_demand_reason_master dmdresmas ").append(" where dmdDet.id_demand_reason=dmdRes.id and dmdDet.id_demand =:dmdId and dmdres.id_installment =:installId ").append(" and  dmdresmas.id= dmdres.id_demand_reason_master and dmdresmas.code not in('PENALTY','ADVANCE') ").append(" group by dmdRes.id_installment\t ");
            Query qry = this.getCurrentSession().createSQLQuery(strBuf.toString()).setLong("dmdId", egDemand.getId().longValue()).setInteger("installId", installment.getId().intValue());
            list = qry.list();
        }
        return list;
    }

    @Override
    public List<EgDemandDetails> getDmdDetailList(EgDemand egDemand, Installment installment, Module module, EgDemandReasonMaster dmdResMster) {
        List<EgDemandDetails> demandDetList = new ArrayList<EgDemandDetails>();
        if (egDemand != null && installment != null && module != null && dmdResMster != null) {
            EgDemandReason dmdRes = this.getDmdReasonByDmdReasonMsterInstallAndMod(dmdResMster, installment, module);
            if (dmdRes == null) {
                throw new ApplicationRuntimeException("----EgDemand Reason  is null  For EgDemandID--" + egDemand.getId() + "--with InstallmentID--" + installment.getId());
            }
            ArrayList<EgDemandReason> demandReasonList = new ArrayList<EgDemandReason>();
            demandReasonList.add(dmdRes);
            demandDetList = this.getDemandDetailsForDemandAndReasons(egDemand, demandReasonList);
        }
        return demandDetList;
    }

    @Override
    public List getDCB(EgDemand egDemand, Module module) {
        List list = new ArrayList();
        if (egDemand != null && module != null) {
            String query = " SELECT dmdres.ID_INSTALLMENT,   SUM(dmdDet.amount) as amount,   SUM(dmdDet.amt_collected) as amt_collected,   master.id, master.category, SUM(dmdDet.amt_rebate) as amt_rebate FROM eg_demand_details dmddet,   eg_demand_reason dmdres,   eg_demand_reason_master master,   eg_reason_category cate WHERE DMDDET.ID_DEMAND =:dmdId AND DMDDET.ID_DEMAND_REASON =dmdres.id AND DMDRES.ID_DEMAND_REASON_MASTER=master.id AND MASTER.CODE NOT  IN('BASE') AND master.module  =:moduleId AND cate.id = master.category GROUP BY dmdres.ID_INSTALLMENT, master.id, master.category ORDER BY dmdres.id_installment, master.category  ";
            Query qry = this.getCurrentSession().createSQLQuery(query).setLong("dmdId", egDemand.getId().longValue()).setLong("moduleId", module.getId().longValue());
            list = qry.list();
        }
        return list;
    }

    public List getReasonWiseDCB(EgDemand egDemand, Module module) {
        List list = new ArrayList();
        String query = " SELECT drm.code,  i.description,  dd.amount,  dd.amt_collected,  dd.amt_rebate,  i.id FROM eg_demand_details dd,  eg_demand_reason dr,  eg_installment_master i,  eg_demand_reason_master drm WHERE dd.id_demand_reason = dr.id  AND dr.id_installment = i.id  AND dr.id_demand_reason_master = drm.id  AND dd.id_demand =:dmdId  AND drm.module  =:moduleId ORDER BY i.start_date ";
        Query qry = this.getCurrentSession().createSQLQuery(query).setLong("dmdId", egDemand.getId().longValue()).setLong("moduleId", module.getId().longValue());
        list = qry.list();
        return list;
    }

    @Override
    public List getEgDemandReasonMasterIds(EgDemand egDemand) {
        List list = new ArrayList();
        if (egDemand != null) {
            String query = "SELECT id FROM eg_demand_reason_master WHERE code NOT LIKE 'BASE' AND id IN   (SELECT id_demand_reason_master   FROM eg_demand_reason   WHERE id IN     (SELECT id_demand_reason     FROM eg_demand_details dmddet     WHERE id_demand =:dmdId     ))  ";
            Query qry = this.getCurrentSession().createSQLQuery(query).setLong("dmdId", egDemand.getId().longValue());
            list = qry.list();
        }
        return list;
    }

    @Override
    public List<BillReceipt> getBillReceipts(EgDemand egDemand) {
        List<EgBill> billList;
        ArrayList<BillReceipt> billReceipts = null;
        if (egDemand != null && (billList = this.getAllBillsForDemand(egDemand, "N", "N")) != null && !billList.isEmpty()) {
            billReceipts = new ArrayList<BillReceipt>();
            for (EgBill egBill : billList) {
                BillReceipt billRct = this.egBillReceiptDAO.getBillReceiptByEgBill(egBill);
                if (billRct == null) continue;
                billReceipts.add(billRct);
            }
        }
        return billReceipts;
    }

    @Override
    public List<BillReceipt> getBillReceipts(List<EgDemand> egDemand) {
        List<BillReceipt> billReceipts = new ArrayList<BillReceipt>();
        Object qry = null;
        if (egDemand != null && !egDemand.isEmpty()) {
            Criteria criteria = this.getCurrentSession().createCriteria(BillReceipt.class, "billRct").createAlias("billRct.billId", "egBill", CriteriaSpecification.LEFT_JOIN).add(Restrictions.in((String)"egBill.egDemand", egDemand)).add((Criterion)Restrictions.eq((String)"billRct.isCancelled", (Object)Boolean.FALSE)).addOrder(Order.asc((String)"billRct.receiptDate"));
            billReceipts = criteria.list();
        }
        return billReceipts;
    }

    @Override
    public EgReasonCategory getReasonCategoryByCode(String code) {
        EgReasonCategory egReasonCategory = new EgReasonCategory();
        Query qry = null;
        if (code != null && !code.equals("")) {
            qry = this.getCurrentSession().createQuery(" from EgReasonCategory where code =:codeStr ");
            qry.setString("codeStr", code);
            egReasonCategory = (EgReasonCategory)qry.uniqueResult();
        }
        return egReasonCategory;
    }

    @Override
    public EgDemandReason getEgDemandReasonByCodeInstallmentModule(String demandReasonMasterCode, Installment installment, Module module, String egReasonCategoryCode) {
        EgDemandReasonMaster egDemandReasonMaster = this.getDemandReasonMasterByCode(demandReasonMasterCode, module);
        if (egDemandReasonMaster == null) {
            throw new ApplicationRuntimeException(" EgDemandReasonMaster is null for the CODE" + demandReasonMasterCode);
        }
        EgDemandReason egDemandReason = this.getDmdReasonByDmdReasonMsterInstallAndMod(egDemandReasonMaster, installment, module);
        if (egDemandReason == null) {
            throw new ApplicationRuntimeException(" EgDemandReason is null for the EgDemandReasonMaster" + egDemandReasonMaster.getId() + "Installment ::" + installment.getFromDate());
        }
        return egDemandReason;
    }

    @Override
    public BigDecimal getBalanceByDmdMasterCode(EgDemand demand, String dmdReasonMasterCode, Module module) {
        List<EgDemandDetails> dmdDetList;
        BigDecimal balance = BigDecimal.ZERO;
        if (demand != null && dmdReasonMasterCode != null && module != null && !(dmdDetList = this.getDmdDetailList(demand, demand.getEgInstallmentMaster(), module, this.getDemandReasonMasterByCode(dmdReasonMasterCode, module))).isEmpty()) {
            for (EgDemandDetails dmdDet : dmdDetList) {
                if (dmdDet.getAmount() != null) {
                    balance = balance.add(dmdDet.getAmount());
                }
                if (dmdDet.getAmtCollected() == null || dmdDet.getAmtCollected().compareTo(BigDecimal.ZERO) <= 0) continue;
                balance = balance.subtract(dmdDet.getAmtCollected());
            }
        }
        return balance;
    }

    @Override
    public List<EgdmCollectedReceipt> getAllEgdmCollectedReceipts(String receiptNo) {
        ArrayList<EgdmCollectedReceipt> CollectedReceipts = new ArrayList();
        Criteria criteria = this.getCurrentSession().createCriteria(EgdmCollectedReceipt.class, "CollReceipt").add((Criterion)Restrictions.eq((String)"CollReceipt.receiptNumber", (Object)receiptNo));
        CollectedReceipts = criteria.list();
        return CollectedReceipts;
    }

    public List getDCBByReasonCode(EgDemand egDemand, Module module, String reasonCode) {
        List list = new ArrayList();
        String query = " SELECT drm.code,  i.description,  dd.amount,  dd.amt_collected,  dd.amt_rebate,  i.id FROM eg_demand_details dd,  eg_demand_reason dr,  eg_installment_master i,  eg_demand_reason_master drm WHERE dd.id_demand_reason = dr.id  AND dr.id_installment = i.id  AND dr.id_demand_reason_master = drm.id  AND dd.id_demand =:dmdId  AND drm.module  =:moduleId AND drm.code=:reasonCode ORDER BY i.start_date ";
        Query qry = this.getCurrentSession().createSQLQuery(query).setLong("dmdId", egDemand.getId().longValue()).setLong("moduleId", module.getId().longValue()).setString("reasonCode", reasonCode);
        list = qry.list();
        return list;
    }

    @Override
    public BigDecimal getBalanceByDmdMasterCodeInst(EgDemand demand, String dmdReasonMasterCode, Module module, Installment installment) {
        List<EgDemandDetails> dmdDetList;
        BigDecimal balance = BigDecimal.ZERO;
        if (demand != null && dmdReasonMasterCode != null && module != null && !(dmdDetList = this.getDmdDetailList(demand, installment, module, this.getDemandReasonMasterByCode(dmdReasonMasterCode, module))).isEmpty()) {
            for (EgDemandDetails dmdDet : dmdDetList) {
                if (dmdDet.getAmount() != null) {
                    balance = balance.add(dmdDet.getAmount());
                }
                if (dmdDet.getAmtCollected() == null || dmdDet.getAmtCollected().compareTo(BigDecimal.ZERO) <= 0) continue;
                balance = balance.subtract(dmdDet.getAmtCollected());
            }
        }
        return balance;
    }
}

