/*
 * Decompiled with CFR 0.152.
 */
package org.egov.demand.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.egov.commons.EgwStatus;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandReason;
import org.egov.demand.model.EgdmCollectedReceipt;
import org.egov.infra.exception.ApplicationRuntimeException;

public class EgDemandDetails
implements Serializable,
Cloneable {
    private Long id;
    private EgDemandReason egDemandReason;
    private EgwStatus egwStatus;
    private String fileReferenceNo;
    private String remarks;
    private BigDecimal amount = BigDecimal.ZERO;
    private Date modifiedDate;
    private Date createDate;
    private BigDecimal amtCollected = BigDecimal.ZERO;
    private Set<EgdmCollectedReceipt> egdmCollectedReceipts = new HashSet<EgdmCollectedReceipt>();
    private BigDecimal amtRebate = BigDecimal.ZERO;
    private EgDemand egDemand;
    private static final BigDecimal ONE_PAISA_TOLERANCE_FOR_ADDCOLLECTED = new BigDecimal("0.01");

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EgDemandDetails other = (EgDemandDetails)obj;
        if (this.id == null) {
            return false;
        }
        if (other.id == null) {
            return false;
        }
        return this.id.equals(other.id);
    }

    public Object clone() {
        EgDemandDetails clone = null;
        try {
            clone = (EgDemandDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
        clone.setId(null);
        clone.setEgwStatus(null);
        clone.setEgdmCollectedReceipts(new HashSet<EgdmCollectedReceipt>());
        return clone;
    }

    public boolean hasOutstandingCollection() {
        return this.getAmtCollected() == null || this.getAmount().compareTo(this.getAmtCollected()) > 0;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EgDemandReason getEgDemandReason() {
        return this.egDemandReason;
    }

    public void setEgDemandReason(EgDemandReason egDemandReason) {
        this.egDemandReason = egDemandReason;
    }

    public EgwStatus getEgwStatus() {
        return this.egwStatus;
    }

    public void setEgwStatus(EgwStatus egwStatus) {
        this.egwStatus = egwStatus;
    }

    public String getFileReferenceNo() {
        return this.fileReferenceNo;
    }

    public void setFileReferenceNo(String fileReferenceNo) {
        this.fileReferenceNo = fileReferenceNo;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getAmtCollected() {
        return this.amtCollected;
    }

    public void setAmtCollected(BigDecimal amtCollected) {
        this.amtCollected = amtCollected;
    }

    public Set<EgdmCollectedReceipt> getEgdmCollectedReceipts() {
        return this.egdmCollectedReceipts;
    }

    public void setEgdmCollectedReceipts(Set<EgdmCollectedReceipt> egdmCollectedReceipt) {
        this.egdmCollectedReceipts = egdmCollectedReceipt;
    }

    public void addEgdmCollectedReceipt(EgdmCollectedReceipt egdmCollectedReceipt) {
        this.getEgdmCollectedReceipts().add(egdmCollectedReceipt);
    }

    public void removeEgdmCollectedReceipt(EgdmCollectedReceipt egdmCollectedReceipt) {
        this.getEgdmCollectedReceipts().remove(egdmCollectedReceipt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("").append(this.amount).append("*").append(this.amtCollected).append("*").append(this.egDemandReason).append("*").append(this.amtRebate);
        return sb.toString();
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public static EgDemandDetails fromReasonAndAmounts(BigDecimal demandAmount, EgDemandReason egDemandReason, BigDecimal collectedAmount) {
        EgDemandDetails dd = new EgDemandDetails();
        dd.setAmount(demandAmount);
        dd.setEgDemandReason(egDemandReason);
        dd.setAmtCollected(collectedAmount);
        dd.setModifiedDate(new Date());
        dd.setCreateDate(new Date());
        return dd;
    }

    public void addCollectedWithTolerance(BigDecimal amount, BigDecimal tolerance) {
        BigDecimal collected;
        BigDecimal bigDecimal = collected = this.getAmtCollected() != null ? this.getAmtCollected() : BigDecimal.ZERO;
        if (amount.compareTo(this.getAmount().subtract(collected).add(tolerance)) > 0) {
            throw new ApplicationRuntimeException("Amount being added " + amount + " is greater than " + this.getAmount() + " - " + collected + " + tolerance " + tolerance + ", for demand detail " + this.toString());
        }
        this.setAmtCollected(collected.add(amount));
    }

    public void addCollected(BigDecimal amount) {
        this.addCollectedWithTolerance(amount, BigDecimal.ZERO);
    }

    public void addCollectedWithOnePaisaTolerance(BigDecimal amount) {
        this.addCollectedWithTolerance(amount, ONE_PAISA_TOLERANCE_FOR_ADDCOLLECTED);
    }

    public BigDecimal getAmtRebate() {
        return this.amtRebate;
    }

    public void setAmtRebate(BigDecimal amtRebate) {
        this.amtRebate = amtRebate;
    }

    public void addRebateAmt(BigDecimal rebateAmt) {
        if (this.getAmtRebate() != null) {
            this.setAmtRebate(this.getAmtRebate().add(rebateAmt != null ? rebateAmt : BigDecimal.ZERO));
        } else {
            this.setAmtRebate(rebateAmt);
        }
    }

    public EgDemand getEgDemand() {
        return this.egDemand;
    }

    public void setEgDemand(EgDemand egDemand) {
        this.egDemand = egDemand;
    }

    public BigDecimal getBalance() {
        return this.getAmount().subtract(this.getAmtCollected() != null ? this.getAmtCollected() : BigDecimal.ZERO);
    }

    public Date getInstallmentStartDate() {
        return this.getEgDemandReason().getEgInstallmentMaster().getFromDate();
    }

    public Date getInstallmentEndDate() {
        return this.getEgDemandReason().getEgInstallmentMaster().getToDate();
    }

    public String getReasonCategory() {
        return this.getEgDemandReason().getEgDemandReasonMaster().getEgReasonCategory().getCode();
    }
}

