/*
 * Decompiled with CFR 0.152.
 */
package org.egov.demand.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgBillType;
import org.egov.demand.model.EgDemand;
import org.egov.infra.admin.master.entity.Module;

public class EgBill
implements Serializable {
    private Long id;
    private EgDemand egDemand;
    private EgBillType egBillType;
    private String citizenName;
    private String citizenAddress;
    private String billNo;
    private Date issueDate;
    private Date lastDate;
    private Module module;
    private Long userId;
    private Date createDate;
    private Date modifiedDate;
    private Set<EgBillDetails> egBillDetails = new HashSet<EgBillDetails>(0);
    private String is_History;
    private String is_Cancelled;
    private String fundCode;
    private BigDecimal functionaryCode;
    private String fundSourceCode;
    private String departmentCode;
    private String collModesNotAllowed;
    private Integer boundaryNum;
    private String boundaryType;
    private BigDecimal totalAmount;
    private BigDecimal totalCollectedAmount;
    private String serviceCode;
    private Boolean partPaymentAllowed;
    private Boolean overrideAccountHeadsAllowed;
    private String description;
    private BigDecimal minAmtPayable;
    private String consumerId;
    private String displayMessage;
    private Boolean callBackForApportion;
    private String transanctionReferenceNumber;
    private String emailId;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id).append("-").append(this.totalAmount).append("-").append(this.description).append("-").append(this.egBillDetails);
        return sb.toString();
    }

    public boolean containsGLCode(String glCode) {
        boolean contains = false;
        for (EgBillDetails bd : this.getEgBillDetails()) {
            if (!bd.getGlcode().equals(glCode)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public BigDecimal balanceForGLCode(String glCode) {
        BigDecimal balance = BigDecimal.ZERO;
        for (EgBillDetails bd : this.getEgBillDetails()) {
            if (!bd.getGlcode().equals(glCode)) continue;
            balance = bd.balance();
            break;
        }
        return balance;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public void setDisplayMessage(String displayMessage) {
        this.displayMessage = displayMessage;
    }

    public BigDecimal getMinAmtPayable() {
        return this.minAmtPayable;
    }

    public void setMinAmtPayable(BigDecimal minAmtPayable) {
        this.minAmtPayable = minAmtPayable;
    }

    public String getFundCode() {
        return this.fundCode;
    }

    public void setFundCode(String fundCode) {
        this.fundCode = fundCode;
    }

    public String getFundSourceCode() {
        return this.fundSourceCode;
    }

    public void setFundSourceCode(String fundSourceCode) {
        this.fundSourceCode = fundSourceCode;
    }

    public String getDepartmentCode() {
        return this.departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }

    public String getCollModesNotAllowed() {
        return this.collModesNotAllowed;
    }

    public void setCollModesNotAllowed(String collModesNotAllowed) {
        this.collModesNotAllowed = collModesNotAllowed;
    }

    public Integer getBoundaryNum() {
        return this.boundaryNum;
    }

    public void setBoundaryNum(Integer boundaryNum) {
        this.boundaryNum = boundaryNum;
    }

    public String getBoundaryType() {
        return this.boundaryType;
    }

    public void setBoundaryType(String boundaryType) {
        this.boundaryType = boundaryType;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EgDemand getEgDemand() {
        return this.egDemand;
    }

    public void setEgDemand(EgDemand egDemand) {
        this.egDemand = egDemand;
    }

    public EgBillType getEgBillType() {
        return this.egBillType;
    }

    public void setEgBillType(EgBillType egBillType) {
        this.egBillType = egBillType;
    }

    public String getCitizenName() {
        return this.citizenName;
    }

    public void setCitizenName(String citizenName) {
        this.citizenName = citizenName;
    }

    public String getCitizenAddress() {
        return this.citizenAddress;
    }

    public void setCitizenAddress(String citizenAddress) {
        this.citizenAddress = citizenAddress;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public Date getLastDate() {
        return this.lastDate;
    }

    public void setLastDate(Date lastDate) {
        this.lastDate = lastDate;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public Set<EgBillDetails> getEgBillDetails() {
        return this.egBillDetails;
    }

    public void setEgBillDetails(Set<EgBillDetails> egBillDetails) {
        this.egBillDetails = egBillDetails;
    }

    public String getIs_History() {
        return this.is_History;
    }

    public void setIs_History(String is_History) {
        this.is_History = is_History;
    }

    public String getIs_Cancelled() {
        return this.is_Cancelled;
    }

    public void setIs_Cancelled(String is_Cancelled) {
        this.is_Cancelled = is_Cancelled;
    }

    public void addEgBillDetails(EgBillDetails egBillDetails) {
        this.getEgBillDetails().add(egBillDetails);
    }

    public void removeEgBillDetails(EgBillDetails egBillDetails) {
        this.getEgBillDetails().remove(egBillDetails);
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public Boolean getPartPaymentAllowed() {
        return this.partPaymentAllowed;
    }

    public void setPartPaymentAllowed(Boolean partPaymentAllowed) {
        this.partPaymentAllowed = partPaymentAllowed;
    }

    public Boolean getOverrideAccountHeadsAllowed() {
        return this.overrideAccountHeadsAllowed;
    }

    public void setOverrideAccountHeadsAllowed(Boolean overrideAccountHeadsAllowed) {
        this.overrideAccountHeadsAllowed = overrideAccountHeadsAllowed;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getTotalCollectedAmount() {
        return this.totalCollectedAmount;
    }

    public void setTotalCollectedAmount(BigDecimal totalCollectedAmount) {
        this.totalCollectedAmount = totalCollectedAmount;
    }

    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public BigDecimal getFunctionaryCode() {
        return this.functionaryCode;
    }

    public void setFunctionaryCode(BigDecimal functionaryCode) {
        this.functionaryCode = functionaryCode;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public Boolean getCallBackForApportion() {
        return this.callBackForApportion;
    }

    public void setCallBackForApportion(Boolean callBackForApportion) {
        this.callBackForApportion = callBackForApportion;
    }

    public String getTransanctionReferenceNumber() {
        return this.transanctionReferenceNumber;
    }

    public void setTransanctionReferenceNumber(String transanctionReferenceNumber) {
        this.transanctionReferenceNumber = transanctionReferenceNumber;
    }

    public String getEmailId() {
        return this.emailId;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        EgBill other = (EgBill)obj;
        return this.id != null && other != null && this.id.equals(other.id);
    }
}

