/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dcb.bean;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.commons.Installment;
import org.egov.dcb.bean.DCBRecord;
import org.egov.dcb.bean.Receipt;
import org.egov.dcb.bean.ReceiptDetail;

public class DCBReport {
    private List<String> fieldNames;
    private Map<Installment, DCBRecord> records;
    private Map<Installment, List<Receipt>> receipts;
    private Map<String, BigDecimal> fieldBalanceTotals;
    private BigDecimal totalDmdTax;
    private BigDecimal totalDmdPnlty;
    private BigDecimal totalLpayPnlty;
    private BigDecimal totalColTax;
    private BigDecimal totalColPnlty;
    private BigDecimal totalColLpayPnlty;
    private BigDecimal totalRebate;
    private BigDecimal totalBalance;
    private BigDecimal totalAdvance;
    private String TAX = "TAX";
    private String ADVANCE = "Advance Collection";
    private String WTTAX = "Water Charges";
    private String PENALTY = "PENALTY";
    private String FINES = "FINES";
    private BigDecimal totalRcptAmt;

    public Map<Installment, List<Receipt>> getReceipts() {
        return this.receipts;
    }

    public void setReceipts(Map<Installment, List<Receipt>> receipts) {
        this.receipts = receipts;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fieldNames == null ? 0 : this.fieldNames.hashCode());
        result = 31 * result + (this.receipts == null ? 0 : this.receipts.hashCode());
        result = 31 * result + (this.records == null ? 0 : this.records.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DCBReport other = (DCBReport)obj;
        if (this.fieldNames == null ? other.fieldNames != null : !this.fieldNames.equals(other.fieldNames)) {
            return false;
        }
        if (this.receipts == null ? other.receipts != null : !this.receipts.equals(other.receipts)) {
            return false;
        }
        return !(this.records == null ? other.records != null : !this.records.equals(other.records));
    }

    public void setFieldNames(List<String> fieldNames) {
        this.fieldNames = fieldNames;
    }

    public Map<Installment, DCBRecord> getRecords() {
        return this.records;
    }

    public void setRecords(Map<Installment, DCBRecord> records) {
        this.records = records;
        this.calculateTotals();
        this.calculateBalances();
    }

    public void calculateBalances() {
        Map<Installment, DCBRecord> records = this.getRecords();
        List<String> fieldNames = this.getFieldNames();
        if (records != null && this.getFieldNames() != null && !this.getFieldNames().isEmpty() && !records.isEmpty()) {
            this.fieldBalanceTotals = new HashMap<String, BigDecimal>();
            this.totalBalance = BigDecimal.ZERO;
            for (Map.Entry<Installment, DCBRecord> record : records.entrySet()) {
                for (String fieldName : fieldNames) {
                    if (record.getKey() == null) continue;
                    if (this.fieldBalanceTotals.containsKey(fieldName)) {
                        this.fieldBalanceTotals.put(fieldName, record.getValue().getBalances().get(fieldName).add(this.fieldBalanceTotals.get(fieldName)));
                    } else {
                        this.fieldBalanceTotals.put(fieldName, record.getValue().getBalances().get(fieldName));
                    }
                    this.totalBalance = this.totalBalance.add(record.getValue().getBalances().get(fieldName));
                }
            }
        }
    }

    public void calculateTotals() {
        Map<Installment, DCBRecord> records = this.getRecords();
        List<String> fieldNames = this.getFieldNames();
        if (records != null && this.getFieldNames() != null && !this.getFieldNames().isEmpty() && !records.isEmpty()) {
            this.totalDmdTax = BigDecimal.ZERO;
            this.totalDmdPnlty = BigDecimal.ZERO;
            this.totalColTax = BigDecimal.ZERO;
            this.totalColPnlty = BigDecimal.ZERO;
            this.totalRebate = BigDecimal.ZERO;
            this.totalLpayPnlty = BigDecimal.ZERO;
            this.totalColLpayPnlty = BigDecimal.ZERO;
            this.totalAdvance = BigDecimal.ZERO;
            for (Map.Entry<Installment, DCBRecord> record : records.entrySet()) {
                for (String fieldName : fieldNames) {
                    if (record.getKey() == null) continue;
                    if (fieldName.equals(this.TAX)) {
                        this.totalDmdTax = this.totalDmdTax.add(record.getValue().getDemands().get(fieldName));
                        this.totalColTax = this.totalColTax.add(record.getValue().getCollections().get(fieldName));
                        this.totalRebate = this.totalRebate.add(record.getValue().getRebates().get(fieldName));
                    }
                    if (fieldName.equals(this.WTTAX)) {
                        this.totalDmdTax = this.totalDmdTax.add(record.getValue().getDemands().get(fieldName));
                        this.totalColTax = this.totalColTax.add(record.getValue().getCollections().get(fieldName));
                        this.totalRebate = this.totalRebate.add(record.getValue().getRebates().get(fieldName));
                    }
                    if (fieldName.equals(this.PENALTY)) {
                        this.totalDmdPnlty = this.totalDmdPnlty.add(record.getValue().getDemands().get(fieldName));
                        this.totalColPnlty = this.totalColPnlty.add(record.getValue().getCollections().get(fieldName));
                    }
                    if (fieldName.equals(this.FINES)) {
                        this.totalLpayPnlty = this.totalLpayPnlty.add(record.getValue().getDemands().get(fieldName));
                        this.totalColLpayPnlty = this.totalColLpayPnlty.add(record.getValue().getCollections().get(fieldName));
                    }
                    if (!fieldName.equals(this.ADVANCE)) continue;
                    this.totalAdvance = this.totalAdvance.add(record.getValue().getCollections().get(fieldName));
                }
            }
        }
    }

    public void backfillReceiptDetails(Map<Receipt, List<ReceiptDetail>> receiptBreakups) {
        List<ReceiptDetail> breakup = null;
        for (Map.Entry<Installment, List<Receipt>> entry : this.receipts.entrySet()) {
            for (Receipt r : entry.getValue()) {
                breakup = receiptBreakups.get(r);
                r.setReceiptDetails(breakup);
            }
        }
    }

    public void calculateReceiptTotal() {
        ArrayList<Receipt> rcpts = new ArrayList<Receipt>();
        this.totalRcptAmt = BigDecimal.ZERO;
        for (Map.Entry<Installment, List<Receipt>> receiptMap : this.getReceipts().entrySet()) {
            for (Receipt r : receiptMap.getValue()) {
                if (rcpts.contains(r) || !r.getReceiptStatus().equals(Character.valueOf('A'))) continue;
                rcpts.add(r);
                this.totalRcptAmt = this.totalRcptAmt.add(r.getReceiptAmt());
            }
        }
    }

    public BigDecimal getTotalDmdTax() {
        return this.totalDmdTax;
    }

    public void setTotalDmdTax(BigDecimal totalDmdTax) {
        this.totalDmdTax = totalDmdTax;
    }

    public BigDecimal getTotalDmdPnlty() {
        return this.totalDmdPnlty;
    }

    public void setTotalDmdPnlty(BigDecimal totalDmdPnlty) {
        this.totalDmdPnlty = totalDmdPnlty;
    }

    public BigDecimal getTotalLpayPnlty() {
        return this.totalLpayPnlty;
    }

    public void setTotalLpayPnlty(BigDecimal totalLpayPnlty) {
        this.totalLpayPnlty = totalLpayPnlty;
    }

    public BigDecimal getTotalColTax() {
        return this.totalColTax;
    }

    public void setTotalColTax(BigDecimal totalColTax) {
        this.totalColTax = totalColTax;
    }

    public BigDecimal getTotalColPnlty() {
        return this.totalColPnlty;
    }

    public void setTotalColPnlty(BigDecimal totalColPnlty) {
        this.totalColPnlty = totalColPnlty;
    }

    public BigDecimal getTotalAdvance() {
        return this.totalAdvance;
    }

    public void setTotalAdvance(BigDecimal totalAdvance) {
        this.totalAdvance = totalAdvance;
    }

    public BigDecimal getTotalColLpayPnlty() {
        return this.totalColLpayPnlty;
    }

    public void setTotalColLpayPnlty(BigDecimal totalColLpayPnlty) {
        this.totalColLpayPnlty = totalColLpayPnlty;
    }

    public BigDecimal getTotalRebate() {
        return this.totalRebate;
    }

    public void setTotalRebate(BigDecimal totalRebate) {
        this.totalRebate = totalRebate;
    }

    public BigDecimal getTotalRcptAmt() {
        return this.totalRcptAmt;
    }

    public void setTotalRcptAmt(BigDecimal totalRcptAmt) {
        this.totalRcptAmt = totalRcptAmt;
    }

    public void setTotalBalance(BigDecimal totalBalance) {
        this.totalBalance = totalBalance;
    }

    public Map<String, BigDecimal> getFieldBalanceTotals() {
        return this.fieldBalanceTotals;
    }

    public BigDecimal getTotalBalance() {
        return this.totalBalance;
    }

    public String toString() {
        return "fieldNames:" + this.fieldNames + ":records:" + this.records + ":receipts:" + this.receipts;
    }
}

