/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dcb.bean;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class DCBRecord {
    private Map<String, BigDecimal> demands;
    private Map<String, BigDecimal> collections;
    private Map<String, BigDecimal> rebates;
    private Map<String, BigDecimal> balances;

    public DCBRecord(Map<String, BigDecimal> demands, Map<String, BigDecimal> collections, Map<String, BigDecimal> rebates) {
        this.demands = demands;
        this.collections = collections;
        this.rebates = rebates;
        this.balances = new HashMap<String, BigDecimal>();
        this.calculateBalances();
    }

    public Map<String, BigDecimal> getDemands() {
        return this.demands;
    }

    public Map<String, BigDecimal> getCollections() {
        return this.collections;
    }

    void calculateBalances() {
        Map<String, BigDecimal> dmd = this.getDemands();
        if (dmd != null && !dmd.isEmpty()) {
            for (Map.Entry<String, BigDecimal> entry : dmd.entrySet()) {
                BigDecimal bal = entry.getValue().subtract(this.getCollections().get(entry.getKey()));
                if (this.balances.containsKey(entry.getKey())) {
                    this.balances.put(entry.getKey(), bal.add(this.balances.get(entry.getKey())));
                    continue;
                }
                this.balances.put(entry.getKey(), bal);
            }
        }
    }

    public Map<String, BigDecimal> getBalances() {
        return this.balances;
    }

    public Map<String, BigDecimal> getRebates() {
        return this.rebates;
    }

    public String toString() {
        return "demands:" + this.getDemands() + ",collections:" + this.getCollections() + ",rebates:" + this.getRebates();
    }
}

