CREATE SEQUENCE SEQ_EGPT_VACANCY_REMISSION;

CREATE TABLE EGPT_VACANCY_REMISSION
(
	ID			BIGINT NOT NULL,
	BASICPROPERTY		BIGINT NOT NULL,
	VACANCY_FROMDATE	TIMESTAMP WITHOUT TIME ZONE NOT NULL,
	VACANCY_TODATE		TIMESTAMP WITHOUT TIME ZONE NOT NULL,
	VACANCY_COMMENTS	VARCHAR(1000) NOT NULL,
	STATE_ID		BIGINT,
	STATUS			VARCHAR(50),
	CREATEDBY		BIGINT NOT NULL,
	CREATEDDATE     	TIMESTAMP WITHOUT TIME ZONE       NOT NULL,
	LASTMODIFIEDDATE	TIMESTAMP WITHOUT TIME ZONE       NOT NULL,
	LASTMODIFIEDBY		BIGINT NOT NULL,
	VERSION 		BIGINT,
	CONSTRAINT PK_EGPT_VACANCY_REMISSION_ID PRIMARY KEY (ID ),
	CONSTRAINT FK_EGPT_VACANCY_REMISSION_BASICPROP_ID FOREIGN KEY (BASICPROPERTY) REFERENCES EGPT_BASIC_PROPERTY (ID),
	CONSTRAINT FK_EGPT_VACANCY_REMISSION_STATE FOREIGN KEY (STATE_ID) REFERENCES EG_WF_STATES (ID),
	CONSTRAINT FK_EGPT_VACANCY_REMISSION_CREATEDBY FOREIGN KEY (CREATEDBY) REFERENCES EG_USER (ID),
	CONSTRAINT FK_EGPT_VACANCY_REMISSION_LASTMODIFIEDBY FOREIGN KEY (LASTMODIFIEDBY) REFERENCES EG_USER (ID)
);


CREATE SEQUENCE SEQ_EGPT_VACANCY_REMISSION_DETAILS;

CREATE TABLE EGPT_VACANCY_REMISSION_DETAILS
(
	ID			BIGINT NOT NULL,
	VACANCYREMISSION	BIGINT NOT NULL,
	CHECKINDATE		TIMESTAMP WITHOUT TIME ZONE NOT NULL,
	COMMENTS		VARCHAR(1000) NOT NULL,
	CREATEDBY		BIGINT NOT NULL,
	CREATEDDATE     	TIMESTAMP WITHOUT TIME ZONE       NOT NULL,
	LASTMODIFIEDDATE	TIMESTAMP WITHOUT TIME ZONE       NOT NULL,
	LASTMODIFIEDBY		BIGINT NOT NULL,
	VERSION 		BIGINT,
	CONSTRAINT PK_EGPT_VR_DETAILS_ID PRIMARY KEY (ID ),
	CONSTRAINT FK_EGPT_VR_DETAILS_VACANCYREMISSION_ID FOREIGN KEY (VACANCYREMISSION) REFERENCES EGPT_VACANCY_REMISSION (ID),
	CONSTRAINT FK_EGPT_VR_DETAILS_CREATEDBY FOREIGN KEY (CREATEDBY) REFERENCES EG_USER (ID),
	CONSTRAINT FK_EGPT_VR_DETAILS_LASTMODIFIEDBY FOREIGN KEY (LASTMODIFIEDBY) REFERENCES EG_USER (ID)
);


