/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dashboard.web.controller;

import org.apache.commons.lang3.StringUtils;
import org.egov.dashboard.config.DashboardProperties;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class DashboardHomeController {
    @Autowired
    private DashboardProperties dashboardProperties;

    @RequestMapping(value={"/home"})
    public String home() {
        return "home";
    }

    @RequestMapping(value={"/erpReports"})
    public String erpReports() {
        return "erpReports";
    }

    @RequestMapping(value={"/erpPublicReports"})
    public String erpPublicReports() {
        return "erpPublicReports";
    }

    @RequestMapping(value={"/{moduleName}"})
    public String kibanaDashboard(@PathVariable String moduleName, Model model) {
        String kibanaURL = this.dashboardProperties.getProperty("kibana.url." + moduleName);
        if (StringUtils.isNotBlank((CharSequence)kibanaURL)) {
            model.addAttribute("kibanaurl", (Object)kibanaURL.replaceAll("<city_name>", ApplicationThreadLocals.getCityName()));
            return "kibana-dashboard";
        }
        return "redirect:error/404";
    }
}

