/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.web.controller;

import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.council.autonumber.MOMResolutionNumberGenerator;
import org.egov.council.entity.CommitteeType;
import org.egov.council.entity.CouncilMeeting;
import org.egov.council.entity.CouncilMeetingType;
import org.egov.council.entity.MeetingMOM;
import org.egov.council.service.CommitteeTypeService;
import org.egov.council.service.CouncilMeetingService;
import org.egov.council.service.CouncilMeetingTypeService;
import org.egov.council.service.CouncilPreambleService;
import org.egov.council.service.CouncilReportService;
import org.egov.council.service.CouncilSmsAndEmailService;
import org.egov.council.service.es.CouncilMeetingIndexService;
import org.egov.council.utils.constants.CouncilConstants;
import org.egov.council.web.adaptor.CouncilDepartmentJsonAdaptor;
import org.egov.council.web.adaptor.CouncilMeetingJsonAdaptor;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.FileUtils;
import org.egov.infra.utils.JsonUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.web.support.json.adapter.BoundaryAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/councilmom"})
public class CouncilMomController {
    private static final String RESOLUTION_NUMBER_AUTO = "RESOLUTION_NUMBER_AUTO";
    private static final String MESSAGE = "message";
    private static final String COUNCIL_MEETING = "councilMeeting";
    private static final String COUNCIL_MOM_MEETING_SEARCH = "councilmomMeeting-search";
    private static final String COUNCILMOM_NEW = "councilMom-new";
    private static final String COUNCILMEETING_EDIT = "councilmeeting-edit";
    private static final String COUNCILMOM_RESULT = "councilmom-result";
    private static final String COUNCILMOM_SEARCH = "councilmom-search";
    private static final String COUNCILMOM_VIEW = "councilmom-view";
    private static final String COMMONERRORPAGE = "common-error-page";
    private static final String APPLICATION_RTF = "application/rtf";
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private CommitteeTypeService committeeTypeService;
    @Autowired
    private CouncilMeetingService councilMeetingService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private AutonumberServiceBeanResolver autonumberServiceBeanResolver;
    @Autowired
    private CouncilPreambleService councilPreambleService;
    @Autowired
    private CouncilReportService councilReportService;
    @Autowired
    private CouncilSmsAndEmailService councilSmsAndEmailService;
    @Autowired
    private CouncilMeetingIndexService councilMeetingIndexService;
    @Qualifier(value="fileStoreService")
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private CouncilMeetingTypeService councilMeetingTypeService;

    @ModelAttribute(value="committeeType")
    public List<CommitteeType> getCommitteTypeList() {
        return this.committeeTypeService.getActiveCommiteeType();
    }

    @ModelAttribute(value="meetingTimingMap")
    public Map<String, String> getMeetingTimingList() {
        return CouncilConstants.MEETING_TIMINGS;
    }

    @ModelAttribute(value="meetingType")
    public List<CouncilMeetingType> getmeetingTypeList() {
        return this.councilMeetingTypeService.findAllActiveMeetingType();
    }

    @ModelAttribute(value="resolutionStatus")
    public List<EgwStatus> getResolutionStatusList() {
        return this.egwStatusHibernateDAO.getStatusByModule("COUNCILRESOLUTION");
    }

    @RequestMapping(value={"/new/{id}"}, method={RequestMethod.GET})
    public String newForm(@PathVariable(value="id") Long id, Model model) {
        CouncilMeeting councilMeeting = this.councilMeetingService.findOne(id);
        if (null != councilMeeting && null != councilMeeting.getStatus()) {
            if ("APPROVED".equals(councilMeeting.getStatus().getCode())) {
                model.addAttribute(MESSAGE, (Object)"msg.attendance.not.finalizd");
                return COMMONERRORPAGE;
            }
            if ("MOM FINALISED".equals(councilMeeting.getStatus().getCode())) {
                model.addAttribute(MESSAGE, (Object)"msg.mom.alreadyfinalized");
                return COMMONERRORPAGE;
            }
        }
        if (councilMeeting != null) {
            this.sortMeetingMomByItemNumber(councilMeeting);
            model.addAttribute("autoResolutionNoGenEnabled", (Object)this.isAutoResolutionNoGenEnabled());
            model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        }
        return COUNCILMOM_NEW;
    }

    private void sortMeetingMomByItemNumber(CouncilMeeting councilMeeting) {
        councilMeeting.getMeetingMOMs().sort((f1, f2) -> Long.valueOf(f1.getItemNumber()).compareTo(Long.valueOf(f2.getItemNumber())));
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute CouncilMeeting councilMeeting, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        Long l;
        Long l2;
        if (errors.hasErrors()) {
            return COUNCILMEETING_EDIT;
        }
        EgwStatus preambleResolutionApprovedStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILPREAMBLE", "Resolution Approved");
        Long itemNumber = 0L;
        for (MeetingMOM meetingMOM : councilMeeting.getMeetingMOMs()) {
            if (meetingMOM.getId() == null) continue;
            l2 = itemNumber;
            l = itemNumber = Long.valueOf(itemNumber + 1L);
        }
        for (MeetingMOM meetingMOM : councilMeeting.getMeetingMOMs()) {
            if (meetingMOM.getPreamble().getId() != null) continue;
            meetingMOM.setPreamble(this.councilPreambleService.buildSumotoPreamble(meetingMOM, preambleResolutionApprovedStatus));
            meetingMOM.setMeeting(councilMeeting);
            l2 = itemNumber;
            l = itemNumber = Long.valueOf(itemNumber + 1L);
            meetingMOM.setItemNumber(itemNumber.toString());
        }
        councilMeeting.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILMEETING", "MOM CREATED"));
        if (councilMeeting.getFiles() != null && councilMeeting.getFiles().length > 0) {
            councilMeeting.setSupportDocs(this.councilMeetingService.addToFileStore(councilMeeting.getFiles()));
        }
        this.councilMeetingService.update(councilMeeting);
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)this.messageSource.getMessage("msg.councilMeeting.success", null, null));
        return "redirect:/councilmom/result/" + councilMeeting.getId();
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        CouncilMeeting councilMeeting = this.councilMeetingService.findOne(id);
        this.sortMeetingMomByItemNumber(councilMeeting);
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        return COUNCILMOM_RESULT;
    }

    @RequestMapping(value={"/meetingsearch/{mode}"}, method={RequestMethod.GET})
    public String searchMeeting(@PathVariable(value="mode") String mode, Model model) {
        model.addAttribute(COUNCIL_MEETING, (Object)new CouncilMeeting());
        return COUNCIL_MOM_MEETING_SEARCH;
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        CouncilMeeting councilMeeting = this.councilMeetingService.findOne(id);
        this.sortMeetingMomByItemNumber(councilMeeting);
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        return COUNCILMOM_VIEW;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        CouncilMeeting councilMeeting = new CouncilMeeting();
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        return COUNCILMOM_SEARCH;
    }

    @RequestMapping(value={"/searchcreated-mom/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchCreatedMOM(@PathVariable(value="mode") String mode, @ModelAttribute CouncilMeeting councilMeeting) {
        if (null != mode && !"".equals(mode)) {
            List searchResultList = "edit".equalsIgnoreCase(mode) ? this.councilMeetingService.searchMeetingWithMomCreatedStatus(councilMeeting) : this.councilMeetingService.searchMeeting(councilMeeting);
            return "{ \"data\":" + JsonUtils.toJSON((Collection)searchResultList, CouncilMeeting.class, CouncilMeetingJsonAdaptor.class) + "}";
        }
        return null;
    }

    @RequestMapping(value={"/departmentlist"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@ModelAttribute CouncilMeeting councilMeeting) {
        List departmentList = this.departmentService.getAllDepartments();
        return "{ \"departmentLists\":" + JsonUtils.toJSON((Collection)departmentList, Department.class, CouncilDepartmentJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/resolutionlist"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearchResolutionlist(@ModelAttribute CouncilMeeting councilMeeting) {
        List resolutionList = this.egwStatusHibernateDAO.getStatusByModule("COUNCILRESOLUTION");
        Gson gson = new Gson();
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        String json = gson.toJson((Object)resolutionList, type);
        return "{ \"resolutionLists\":" + json + "}";
    }

    @RequestMapping(value={"/wardlist"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearchWardlist(@ModelAttribute CouncilMeeting councilMeeting) {
        List wardList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "ADMINISTRATION");
        return "{ \"wardLists\":" + JsonUtils.toJSON((Collection)wardList, Boundary.class, BoundaryAdapter.class) + "}";
    }

    @RequestMapping(value={"/generateresolution"}, method={RequestMethod.POST})
    public String generateResolutionnumber(@Valid @ModelAttribute CouncilMeeting councilMeeting) throws ParseException {
        Long l;
        Long l2;
        EgwStatus resoulutionApprovedStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILRESOLUTION", "APPROVED");
        EgwStatus resoulutionAdjurnedStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILRESOLUTION", "ADJOURNED");
        EgwStatus preambleAdjurnedStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILPREAMBLE", "ADJOURNED");
        EgwStatus resolutionApprovedStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILPREAMBLE", "Resolution Approved");
        Long itemNumber = 0L;
        for (MeetingMOM meetingMOM : councilMeeting.getMeetingMOMs()) {
            if (meetingMOM.getId() == null) continue;
            l2 = itemNumber;
            l = itemNumber = Long.valueOf(itemNumber + 1L);
        }
        for (MeetingMOM meetingMOM : councilMeeting.getMeetingMOMs()) {
            if (meetingMOM.getPreamble().getId() != null) continue;
            l2 = itemNumber;
            l = itemNumber = Long.valueOf(itemNumber + 1L);
            meetingMOM.setItemNumber(itemNumber.toString());
            meetingMOM.setPreamble(this.councilPreambleService.buildSumotoPreamble(meetingMOM, resolutionApprovedStatus));
            meetingMOM.setMeeting(councilMeeting);
        }
        for (MeetingMOM meetingMOM : councilMeeting.getMeetingMOMs()) {
            if (meetingMOM.getResolutionStatus().getCode().equals(resoulutionApprovedStatus.getCode()) && this.isAutoResolutionNoGenEnabled().booleanValue()) {
                MOMResolutionNumberGenerator momResolutionNumberGenerator = (MOMResolutionNumberGenerator)this.autonumberServiceBeanResolver.getAutoNumberServiceFor(MOMResolutionNumberGenerator.class);
                meetingMOM.setResolutionNumber(meetingMOM.getResolutionNumber() != null ? meetingMOM.getResolutionNumber() : momResolutionNumberGenerator.getNextNumber(meetingMOM));
                meetingMOM.getPreamble().setStatus(resolutionApprovedStatus);
                continue;
            }
            if (!meetingMOM.getResolutionStatus().getCode().equals(resoulutionAdjurnedStatus.getCode())) continue;
            meetingMOM.getPreamble().setStatus(preambleAdjurnedStatus);
        }
        byte[] reportOutput = this.generateMomPdfByPassingMeeting(councilMeeting);
        if (reportOutput != null) {
            councilMeeting.setFilestore(this.fileStoreService.store(FileUtils.byteArrayToFile((byte[])reportOutput, (String)"MeetingResolution.rtf", (String)"rtf").toFile(), "MeetingResolution.rtf", APPLICATION_RTF, "COUNCIL"));
        }
        councilMeeting.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILMEETING", "MOM FINALISED"));
        this.councilMeetingService.update(councilMeeting);
        this.councilMeetingIndexService.createCouncilMeetingIndex(councilMeeting);
        this.councilSmsAndEmailService.sendSms(councilMeeting, null);
        this.councilSmsAndEmailService.sendEmail(councilMeeting, null, reportOutput);
        return "forward:/councilmeeting/generateresolution/" + councilMeeting.getId();
    }

    private byte[] generateMomPdfByPassingMeeting(CouncilMeeting councilMeeting) {
        return this.councilReportService.generatePDFForMom(councilMeeting);
    }

    public Boolean isAutoResolutionNoGenEnabled() {
        return this.councilPreambleService.autoGenerationModeEnabled("Council Management", RESOLUTION_NUMBER_AUTO);
    }
}

