/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.web.controller;

import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.egov.council.entity.CouncilSequenceNumber;
import org.egov.council.service.CouncilSequenceGenerationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/councilsequenceno"})
public class CouncilManualSequenceNoController {
    private static final String COUNCILSEQUENCECREATE = "councilsequence";
    @Autowired
    CouncilSequenceGenerationService councilSequenceGenerationService;

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        String preambleseq = "";
        String resolutionseq = "";
        String agendaSeq = "";
        if (!this.councilSequenceGenerationService.getPreambleLastSeq().isEmpty()) {
            preambleseq = this.councilSequenceGenerationService.getPreambleLastSeq();
        }
        if (!this.councilSequenceGenerationService.getresolutionsequence().isEmpty()) {
            resolutionseq = this.councilSequenceGenerationService.getresolutionsequence();
        }
        if (!this.councilSequenceGenerationService.getAgendaLastSeq().isEmpty()) {
            agendaSeq = this.councilSequenceGenerationService.getAgendaLastSeq();
        }
        model.addAttribute("preambleseq", (Object)preambleseq);
        model.addAttribute("councilSequenceNumber", (Object)new CouncilSequenceNumber());
        model.addAttribute("resolutionseq", (Object)resolutionseq);
        model.addAttribute("agendaSeq", (Object)agendaSeq);
        return COUNCILSEQUENCECREATE;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String createCouncilSequence(Model model, HttpServletRequest request, @ModelAttribute CouncilSequenceNumber councilSequenceNumber, BindingResult resultBinder) throws SQLException {
        String preambleseq = null;
        String resolutionseq = null;
        String agendaSeq = null;
        if (request.getParameter("lastPreambleSeq") != null) {
            preambleseq = request.getParameter("lastPreambleSeq");
        }
        if (request.getParameter("lastAgendaSeq") != null) {
            agendaSeq = request.getParameter("lastAgendaSeq");
        }
        if (request.getParameter("lastResolutionSeq") != null) {
            resolutionseq = request.getParameter("lastResolutionSeq");
        }
        this.councilSequenceGenerationService.validate((Errors)resultBinder, councilSequenceNumber, preambleseq, resolutionseq, agendaSeq);
        if (resultBinder.hasErrors()) {
            model.addAttribute("preambleseq", (Object)preambleseq);
            model.addAttribute("councilSequenceNumber", (Object)councilSequenceNumber);
            model.addAttribute("resolutionseq", (Object)resolutionseq);
            model.addAttribute("agendaSeq", (Object)agendaSeq);
            return COUNCILSEQUENCECREATE;
        }
        CouncilSequenceNumber sequence = this.councilSequenceGenerationService.create(councilSequenceNumber);
        this.councilSequenceGenerationService.updatesequences(sequence);
        model.addAttribute("message", (Object)"Sequence Numbers Updated suceesfully");
        return "councilsequence-success";
    }
}

