/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.web.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.council.entity.CommitteeType;
import org.egov.council.entity.CouncilAgendaDetails;
import org.egov.council.entity.CouncilMeeting;
import org.egov.council.entity.CouncilMeetingType;
import org.egov.council.entity.CouncilPreamble;
import org.egov.council.entity.MeetingMOM;
import org.egov.council.entity.enums.PreambleType;
import org.egov.council.service.CommitteeTypeService;
import org.egov.council.service.CouncilAgendaService;
import org.egov.council.service.CouncilMeetingService;
import org.egov.council.service.CouncilMeetingTypeService;
import org.egov.council.service.CouncilPreambleService;
import org.egov.council.utils.constants.CouncilConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/councilmom"})
public class CouncilDataEntryController {
    private static final String COUNCIL_MEETING = "councilMeeting";
    private static final String COUNCILMOM_DATAENTRY = "councilMom-dataentry";
    private static final String COUNCILMOM_VIEW = "councilmom-view";
    private static final String MEETING_MOM = "MeetingMOM";
    @Autowired
    private CommitteeTypeService committeeTypeService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private CouncilMeetingService councilMeetingService;
    @Autowired
    private CouncilMeetingTypeService councilMeetingTypeService;
    @Autowired
    private CouncilPreambleService councilPreambleService;
    @Autowired
    private CouncilAgendaService councilAgendaService;

    @ModelAttribute(value="committeeType")
    public List<CommitteeType> getCommitteTypeList() {
        return this.committeeTypeService.getActiveCommiteeType();
    }

    @ModelAttribute(value="meetingTimingMap")
    public Map<String, String> getMeetingTimingList() {
        return CouncilConstants.MEETING_TIMINGS;
    }

    @ModelAttribute(value="meetingType")
    public List<CouncilMeetingType> getMeetingTypeList() {
        return this.councilMeetingTypeService.findAllActiveMeetingType();
    }

    @RequestMapping(value={"/createdataentry"}, method={RequestMethod.GET})
    public String showCouncilForm(Model model) {
        MeetingMOM meetingMOM = new MeetingMOM();
        model.addAttribute(MEETING_MOM, (Object)meetingMOM);
        return COUNCILMOM_DATAENTRY;
    }

    @RequestMapping(value={"/savedataentry"}, method={RequestMethod.POST})
    public String update(@ModelAttribute MeetingMOM meetingMOM, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return COUNCILMOM_DATAENTRY;
        }
        ArrayList<MeetingMOM> meetingMOMList = new ArrayList<MeetingMOM>();
        ArrayList<CouncilAgendaDetails> preambleList = new ArrayList<CouncilAgendaDetails>();
        for (MeetingMOM meetingMoMs : meetingMOM.getMeeting().getMeetingMOMs()) {
            meetingMoMs.getPreamble().setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILPREAMBLE", "Resolution Approved"));
            meetingMoMs.getPreamble().setType(PreambleType.GENERAL);
            meetingMoMs.setMeeting(meetingMOM.getMeeting());
            meetingMoMs.getMeeting().setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILMEETING", "MOM FINALISED"));
            meetingMoMs.getMeeting().setCommitteeType(meetingMOM.getAgenda().getCommitteeType());
            meetingMoMs.setAgenda(meetingMOM.getAgenda());
            meetingMoMs.getAgenda().setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILAGENDA", "AGENDA USED IN MEETING"));
            meetingMoMs.setLegacy(true);
            CouncilAgendaDetails councilAgendaDetails = new CouncilAgendaDetails();
            councilAgendaDetails.setAgenda(meetingMOM.getAgenda());
            councilAgendaDetails.setPreamble(meetingMoMs.getPreamble());
            councilAgendaDetails.setItemNumber(meetingMoMs.getItemNumber());
            preambleList.add(councilAgendaDetails);
            meetingMOMList.add(meetingMoMs);
        }
        meetingMOM.getAgenda().setAgendaDetails(preambleList);
        this.councilMeetingService.createDataEntry(meetingMOMList);
        CouncilMeeting councilMeeting = this.councilMeetingService.findOne(meetingMOM.getMeeting().getId());
        this.councilMeetingService.sortMeetingMomByItemNumber(councilMeeting);
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        return COUNCILMOM_VIEW;
    }

    @RequestMapping(value={"/checkUnique-MeetingNo"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public boolean uniqueMeetingNumber(@RequestParam String meetingNumber) {
        CouncilMeeting councilMeeting = this.councilMeetingService.findByMeetingNumber(meetingNumber);
        return councilMeeting == null;
    }

    @RequestMapping(value={"/checkUnique-preambleNo"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public boolean uniquePreambleNumber(@RequestParam String preambleNumber) {
        CouncilPreamble councilPreamble = this.councilPreambleService.findbyPreambleNumber(preambleNumber);
        return councilPreamble == null;
    }

    @RequestMapping(value={"/checkUnique-resolutionNo"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public boolean uniqueResolutionNumber(@RequestParam String resolutionNumber) {
        MeetingMOM meetingMOM = this.councilMeetingService.findByResolutionNumber(resolutionNumber);
        return meetingMOM == null;
    }

    @RequestMapping(value={"/checkUnique-agendaNo"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public boolean uniqueAgendaNumber(@RequestParam String agendaNumber) {
        return this.councilAgendaService.findByAgendaNumber(agendaNumber) == null;
    }
}

