/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.web.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.council.autonumber.AgendaNumberGenerator;
import org.egov.council.entity.CommitteeType;
import org.egov.council.entity.CouncilAgenda;
import org.egov.council.entity.CouncilAgendaDetails;
import org.egov.council.entity.CouncilPreamble;
import org.egov.council.service.CommitteeTypeService;
import org.egov.council.service.CouncilAgendaService;
import org.egov.council.service.CouncilPreambleService;
import org.egov.council.web.adaptor.CouncilAgendaJsonAdaptor;
import org.egov.council.web.adaptor.CouncilPreambleJsonAdaptor;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.utils.JsonUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/agenda"})
public class CouncilAgendaController {
    private static final String AGENDA_NUMBER_AUTO = "AGENDA_NUMBER_AUTO";
    private static final String DATA = "{\"data\":";
    private static final String COUNCIL_AGENDA = "councilAgenda";
    private static final String COUNCILAGENDA_NEW = "create-agenda";
    private static final String COUNCILAGENDA_RESULT = "agenda-result";
    private static final String COUNCILAGENDA_EDIT = "agenda-edit";
    private static final String COUNCILAGENDA_VIEW = "agenda-view";
    private static final String COUNCILAGENDA_SEARCH = "agenda-search";
    private static final String COUNCILAGENDA_SEARCH_APPROVED = "council-agendaSearch";
    @Autowired
    protected DepartmentService departmentService;
    @Autowired
    protected CommitteeTypeService committeeTypeService;
    @Autowired
    protected CouncilAgendaService councilAgendaService;
    @Autowired
    protected CouncilPreambleService councilPreambleService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private AutonumberServiceBeanResolver autonumberServiceBeanResolver;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private BoundaryService boundaryService;

    @ModelAttribute(value="departments")
    public List<Department> getDepartmentList() {
        return this.departmentService.getAllDepartments();
    }

    @ModelAttribute(value="wards")
    public List<Boundary> getWardsList() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "ADMINISTRATION");
    }

    @ModelAttribute(value="committeeType")
    public List<CommitteeType> getCommitteTypeList() {
        return this.committeeTypeService.getActiveCommiteeType();
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        model.addAttribute("autoAgendaNoGenEnabled", (Object)this.isAutoAgendaNoGenEnabled());
        model.addAttribute(COUNCIL_AGENDA, (Object)new CouncilAgenda());
        model.addAttribute("councilPreamble", (Object)new CouncilPreamble());
        return COUNCILAGENDA_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute CouncilAgenda councilAgenda, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return COUNCILAGENDA_NEW;
        }
        ArrayList<CouncilAgendaDetails> preambleList = new ArrayList<CouncilAgendaDetails>();
        Long itemNumber = 1L;
        for (CouncilAgendaDetails councilAgendaDetails : councilAgenda.getCouncilAgendaDetailsForUpdate()) {
            if (councilAgendaDetails == null || councilAgendaDetails.getPreamble() == null) continue;
            itemNumber = this.buildCouncilAgendaDetails(councilAgenda, itemNumber, councilAgendaDetails);
            preambleList.add(councilAgendaDetails);
        }
        if (this.isAutoAgendaNoGenEnabled().booleanValue()) {
            AgendaNumberGenerator agendaNumberGenerator = (AgendaNumberGenerator)this.autonumberServiceBeanResolver.getAutoNumberServiceFor(AgendaNumberGenerator.class);
            councilAgenda.setAgendaNumber(agendaNumberGenerator.getNextNumber(councilAgenda));
        }
        councilAgenda.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILAGENDA", "APPROVED"));
        councilAgenda.setAgendaDetails(preambleList);
        this.councilAgendaService.create(councilAgenda);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.agenda.success", null, null));
        return "redirect:/agenda/result/" + councilAgenda.getId();
    }

    private Long buildCouncilAgendaDetails(CouncilAgenda councilAgenda, Long itemNumber, CouncilAgendaDetails councilAgendaDetails) {
        if (councilAgendaDetails.getPreamble() != null) {
            councilAgendaDetails.setPreamble(this.councilPreambleService.findOne(councilAgendaDetails.getPreamble().getId()));
            councilAgendaDetails.setAgenda(councilAgenda);
            councilAgendaDetails.setItemNumber(itemNumber.toString());
            councilAgendaDetails.setOrder(itemNumber);
            Long l = itemNumber;
            Long l2 = itemNumber = Long.valueOf(itemNumber + 1L);
            councilAgendaDetails.getPreamble().setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILPREAMBLE", "PREAMBLE USED IN AGENDA"));
        }
        return itemNumber;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        CouncilAgenda councilagenda = this.councilAgendaService.findOne(id);
        model.addAttribute(COUNCIL_AGENDA, (Object)councilagenda);
        return COUNCILAGENDA_RESULT;
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        CouncilAgenda councilAgenda = this.councilAgendaService.findOne(id);
        model.addAttribute(COUNCIL_AGENDA, (Object)councilAgenda);
        return COUNCILAGENDA_VIEW;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        model.addAttribute(COUNCIL_AGENDA, (Object)new CouncilAgenda());
        return COUNCILAGENDA_SEARCH;
    }

    @RequestMapping(value={"/searchagenda/{mode}"}, method={RequestMethod.GET})
    public String editAgenda(@PathVariable(value="mode") String mode, Model model) {
        model.addAttribute(COUNCIL_AGENDA, (Object)new CouncilAgenda());
        return COUNCILAGENDA_SEARCH_APPROVED;
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model, HttpServletResponse response) {
        CouncilAgenda councilAgenda = this.councilAgendaService.findOne(id);
        councilAgenda.setCouncilAgendaDetailsForUpdate(councilAgenda.getAgendaDetails());
        model.addAttribute(COUNCIL_AGENDA, (Object)councilAgenda);
        model.addAttribute("councilPreamble", (Object)new CouncilPreamble());
        return COUNCILAGENDA_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@ModelAttribute CouncilAgenda councilAgenda, Model model, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return COUNCILAGENDA_EDIT;
        }
        ArrayList<CouncilAgendaDetails> existingPreambleList = new ArrayList<CouncilAgendaDetails>();
        ArrayList<CouncilAgendaDetails> preambleList = new ArrayList<CouncilAgendaDetails>();
        if (!councilAgenda.getCouncilAgendaDetailsForUpdate().isEmpty()) {
            for (CouncilAgendaDetails councilAgendaDetails : councilAgenda.getAgendaDetails()) {
                councilAgendaDetails.getPreamble().setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILPREAMBLE", "APPROVED"));
                existingPreambleList.add(councilAgendaDetails);
            }
        }
        Long itemNumber = 1L;
        for (CouncilAgendaDetails councilAgendaDetails : councilAgenda.getCouncilAgendaDetailsForUpdate()) {
            if (councilAgendaDetails == null || councilAgendaDetails.getPreamble() == null) continue;
            itemNumber = this.buildCouncilAgendaDetails(councilAgenda, itemNumber, councilAgendaDetails);
            preambleList.add(councilAgendaDetails);
        }
        councilAgenda.setAgendaDetails(preambleList);
        this.councilAgendaService.update(councilAgenda);
        if (!existingPreambleList.isEmpty()) {
            this.councilAgendaService.deleteAllInBatch(existingPreambleList);
        }
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.agenda.success", null, null));
        return "redirect:/agenda/result/" + councilAgenda.getId();
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchPreamble(@PathVariable(value="mode") String mode, Model model, @ModelAttribute CouncilAgenda councilAgenda) {
        List searchResultList = this.councilAgendaService.search(councilAgenda);
        return DATA + JsonUtils.toJSON((Collection)searchResultList, CouncilAgenda.class, CouncilAgendaJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/ajaxsearch"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchPreamble(Model model, @ModelAttribute CouncilPreamble councilPreamble) {
        List searchResultList = this.councilPreambleService.searchForPreamble(councilPreamble);
        return DATA + JsonUtils.toJSON((Collection)searchResultList, CouncilPreamble.class, CouncilPreambleJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/searchagenda-tocreatemeeting"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchAgendaToCreateMeeting(Model model, @ModelAttribute CouncilAgenda councilAgenda) {
        List searchResultList = this.councilAgendaService.searchForAgendaToCreateMeeting(councilAgenda);
        return DATA + JsonUtils.toJSON((Collection)searchResultList, CouncilAgenda.class, CouncilAgendaJsonAdaptor.class) + "}";
    }

    public Boolean isAutoAgendaNoGenEnabled() {
        return this.councilPreambleService.autoGenerationModeEnabled("Council Management", AGENDA_NUMBER_AUTO);
    }
}

