/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.web.controller;

import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.RandomStringUtils;
import org.egov.council.entity.CouncilCaste;
import org.egov.council.service.CouncilCasteService;
import org.egov.council.web.adaptor.CouncilCasteJsonAdaptor;
import org.egov.infra.utils.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/councilcaste"})
public class CouncilCasteController {
    private static final String COUNCIL_CASTE = "councilCaste";
    private static final String COUNCILCASTE_NEW = "councilcaste-new";
    private static final String COUNCILCASTE_RESULT = "councilcaste-result";
    private static final String COUNCILCASTE_EDIT = "councilcaste-edit";
    private static final String COUNCILCASTE_VIEW = "councilcaste-view";
    private static final String COUNCILCASTE_SEARCH = "councilcaste-search";
    @Autowired
    private CouncilCasteService councilCasteService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        CouncilCaste councilCaste = new CouncilCaste();
        councilCaste.setCode(RandomStringUtils.random((int)4, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE).toUpperCase());
        model.addAttribute(COUNCIL_CASTE, (Object)councilCaste);
        return COUNCILCASTE_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute CouncilCaste councilCaste, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"notempty.cncl.caste");
        if (errors.hasErrors()) {
            return COUNCILCASTE_NEW;
        }
        this.councilCasteService.create(councilCaste);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.councilCaste.success", null, null));
        return "redirect:/councilcaste/result/" + councilCaste.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        CouncilCaste councilCaste = this.councilCasteService.findOne(id);
        model.addAttribute(COUNCIL_CASTE, (Object)councilCaste);
        return COUNCILCASTE_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute CouncilCaste councilCaste, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"notempty.cncl.caste");
        if (errors.hasErrors()) {
            return COUNCILCASTE_EDIT;
        }
        this.councilCasteService.update(councilCaste);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.councilCaste.success", null, null));
        return "redirect:/councilcaste/result/" + councilCaste.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        CouncilCaste councilCaste = this.councilCasteService.findOne(id);
        model.addAttribute(COUNCIL_CASTE, (Object)councilCaste);
        return COUNCILCASTE_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        CouncilCaste councilCaste = this.councilCasteService.findOne(id);
        model.addAttribute(COUNCIL_CASTE, (Object)councilCaste);
        return COUNCILCASTE_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        CouncilCaste councilCaste = new CouncilCaste();
        model.addAttribute(COUNCIL_CASTE, (Object)councilCaste);
        return COUNCILCASTE_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute CouncilCaste councilCaste) {
        List searchResultList = this.councilCasteService.search(councilCaste);
        return "{ \"data\":" + JsonUtils.toJSON((Collection)searchResultList, CouncilCaste.class, CouncilCasteJsonAdaptor.class) + "}";
    }
}

