/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.web.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.egov.council.entity.CommitteeType;
import org.egov.council.entity.CouncilMeeting;
import org.egov.council.entity.CouncilPreamble;
import org.egov.council.entity.es.CouncilMeetingDetailsSearchRequest;
import org.egov.council.entity.es.CouncilMeetingDetailsSearchResult;
import org.egov.council.entity.es.CouncilMeetingIndex;
import org.egov.council.service.CommitteeTypeService;
import org.egov.council.service.CouncilMeetingService;
import org.egov.council.service.CouncilPreambleService;
import org.egov.council.service.es.CouncilMeetingIndexService;
import org.egov.council.web.adaptor.CouncilMeetingDetailsReportJsonAdaptor;
import org.egov.council.web.adaptor.CouncilPreambleJsonAdaptor;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.utils.JsonUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/councilreports"})
public class CouncilReportsController {
    private static final String COUNCILPREAMBLE_WARDWISE_SEARCH = "preamblewardwise-report";
    private static final String COUNCILMEETING_DETAILS_SEARCH = "meetingdetails-report";
    @Autowired
    private CouncilPreambleService councilPreambleService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private CityService cityService;
    @Autowired
    private CouncilMeetingIndexService councilMeetingIndexService;
    @Autowired
    private CommitteeTypeService committeeTypeService;
    @Autowired
    private CouncilMeetingService councilMeetingService;

    @ModelAttribute(value="committeeType")
    public List<CommitteeType> getCommitteTypeList() {
        return this.committeeTypeService.getActiveCommiteeType();
    }

    @ModelAttribute(value="departments")
    public List<Department> getDepartmentList() {
        return this.departmentService.getAllDepartments();
    }

    @ModelAttribute(value="wards")
    public List<Boundary> getWardsList() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "ADMINISTRATION");
    }

    @RequestMapping(value={"/preamblewardwise/search"}, method={RequestMethod.GET})
    public String getSearchView(Model model) {
        model.addAttribute("councilPreamble", (Object)new CouncilPreamble());
        return COUNCILPREAMBLE_WARDWISE_SEARCH;
    }

    @RequestMapping(value={"/preamblewardwise/search-result"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchPreambleWardwise(Model model, @ModelAttribute CouncilPreamble councilPreamble, BindingResult errors) {
        if (errors.hasErrors()) {
            return COUNCILPREAMBLE_WARDWISE_SEARCH;
        }
        List searchResultList = this.councilPreambleService.searchPreambleForWardwiseReport(councilPreamble);
        return "{\"data\":" + JsonUtils.toJSON((Collection)searchResultList, CouncilPreamble.class, CouncilPreambleJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/meetingdetails/search"}, method={RequestMethod.GET})
    public String getMeetingDetails(Model model) {
        model.addAttribute("searchRequest", (Object)new CouncilMeetingDetailsSearchRequest());
        return COUNCILMEETING_DETAILS_SEARCH;
    }

    @RequestMapping(value={"/meetingdetails/search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchApplication(@ModelAttribute CouncilMeetingDetailsSearchRequest searchRequest) {
        ArrayList<CouncilMeetingDetailsSearchResult> searchResultFomatted = new ArrayList<CouncilMeetingDetailsSearchResult>();
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        if (cityWebsite != null) {
            searchRequest.setUlbName(cityWebsite.getName());
        }
        BoolQueryBuilder boolQuery = this.councilMeetingIndexService.prepareWhereClause(searchRequest);
        FieldSortBuilder sort = new FieldSortBuilder("committeeType").order(SortOrder.DESC);
        List detailsSearchResults = this.councilMeetingIndexService.getSearchResultByBoolQuery(boolQuery, sort);
        for (CouncilMeetingIndex councilMeetingIndex : detailsSearchResults) {
            CouncilMeeting councilmeeting = null;
            CouncilMeetingDetailsSearchResult searchResult = new CouncilMeetingDetailsSearchResult();
            searchResult.setCommitteeType(councilMeetingIndex.getCommitteeType());
            searchResult.setTotalPreambles(councilMeetingIndex.getTotalNoOfPreamblesUsed());
            searchResult.setApprovedPreambles(councilMeetingIndex.getNoOfPreamblesApproved());
            searchResult.setAdjournedPreambles(councilMeetingIndex.getNoOfPreamblesPostponed());
            searchResult.setRejectedPreambles(councilMeetingIndex.getNoOfPreamblesRejected());
            searchResult.setTotalNoOfCommitteMembers(councilMeetingIndex.getTotalNoOfCommitteMembers());
            searchResult.setNoOfCommitteMembersPresent(councilMeetingIndex.getNoOfCommitteMembersPresent());
            searchResult.setNoOfCommitteMembersAbsent(councilMeetingIndex.getNoOfCommitteMembersAbsent());
            searchResult.setMeetingDate(councilMeetingIndex.getMeetingDate());
            searchResult.setMeetingLocation(councilMeetingIndex.getMeetingLocation());
            searchResult.setMeetingNumber(councilMeetingIndex.getMeetingNumber());
            searchResult.setMeetingTime(councilMeetingIndex.getMeetingTime());
            if (councilMeetingIndex.getMeetingNumber() != null) {
                councilmeeting = this.councilMeetingService.findByMeetingNumber(councilMeetingIndex.getMeetingNumber());
            }
            if (councilmeeting != null) {
                searchResult.setId(councilmeeting.getId());
            } else {
                searchResult.setId(null);
            }
            searchResultFomatted.add(searchResult);
        }
        return "{\"data\":" + JsonUtils.toJSON(searchResultFomatted, CouncilMeetingDetailsSearchResult.class, CouncilMeetingDetailsReportJsonAdaptor.class) + "}";
    }
}

