/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.web.controller;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.log4j.Logger;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.council.autonumber.PreambleNumberGenerator;
import org.egov.council.entity.CouncilPreamble;
import org.egov.council.entity.enums.PreambleType;
import org.egov.council.service.CouncilPreambleService;
import org.egov.council.service.CouncilThirdPartyService;
import org.egov.council.web.adaptor.CouncilPreambleJsonAdaptor;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.FileStoreUtils;
import org.egov.infra.utils.JsonUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.workflow.entity.StateAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/councilpreamble"})
public class CouncilPreambleController
extends GenericWorkFlowController {
    private static final String MESSAGE2 = "message";
    private static final String APPLICATION_HISTORY = "applicationHistory";
    private static final String APPROVAL_POSITION = "approvalPosition";
    private static final String WORK_FLOW_ACTION = "workFlowAction";
    private static final String APPROVAL_COMENT = "approvalComent";
    private static final String CURRENT_STATE = "currentState";
    private static final String COUNCIL_PREAMBLE = "councilPreamble";
    private static final String COUNCILPREAMBLE_NEW = "councilpreamble-new";
    private static final String COUNCILPREAMBLE_RESULT = "councilpreamble-result";
    private static final String COUNCILPREAMBLE_EDIT = "councilpreamble-edit";
    private static final String COUNCILPREAMBLE_VIEW = "councilpreamble-view";
    private static final String COUNCILPREAMBLE_SEARCH = "councilpreamble-search";
    private static final String COUNCILPREAMBLE_UPDATE_STATUS = "councilpreamble-update-status";
    private static final String COMMONERRORPAGE = "common-error-page";
    @Autowired
    private CouncilPreambleService councilPreambleService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DepartmentService deptService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private AutonumberServiceBeanResolver autonumberServiceBeanResolver;
    @Autowired
    private CouncilThirdPartyService councilThirdPartyService;
    @Qualifier(value="fileStoreService")
    @Autowired
    protected FileStoreService fileStoreService;
    @Autowired
    protected FileStoreUtils fileStoreUtils;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private AppConfigValueService appConfigValueService;
    private static final Logger LOGGER = Logger.getLogger(CouncilPreambleController.class);

    @ModelAttribute(value="departments")
    public List<Department> getDepartmentList() {
        return this.deptService.getAllDepartments();
    }

    @ModelAttribute(value="wards")
    public List<Boundary> getWardsList() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "ADMINISTRATION");
    }

    @ModelAttribute(value="URL")
    public String getAppConfigValues() {
        List appConfigValue = this.appConfigValueService.getConfigValuesByModuleAndKey("Council Management", "budgetcheckurl");
        if (appConfigValue != null && !appConfigValue.isEmpty()) {
            return ((AppConfigValues)this.appConfigValueService.getConfigValuesByModuleAndKey("Council Management", "budgetcheckurl").get(0)).getValue();
        }
        return "";
    }

    @ModelAttribute(value="implementationStatus")
    public List<EgwStatus> getImplementationStatusList() {
        return this.egwStatusHibernateDAO.getStatusByModule("IMPLEMENTATIONSTATUS");
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        CouncilPreamble councilPreamble = new CouncilPreamble();
        councilPreamble.setType(PreambleType.GENERAL);
        model.addAttribute(COUNCIL_PREAMBLE, (Object)councilPreamble);
        this.prepareWorkFlowOnLoad(model, councilPreamble);
        model.addAttribute(CURRENT_STATE, (Object)"NEW");
        return COUNCILPREAMBLE_NEW;
    }

    private void prepareWorkFlowOnLoad(Model model, CouncilPreamble councilPreamble) {
        WorkflowContainer workFlowContainer = new WorkflowContainer();
        this.prepareWorkflow(model, (StateAware)councilPreamble, workFlowContainer);
        model.addAttribute("stateType", (Object)councilPreamble.getClass().getSimpleName());
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute CouncilPreamble councilPreamble, BindingResult errors, @RequestParam MultipartFile attachments, Model model, HttpServletRequest request, RedirectAttributes redirectAttrs, @RequestParam String workFlowAction) {
        this.validatePreamble(councilPreamble, errors);
        if (errors.hasErrors()) {
            this.prepareWorkFlowOnLoad(model, councilPreamble);
            return COUNCILPREAMBLE_NEW;
        }
        if (attachments != null && attachments.getSize() > 0L) {
            try {
                councilPreamble.setFilestoreid(this.fileStoreService.store(attachments.getInputStream(), attachments.getOriginalFilename(), attachments.getContentType(), "COUNCIL"));
            }
            catch (IOException e) {
                LOGGER.error((Object)("Error in loading documents" + e.getMessage()), (Throwable)e);
            }
        }
        PreambleNumberGenerator preamblenumbergenerator = (PreambleNumberGenerator)this.autonumberServiceBeanResolver.getAutoNumberServiceFor(PreambleNumberGenerator.class);
        councilPreamble.setPreambleNumber(preamblenumbergenerator.getNextNumber(councilPreamble));
        councilPreamble.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILPREAMBLE", "CREATED"));
        councilPreamble.setType(PreambleType.GENERAL);
        Long approvalPosition = 0L;
        String approvalComment = "";
        String approverName = "";
        String nextDesignation = "";
        if (request.getParameter(APPROVAL_COMENT) != null) {
            approvalComment = request.getParameter(APPROVAL_COMENT);
        }
        if (request.getParameter(WORK_FLOW_ACTION) != null) {
            workFlowAction = request.getParameter(WORK_FLOW_ACTION);
        }
        if (request.getParameter("approverName") != null) {
            approverName = request.getParameter("approverName");
        }
        if (request.getParameter("nextDesignation") != null) {
            nextDesignation = request.getParameter("nextDesignation");
        }
        if (request.getParameter(APPROVAL_POSITION) != null && !request.getParameter(APPROVAL_POSITION).isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter(APPROVAL_POSITION));
        }
        this.councilPreambleService.create(councilPreamble, approvalPosition, approvalComment, workFlowAction);
        String message = this.messageSource.getMessage("msg.councilPreamble.create", (Object[])new String[]{approverName.concat("~").concat(nextDesignation), councilPreamble.getPreambleNumber()}, null);
        redirectAttrs.addFlashAttribute(MESSAGE2, (Object)message);
        return "redirect:/councilpreamble/result/" + councilPreamble.getId();
    }

    @RequestMapping(value={"/downloadfile/{fileStoreId}"})
    public void download(@PathVariable String fileStoreId, HttpServletResponse response) throws IOException {
        this.fileStoreUtils.fetchFileAndWriteToStream(fileStoreId, "COUNCIL", false, response);
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        CouncilPreamble councilPreamble = this.councilPreambleService.findOne(id);
        model.addAttribute(COUNCIL_PREAMBLE, (Object)councilPreamble);
        model.addAttribute(APPLICATION_HISTORY, (Object)this.councilThirdPartyService.getHistory(councilPreamble));
        this.prepareWorkFlowOnLoad(model, councilPreamble);
        return COUNCILPREAMBLE_RESULT;
    }

    public void validatePreamble(CouncilPreamble councilPreamble, BindingResult errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"department", (String)"notempty.preamble.department");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"gistOfPreamble", (String)"notempty.preamble.gistOfPreamble");
        if (councilPreamble.getAttachments().getSize() == 0L && councilPreamble.getFilestoreid() == null) {
            errors.rejectValue("attachments", "notempty.preamble.attachments");
        }
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute CouncilPreamble councilPreamble, Model model, @RequestParam MultipartFile attachments, BindingResult errors, HttpServletRequest request, RedirectAttributes redirectAttrs, @RequestParam String workFlowAction) {
        this.validatePreamble(councilPreamble, errors);
        if (errors.hasErrors()) {
            this.prepareWorkFlowOnLoad(model, councilPreamble);
            model.addAttribute(CURRENT_STATE, (Object)councilPreamble.getCurrentState().getValue());
            return COUNCILPREAMBLE_EDIT;
        }
        if (attachments != null && attachments.getSize() > 0L) {
            try {
                councilPreamble.setFilestoreid(this.fileStoreService.store(attachments.getInputStream(), attachments.getOriginalFilename(), attachments.getContentType(), "COUNCIL"));
            }
            catch (IOException e) {
                LOGGER.error((Object)("Error in loading Employee photo" + e.getMessage()), (Throwable)e);
            }
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        String message = "";
        if (request.getParameter(APPROVAL_COMENT) != null) {
            approvalComment = request.getParameter(APPROVAL_COMENT);
        }
        if (request.getParameter(WORK_FLOW_ACTION) != null) {
            workFlowAction = request.getParameter(WORK_FLOW_ACTION);
        }
        if (request.getParameter(APPROVAL_POSITION) != null && !request.getParameter(APPROVAL_POSITION).isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter(APPROVAL_POSITION));
        }
        this.councilPreambleService.update(councilPreamble, approvalPosition, approvalComment, workFlowAction);
        if (null != workFlowAction) {
            if ("Reject".equalsIgnoreCase(workFlowAction)) {
                message = this.getMessage("msg.councilPreamble.reject", councilPreamble);
            } else if ("Approve".equalsIgnoreCase(workFlowAction)) {
                message = this.getMessage("msg.councilPreamble.success", councilPreamble);
            } else if ("Forward".equalsIgnoreCase(workFlowAction)) {
                message = this.getMessage("msg.councilPreamble.forward", councilPreamble);
            } else if ("Provide more info".equalsIgnoreCase(workFlowAction)) {
                message = this.getMessage("msg.councilPreamble.moreInfo", councilPreamble);
            }
            redirectAttrs.addFlashAttribute(MESSAGE2, (Object)message);
        }
        return "redirect:/councilpreamble/result/" + councilPreamble.getId();
    }

    @RequestMapping(value={"/updateimplimentaionstatus/{id}"}, method={RequestMethod.GET})
    public String updateStatus(@PathVariable(value="id") Long id, Model model, HttpServletResponse response) throws IOException {
        CouncilPreamble councilPreamble = this.councilPreambleService.findOne(id);
        if (null != councilPreamble.getImplementationStatus() && "Finished".equals(councilPreamble.getImplementationStatus().getCode())) {
            model.addAttribute(MESSAGE2, (Object)"msg.councilPreamble.alreadyfinished");
            return COMMONERRORPAGE;
        }
        model.addAttribute(COUNCIL_PREAMBLE, (Object)councilPreamble);
        model.addAttribute(APPLICATION_HISTORY, (Object)this.councilThirdPartyService.getHistory(councilPreamble));
        return COUNCILPREAMBLE_UPDATE_STATUS;
    }

    @RequestMapping(value={"/updateimplimentaionstatus"}, method={RequestMethod.POST})
    public String updateImplementationStatus(@Valid @ModelAttribute CouncilPreamble councilPreamble, Model model, BindingResult errors, HttpServletRequest request, RedirectAttributes redirectAttrs) {
        if (councilPreamble.getImplementationStatus().getCode() != null) {
            this.councilPreambleService.updateImplementationStatus(councilPreamble);
        }
        redirectAttrs.addFlashAttribute(MESSAGE2, (Object)this.messageSource.getMessage("msg.councilPreamble.update", null, null));
        return "redirect:/councilpreamble/result/" + councilPreamble.getId();
    }

    private String getMessage(String messageLabel, CouncilPreamble councilPreamble) {
        String message = this.messageSource.getMessage(messageLabel, (Object[])new String[]{councilPreamble.getPreambleNumber()}, null);
        return message;
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model, HttpServletResponse response) throws IOException {
        CouncilPreamble councilPreamble = this.councilPreambleService.findOne(id);
        WorkflowContainer workFlowContainer = new WorkflowContainer();
        this.prepareWorkflow(model, (StateAware)councilPreamble, workFlowContainer);
        model.addAttribute("stateType", (Object)councilPreamble.getClass().getSimpleName());
        model.addAttribute(CURRENT_STATE, (Object)councilPreamble.getCurrentState().getValue());
        model.addAttribute(COUNCIL_PREAMBLE, (Object)councilPreamble);
        model.addAttribute(APPLICATION_HISTORY, (Object)this.councilThirdPartyService.getHistory(councilPreamble));
        if ("PREAMBLEAPPROVEDFORMOM".equals(councilPreamble.getStatus().getCode())) {
            return COUNCILPREAMBLE_VIEW;
        }
        return COUNCILPREAMBLE_EDIT;
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        CouncilPreamble councilPreamble = this.councilPreambleService.findOne(id);
        model.addAttribute(COUNCIL_PREAMBLE, (Object)councilPreamble);
        model.addAttribute(APPLICATION_HISTORY, (Object)this.councilThirdPartyService.getHistory(councilPreamble));
        return COUNCILPREAMBLE_VIEW;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        model.addAttribute(COUNCIL_PREAMBLE, (Object)new CouncilPreamble());
        return COUNCILPREAMBLE_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute CouncilPreamble councilPreamble) {
        List searchResultList = "edit".equalsIgnoreCase(mode) ? this.councilPreambleService.searchFinalizedPreamble(councilPreamble) : this.councilPreambleService.search(councilPreamble);
        return "{\"data\":" + JsonUtils.toJSON((Collection)searchResultList, CouncilPreamble.class, CouncilPreambleJsonAdaptor.class) + "}";
    }
}

