/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.web.controller;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.council.autonumber.MOMResolutionNumberGenerator;
import org.egov.council.entity.CommitteeType;
import org.egov.council.entity.CouncilMeeting;
import org.egov.council.entity.MeetingMOM;
import org.egov.council.service.CommitteeTypeService;
import org.egov.council.service.CouncilMeetingService;
import org.egov.council.service.CouncilPreambleService;
import org.egov.council.service.CouncilReportService;
import org.egov.council.service.CouncilSmsAndEmailService;
import org.egov.council.service.es.CouncilMeetingIndexService;
import org.egov.council.utils.constants.CouncilConstants;
import org.egov.council.web.adaptor.CouncilDepartmentJsonAdaptor;
import org.egov.council.web.adaptor.CouncilMeetingJsonAdaptor;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.JsonUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.web.support.json.adapter.BoundaryAdapter;
import org.egov.infra.web.utils.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/councilmom"})
public class CouncilMomController {
    private static final String MESSAGE = "message";
    private static final String COUNCIL_MEETING = "councilMeeting";
    private static final String COUNCIL_MOM_MEETING_SEARCH = "councilmomMeeting-search";
    private static final String COUNCILMOM_NEW = "councilMom-new";
    private static final String COUNCILMEETING_EDIT = "councilmeeting-edit";
    private static final String COUNCILMOM_RESULT = "councilmom-result";
    private static final String COUNCILMOM_SEARCH = "councilmom-search";
    private static final String COUNCILMOM_VIEW = "councilmom-view";
    private static final String COMMONERRORPAGE = "common-error-page";
    private static final String APPLICATION_RTF = "application/rtf";
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private CommitteeTypeService committeeTypeService;
    @Autowired
    private CouncilMeetingService councilMeetingService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private AutonumberServiceBeanResolver autonumberServiceBeanResolver;
    @Autowired
    private CouncilPreambleService councilPreambleService;
    @Autowired
    private CouncilReportService councilReportService;
    @Autowired
    private CouncilSmsAndEmailService councilSmsAndEmailService;
    @Autowired
    private CouncilMeetingIndexService councilMeetingIndexService;
    @Qualifier(value="fileStoreService")
    @Autowired
    private FileStoreService fileStoreService;

    @Autowired
    @ModelAttribute(value="committeeType")
    public List<CommitteeType> getCommitteTypeList() {
        return this.committeeTypeService.getActiveCommiteeType();
    }

    @ModelAttribute(value="meetingTimingMap")
    public Map<String, String> getMeetingTimingList() {
        return CouncilConstants.MEETING_TIMINGS;
    }

    @ModelAttribute(value="resolutionStatus")
    public List<EgwStatus> getResolutionStatusList() {
        return this.egwStatusHibernateDAO.getStatusByModule("COUNCILRESOLUTION");
    }

    @RequestMapping(value={"/new/{id}"}, method={RequestMethod.GET})
    public String newForm(@PathVariable(value="id") Long id, Model model) {
        CouncilMeeting councilMeeting = this.councilMeetingService.findOne(id);
        if (null != councilMeeting && null != councilMeeting.getStatus()) {
            if ("APPROVED".equals(councilMeeting.getStatus().getCode())) {
                model.addAttribute(MESSAGE, (Object)"msg.attendance.not.finalizd");
                return COMMONERRORPAGE;
            }
            if ("MOM FINALISED".equals(councilMeeting.getStatus().getCode())) {
                model.addAttribute(MESSAGE, (Object)"msg.mom.alreadyfinalized");
                return COMMONERRORPAGE;
            }
        }
        this.sortMeetingMomByItemNumber(councilMeeting);
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        return COUNCILMOM_NEW;
    }

    private void sortMeetingMomByItemNumber(CouncilMeeting councilMeeting) {
        councilMeeting.getMeetingMOMs().sort((f1, f2) -> f1.getItemNumber().compareTo(f2.getItemNumber()));
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute CouncilMeeting councilMeeting, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return COUNCILMEETING_EDIT;
        }
        EgwStatus preambleApprovedStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILPREAMBLE", "APPROVED");
        Long itemNumber = councilMeeting.getMeetingMOMs().size();
        for (MeetingMOM meetingMOM : councilMeeting.getMeetingMOMs()) {
            if (meetingMOM.getPreamble().getId() != null) continue;
            meetingMOM.setPreamble(this.councilPreambleService.buildSumotoPreamble(meetingMOM, preambleApprovedStatus));
            meetingMOM.setMeeting(councilMeeting);
            meetingMOM.setItemNumber(itemNumber.toString());
            Long l = itemNumber;
            Long l2 = itemNumber = Long.valueOf(itemNumber + 1L);
        }
        councilMeeting.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILMEETING", "MOM CREATED"));
        this.councilMeetingService.update(councilMeeting);
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)this.messageSource.getMessage("msg.councilMeeting.success", null, null));
        return "redirect:/councilmom/result/" + councilMeeting.getId();
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        CouncilMeeting councilMeeting = this.councilMeetingService.findOne(id);
        this.sortMeetingMomByItemNumber(councilMeeting);
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        return COUNCILMOM_RESULT;
    }

    @RequestMapping(value={"/meetingsearch/{mode}"}, method={RequestMethod.GET})
    public String searchMeeting(@PathVariable(value="mode") String mode, Model model) {
        model.addAttribute(COUNCIL_MEETING, (Object)new CouncilMeeting());
        return COUNCIL_MOM_MEETING_SEARCH;
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        CouncilMeeting councilMeeting = this.councilMeetingService.findOne(id);
        this.sortMeetingMomByItemNumber(councilMeeting);
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        return COUNCILMOM_VIEW;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        CouncilMeeting councilMeeting = new CouncilMeeting();
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        return COUNCILMOM_SEARCH;
    }

    @RequestMapping(value={"/searchcreated-mom/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchCreatedMOM(@PathVariable(value="mode") String mode, Model model, @ModelAttribute CouncilMeeting councilMeeting) {
        if (null != mode && !"".equals(mode)) {
            List searchResultList = "edit".equalsIgnoreCase(mode) ? this.councilMeetingService.searchMeetingWithMomCreatedStatus(councilMeeting) : this.councilMeetingService.searchMeeting(councilMeeting);
            return "{ \"data\":" + JsonUtils.toJSON((Collection)searchResultList, CouncilMeeting.class, CouncilMeetingJsonAdaptor.class) + "}";
        }
        return null;
    }

    @RequestMapping(value={"/departmentlist"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(String mode, Model model, @ModelAttribute CouncilMeeting councilMeeting) {
        List departmentList = this.departmentService.getAllDepartments();
        return "{ \"departmentLists\":" + JsonUtils.toJSON((Collection)departmentList, Department.class, CouncilDepartmentJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/resolutionlist"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearchResolutionlist(String mode, Model model, @ModelAttribute CouncilMeeting councilMeeting) {
        List resolutionList = this.egwStatusHibernateDAO.getStatusByModule("COUNCILRESOLUTION");
        Gson gson = new Gson();
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        String json = gson.toJson((Object)resolutionList, type);
        return "{ \"resolutionLists\":" + json + "}";
    }

    @RequestMapping(value={"/wardlist"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearchWardlist(String mode, Model model, @ModelAttribute CouncilMeeting councilMeeting) {
        List wardList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "ADMINISTRATION");
        return "{ \"wardLists\":" + JsonUtils.toJSON((Collection)wardList, Boundary.class, BoundaryAdapter.class) + "}";
    }

    @RequestMapping(value={"/generateresolution"}, method={RequestMethod.POST})
    public String generateResolutionnumber(@Valid @ModelAttribute CouncilMeeting councilMeeting, BindingResult errors, Model model, RedirectAttributes redirectAttrs, HttpServletRequest request) throws ParseException {
        EgwStatus preambleApprovedStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILPREAMBLE", "APPROVED");
        EgwStatus resoulutionApprovedStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILRESOLUTION", "APPROVED");
        EgwStatus resoulutionAdjurnedStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILRESOLUTION", "ADJOURNED");
        EgwStatus preambleAdjurnedStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILPREAMBLE", "ADJOURNED");
        EgwStatus resolutionApprovedStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILPREAMBLE", "Resolution Approved");
        Long itemNumber = councilMeeting.getMeetingMOMs().size();
        for (MeetingMOM meetingMOM : councilMeeting.getMeetingMOMs()) {
            if (meetingMOM.getPreamble().getId() != null) continue;
            meetingMOM.setItemNumber(itemNumber.toString());
            Long l = itemNumber;
            Long l2 = itemNumber = Long.valueOf(itemNumber + 1L);
            meetingMOM.setPreamble(this.councilPreambleService.buildSumotoPreamble(meetingMOM, preambleApprovedStatus));
            meetingMOM.setMeeting(councilMeeting);
        }
        for (MeetingMOM meetingMOM : councilMeeting.getMeetingMOMs()) {
            if (meetingMOM.getResolutionStatus().getCode().equals(resoulutionApprovedStatus.getCode())) {
                MOMResolutionNumberGenerator momResolutionNumberGenerator = (MOMResolutionNumberGenerator)this.autonumberServiceBeanResolver.getAutoNumberServiceFor(MOMResolutionNumberGenerator.class);
                meetingMOM.setResolutionNumber(momResolutionNumberGenerator.getNextNumber(meetingMOM));
                meetingMOM.getPreamble().setStatus(resolutionApprovedStatus);
                continue;
            }
            if (!meetingMOM.getResolutionStatus().getCode().equals(resoulutionAdjurnedStatus.getCode())) continue;
            meetingMOM.getPreamble().setStatus(preambleAdjurnedStatus);
        }
        byte[] reportOutput = this.generateMomPdfByPassingMeeting(councilMeeting, request);
        if (reportOutput != null) {
            councilMeeting.setFilestore(this.fileStoreService.store((InputStream)new ByteArrayInputStream(reportOutput), "MeetingResolution.rtf", APPLICATION_RTF, "COUNCIL"));
        }
        councilMeeting.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILMEETING", "MOM FINALISED"));
        this.councilMeetingService.update(councilMeeting);
        this.councilMeetingIndexService.createCouncilMeetingIndex(councilMeeting);
        this.councilSmsAndEmailService.sendSms(councilMeeting, null);
        this.councilSmsAndEmailService.sendEmail(councilMeeting, null, reportOutput);
        return "forward:/councilmeeting/generateresolution/" + councilMeeting.getId();
    }

    private byte[] generateMomPdfByPassingMeeting(CouncilMeeting councilMeeting, HttpServletRequest request) {
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        String logoPath = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
        byte[] reportOutput = this.councilReportService.generatePDFForMom(councilMeeting, logoPath);
        return reportOutput;
    }
}

