/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.web.controller;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.egov.council.entity.CouncilMember;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component
public class CouncilMemberValidator
implements Validator {
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final String MOBILE_PATTERN = "[0-9]{10}";
    private Pattern pattern;
    private Matcher matcher;

    public boolean supports(Class<?> clazz) {
        return CouncilMember.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        CouncilMember member = (CouncilMember)target;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"designation", (String)"notempty.cncl.designation");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"qualification", (String)"notempty.cncl.qualification");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"notempty.cncl.member.name");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"gender", (String)"notempty.cncl.gender");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"mobileNumber", (String)"notempty.cncl.mobileNumber");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"birthDate", (String)"notempty.cncl.birthDate");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"emailId", (String)"notempty.cncl.emailId");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"residentialAddress", (String)"notempty.cncl.residentialAddress");
        if (member != null && member.getDesignation() != null && "Co-Option".equalsIgnoreCase(member.getDesignation().getName())) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"category", (String)"notempty.cncl.category");
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"caste", (String)"notempty.cncl.caste");
        } else if (member == null || member.getDesignation() == null || !"Special Officer".equalsIgnoreCase(member.getDesignation().getName())) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"caste", (String)"notempty.cncl.caste");
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"electionDate", (String)"notempty.cncl.electionDate");
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"oathDate", (String)"notempty.cncl.oathDate");
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"partyAffiliation", (String)"notempty.cncl.partyAffiliation");
        }
        this.validateMobileNumber(errors, member);
        this.validateEmail(errors, member);
        this.validateOathAndElectionDate(errors, member);
    }

    private void validateOathAndElectionDate(Errors errors, CouncilMember member) {
        if (member != null && member.getElectionDate() != null && member.getOathDate() != null && member.getOathDate().compareTo(member.getElectionDate()) < 0) {
            errors.rejectValue("oathDate", "validate.oathdate");
        }
    }

    private void validateEmail(Errors errors, CouncilMember member) {
        if (member != null && member.getEmailId() != null) {
            this.pattern = Pattern.compile(EMAIL_PATTERN);
            this.matcher = this.pattern.matcher(member.getEmailId());
            if (!this.matcher.matches()) {
                errors.rejectValue("emailId", "validate.email.id");
            }
        }
    }

    private void validateMobileNumber(Errors errors, CouncilMember member) {
        if (member != null && member.getMobileNumber() != null) {
            this.pattern = Pattern.compile(MOBILE_PATTERN);
            this.matcher = this.pattern.matcher(member.getMobileNumber());
            if (!this.matcher.matches()) {
                errors.rejectValue("mobileNumber", "validate.mobile.no");
            }
        }
    }
}

