/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.web.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang.RandomStringUtils;
import org.egov.council.entity.CommitteeMembers;
import org.egov.council.entity.CommitteeType;
import org.egov.council.entity.CouncilMember;
import org.egov.council.service.CommitteeTypeService;
import org.egov.council.service.CouncilCommitteeMemberService;
import org.egov.council.service.CouncilMemberService;
import org.egov.council.web.adaptor.CouncilCommitteeTypeJsonAdaptor;
import org.egov.infra.utils.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/committeetype"})
public class CouncilCommitteeTypeController {
    private static final String IS_SELECTED_ALL = "isSelectedAll";
    private static final String COUNCIL_MEMBERS = "councilMembers";
    private static final String COMMITTEE_TYPE = "committeeType";
    private static final String COUNCILCOMMITTEETYPE_NEW = "councilcommittetype-new";
    private static final String COUNCILCOMMITTEETYPE_RESULT = "councilcommitteetype-result";
    private static final String COUNCILCOMMITTEETYPE_EDIT = "councilcommitteetype-edit";
    private static final String COUNCILCOMMITTEETYPE_VIEW = "councilcommitteetype-view";
    private static final String COUNCILCOMMITTEETYPE_SEARCH = "councilcommitteetype-search";
    @Autowired
    private CommitteeTypeService committeeTypeService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private CouncilMemberService councilMemberService;
    @Autowired
    private CouncilCommitteeMemberService councilCommitteeMemberService;

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        CommitteeType committeeType = new CommitteeType();
        committeeType.setCode(RandomStringUtils.random((int)4, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE).toUpperCase());
        model.addAttribute(COUNCIL_MEMBERS, (Object)this.councilMemberService.findAllByActive());
        model.addAttribute(COMMITTEE_TYPE, (Object)committeeType);
        return COUNCILCOMMITTEETYPE_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute CommitteeType committeeType, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"notempty.cncl.committee.name");
        ArrayList committeeMembersList = new ArrayList();
        if (errors.hasErrors()) {
            int unselectedCount = 0;
            ArrayList<CouncilMember> councilMembers = new ArrayList<CouncilMember>();
            for (CommitteeMembers committeeMembers : committeeType.getCommiteemembers()) {
                CouncilMember councilMember = committeeMembers.getCouncilMember();
                if (!councilMember.getChecked().booleanValue()) {
                    ++unselectedCount;
                }
                councilMembers.add(committeeMembers.getCouncilMember());
            }
            model.addAttribute(IS_SELECTED_ALL, (Object)(unselectedCount == 0 ? 1 : 0));
            model.addAttribute(COUNCIL_MEMBERS, councilMembers);
            model.addAttribute(COMMITTEE_TYPE, (Object)committeeType);
            return COUNCILCOMMITTEETYPE_NEW;
        }
        for (CommitteeMembers committeeMembers : committeeType.getCommiteemembers()) {
            if (committeeMembers == null || committeeMembers.getCouncilMember() == null || !committeeMembers.getCouncilMember().getChecked().booleanValue()) continue;
            committeeMembers.setCouncilMember(committeeMembers.getCouncilMember());
            this.setCommitteeTypeAndMembers(committeeType, committeeMembersList, committeeMembers);
        }
        committeeType.getCommiteemembers().clear();
        committeeType.setCommiteemembers(committeeMembersList);
        this.committeeTypeService.create(committeeType);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.councilCommitteeType.success", null, null));
        return "redirect:/committeetype/result/" + committeeType.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        CommitteeType committeeType = this.committeeTypeService.findOne(id);
        model.addAttribute(COMMITTEE_TYPE, (Object)committeeType);
        model.addAttribute("committeeMembers", (Object)this.councilCommitteeMemberService.findAllByCommitteType(committeeType));
        return COUNCILCOMMITTEETYPE_VIEW;
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        CommitteeType committeeType = this.committeeTypeService.findOne(id);
        CommitteeType committeeType1 = new CommitteeType();
        committeeType1.setId(committeeType.getId());
        committeeType1.setCode(committeeType.getCode());
        committeeType1.setName(committeeType.getName());
        committeeType1.setIsActive(committeeType.getIsActive());
        List councilMembers = this.councilMemberService.findAll();
        int unselectedCount = 0;
        if (committeeType1.getCommiteemembers().isEmpty()) {
            for (CouncilMember councilMember : councilMembers) {
                for (CommitteeMembers committeeMembers : committeeType.getCommiteemembers()) {
                    if (!committeeMembers.getCouncilMember().getId().equals(councilMember.getId())) continue;
                    councilMember.setChecked(Boolean.valueOf(true));
                    break;
                }
                if (councilMember.getChecked() != null) continue;
                ++unselectedCount;
            }
        }
        model.addAttribute(IS_SELECTED_ALL, (Object)(unselectedCount == 0 ? 1 : 0));
        model.addAttribute(COUNCIL_MEMBERS, (Object)councilMembers);
        model.addAttribute(COMMITTEE_TYPE, (Object)committeeType1);
        return COUNCILCOMMITTEETYPE_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute CommitteeType committeeType, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        List existingCommitteeMembersList = this.councilCommitteeMemberService.findAllByCommitteTypeMemberIsActive(committeeType);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"notempty.cncl.committee.name");
        if (errors.hasErrors()) {
            int unselectedCount = 0;
            ArrayList<CouncilMember> councilMembers = new ArrayList<CouncilMember>();
            for (CommitteeMembers committeeMembers : committeeType.getCommiteemembers()) {
                CouncilMember councilMember = committeeMembers.getCouncilMember();
                if (!councilMember.getChecked().booleanValue()) {
                    ++unselectedCount;
                }
                councilMembers.add(committeeMembers.getCouncilMember());
            }
            model.addAttribute(IS_SELECTED_ALL, (Object)(unselectedCount == 0 ? 1 : 0));
            model.addAttribute(COUNCIL_MEMBERS, councilMembers);
            model.addAttribute(COMMITTEE_TYPE, (Object)committeeType);
            return COUNCILCOMMITTEETYPE_EDIT;
        }
        ArrayList committeeMembersList = new ArrayList();
        ArrayList<CommitteeMembers> deleteCommitteeMembersList = new ArrayList<CommitteeMembers>();
        this.setCommitteeMembers(committeeType, committeeMembersList);
        committeeType.setCommiteemembers(committeeMembersList);
        for (CommitteeMembers committeeMembers : existingCommitteeMembersList) {
            if (committeeType.getCommiteemembers().contains(committeeMembers)) continue;
            deleteCommitteeMembersList.add(committeeMembers);
        }
        this.councilCommitteeMemberService.delete(deleteCommitteeMembersList);
        this.committeeTypeService.update(committeeType);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.councilCommitteeType.success", null, null));
        return "redirect:/committeetype/result/" + committeeType.getId();
    }

    private void setCommitteeMembers(CommitteeType committeeType, List<CommitteeMembers> committeeMembersList) {
        for (CommitteeMembers committeeMembers : committeeType.getCommiteemembers()) {
            if (committeeMembers.getChecked() != null && committeeMembers.getChecked().booleanValue() && committeeMembers.getId() != null) {
                this.setCommitteeTypeAndMembers(committeeType, committeeMembersList, committeeMembers);
                continue;
            }
            if (committeeMembers.getCouncilMember().getChecked() == null || !committeeMembers.getCouncilMember().getChecked().booleanValue() || committeeMembers.getCouncilMember().getId() == null) continue;
            this.setCommitteeTypeAndMembers(committeeType, committeeMembersList, committeeMembers);
        }
    }

    private void setCommitteeTypeAndMembers(CommitteeType committeeType, List<CommitteeMembers> committeeMembersList, CommitteeMembers committeeMembers) {
        committeeMembers.setCommitteeType(committeeType);
        committeeMembersList.add(committeeMembers);
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        CommitteeType committeeType = this.committeeTypeService.findOne(id);
        model.addAttribute(COMMITTEE_TYPE, (Object)committeeType);
        model.addAttribute("committeeMembers", (Object)this.councilCommitteeMemberService.findAllByCommitteType(committeeType));
        return COUNCILCOMMITTEETYPE_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        CommitteeType committeeType = new CommitteeType();
        model.addAttribute(COMMITTEE_TYPE, (Object)committeeType);
        return COUNCILCOMMITTEETYPE_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute CommitteeType committeeType) {
        List searchResultList = this.committeeTypeService.search(committeeType);
        return "{ \"data\":" + JsonUtils.toJSON((Collection)searchResultList, CommitteeType.class, CouncilCommitteeTypeJsonAdaptor.class) + "}";
    }
}

