/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.web.controller;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.council.autonumber.CouncilMeetingNumberGenerator;
import org.egov.council.entity.CommitteeMembers;
import org.egov.council.entity.CommitteeType;
import org.egov.council.entity.CouncilAgenda;
import org.egov.council.entity.CouncilAgendaDetails;
import org.egov.council.entity.CouncilMeeting;
import org.egov.council.entity.MeetingAttendence;
import org.egov.council.entity.MeetingMOM;
import org.egov.council.service.CommitteeTypeService;
import org.egov.council.service.CouncilAgendaService;
import org.egov.council.service.CouncilCommitteeMemberService;
import org.egov.council.service.CouncilMeetingService;
import org.egov.council.service.CouncilReportService;
import org.egov.council.service.CouncilSmsAndEmailService;
import org.egov.council.utils.constants.CouncilConstants;
import org.egov.council.web.adaptor.CouncilMeetingJsonAdaptor;
import org.egov.council.web.adaptor.MeetingAttendanceJsonAdaptor;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.FileStoreUtils;
import org.egov.infra.utils.JsonUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.web.utils.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/councilmeeting"})
public class CouncilMeetingController {
    private static final String APPLICATION_PDF = "application/pdf";
    private static final String DATA = "{ \"data\":";
    private static final String MSG_ATTENDANCE_ALREADY_FINALIZD = "msg.attendance.already.finalizd";
    private static final String CITYLOGO = "citylogo";
    private static final String COUNCIL_MEETING = "councilMeeting";
    private static final String MESSAGE = "message";
    private static final String COUNCILMEETING_NEW = "councilmeeting-new";
    private static final String COMMONERRORPAGE = "common-error-page";
    private static final String COUNCILMEETING_RESULT = "councilmeeting-result";
    private static final String COUNCILMEETING_EDIT = "councilmeeting-edit";
    private static final String COUNCILMEETING_VIEW = "councilmeeting-view";
    private static final String COUNCILMEETING_SEARCH = "councilmeeting-search";
    private static final String COUNCIL_MEETING_AGENDA_SEARCH = "councilmeetingAgenda-search";
    private static final String COUNCILMEETING_ATTENDANCE_SEARCH = "councilmeeting-attendsearch";
    private static final String COUNCILMEETING_ATTENDANCE_VIEW = "councilmeeting-attendsearch-view";
    private static final String COUNCILMEETING_SEND_SMS_EMAIL = "councilmeetingsearch-tosendsms-email";
    private static final String COUNCILMEETING_EDIT_ATTENDANCE = "councilmeeting-attend-form";
    private static final String COUNCILMEETING_ATTENDANCE_RESULT = "councilmeeting-attend-result";
    @Autowired
    private CouncilMeetingService councilMeetingService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private CouncilAgendaService councilAgendaService;
    @Autowired
    private AutonumberServiceBeanResolver autonumberServiceBeanResolver;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private CommitteeTypeService committeeTypeService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private CouncilSmsAndEmailService councilSmsAndEmailService;
    @Autowired
    private CouncilReportService councilReportService;
    @Autowired
    protected FileStoreUtils fileStoreUtils;
    @Qualifier(value="fileStoreService")
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private CouncilCommitteeMemberService committeeMemberService;

    @ModelAttribute(value="committeeType")
    public List<CommitteeType> getCommitteTypeList() {
        return this.committeeTypeService.getActiveCommiteeType();
    }

    @ModelAttribute(value="meetingTimingMap")
    public Map<String, String> getMeetingTimingList() {
        return CouncilConstants.MEETING_TIMINGS;
    }

    @ModelAttribute(value="departments")
    public List<Department> getDepartmentList() {
        return this.departmentService.getAllDepartments();
    }

    @RequestMapping(value={"/new/{id}"}, method={RequestMethod.GET})
    public String newForm(@ModelAttribute CouncilMeeting councilMeeting, @PathVariable(value="id") Long id, Model model) {
        CouncilAgenda councilAgenda = this.councilAgendaService.findOne(id);
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        if (councilAgenda != null && "AGENDA USED IN MEETING".equals(councilAgenda.getStatus().getCode())) {
            model.addAttribute(MESSAGE, (Object)"msg.agenda.exist");
            return COMMONERRORPAGE;
        }
        if (councilAgenda != null) {
            councilMeeting.setCommitteeType(councilAgenda.getCommitteeType());
            this.buildMeetingMomByUsingAgendaDetails(councilMeeting, councilAgenda);
            return COUNCILMEETING_NEW;
        }
        model.addAttribute(MESSAGE, (Object)"msg.invalid.agenda.details");
        return COMMONERRORPAGE;
    }

    private void buildMeetingMomByUsingAgendaDetails(CouncilMeeting councilMeeting, CouncilAgenda councilAgenda) {
        Long itemNumber = 1L;
        for (CouncilAgendaDetails councilAgendaDetail : councilAgenda.getAgendaDetails()) {
            MeetingMOM meetingMom = new MeetingMOM();
            meetingMom.setMeeting(councilMeeting);
            meetingMom.setAgenda(councilAgendaDetail.getAgenda());
            meetingMom.setPreamble(councilAgendaDetail.getPreamble());
            meetingMom.setItemNumber(itemNumber.toString());
            Long l = itemNumber;
            Long l2 = itemNumber = Long.valueOf(itemNumber + 1L);
            councilMeeting.addMeetingMoms(meetingMom);
        }
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute CouncilMeeting councilMeeting, BindingResult errors, Model model, RedirectAttributes redirectAttrs, HttpServletRequest request) {
        this.validateCouncilMeeting(errors);
        if (errors.hasErrors()) {
            return COUNCILMEETING_NEW;
        }
        if (councilMeeting.getStatus() == null) {
            councilMeeting.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILMEETING", "APPROVED"));
        }
        CouncilMeetingNumberGenerator meetingNumberGenerator = (CouncilMeetingNumberGenerator)this.autonumberServiceBeanResolver.getAutoNumberServiceFor(CouncilMeetingNumberGenerator.class);
        councilMeeting.setMeetingNumber(meetingNumberGenerator.getNextNumber(councilMeeting));
        for (MeetingMOM meetingMom : councilMeeting.getMeetingMOMs()) {
            meetingMom.setMeeting(councilMeeting);
            meetingMom.getAgenda().setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILAGENDA", "AGENDA USED IN MEETING"));
        }
        this.councilMeetingService.create(councilMeeting);
        this.councilSmsAndEmailService.sendSms(councilMeeting, null);
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        String logoPath = url.concat("/egi").concat((String)request.getSession().getAttribute(CITYLOGO));
        this.councilSmsAndEmailService.sendEmail(councilMeeting, null, this.councilReportService.generatePDFForAgendaDetails(councilMeeting, logoPath));
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)this.messageSource.getMessage("msg.councilMeeting.success", null, null));
        return "redirect:/councilmeeting/result/" + councilMeeting.getId();
    }

    private void validateCouncilMeeting(BindingResult errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"meetingDate", (String)"notempty.meeting.meetingDate");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"meetingTime", (String)"notempty.meeting.meetingTime");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"meetingLocation", (String)"notempty.meeting.committeeType");
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model, HttpServletResponse response) throws IOException {
        CouncilMeeting councilMeeting = this.councilMeetingService.findOne(id);
        this.sortMeetingMomByItemNumber(councilMeeting);
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        return COUNCILMEETING_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute CouncilMeeting councilMeeting, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        this.validateCouncilMeeting(errors);
        if (errors.hasErrors()) {
            return COUNCILMEETING_EDIT;
        }
        this.councilMeetingService.update(councilMeeting);
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)this.messageSource.getMessage("msg.councilMeeting.success", null, null));
        return "redirect:/councilmeeting/result/" + councilMeeting.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        CouncilMeeting councilMeeting = this.councilMeetingService.findOne(id);
        this.sortMeetingMomByItemNumber(councilMeeting);
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        return COUNCILMEETING_VIEW;
    }

    private void sortMeetingMomByItemNumber(CouncilMeeting councilMeeting) {
        councilMeeting.getMeetingMOMs().sort((f1, f2) -> f1.getItemNumber().compareTo(f2.getItemNumber()));
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        CouncilMeeting councilMeeting = this.councilMeetingService.findOne(id);
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        model.addAttribute("commiteemembelist", (Object)councilMeeting.getCommitteeType().getCommiteemembers());
        return COUNCILMEETING_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        CouncilMeeting councilMeeting = new CouncilMeeting();
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        return COUNCILMEETING_SEARCH;
    }

    @RequestMapping(value={"/agendasearch/{mode}"}, method={RequestMethod.GET})
    public String searchagenda(@PathVariable(value="mode") String mode, Model model) {
        model.addAttribute("councilAgenda", (Object)new CouncilAgenda());
        return COUNCIL_MEETING_AGENDA_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute CouncilMeeting councilMeeting) {
        if (null != mode && !"".equals(mode)) {
            List searchResultList = "edit".equalsIgnoreCase(mode) ? this.councilMeetingService.searchMeetingForEdit(councilMeeting) : this.councilMeetingService.searchMeeting(councilMeeting);
            return DATA + JsonUtils.toJSON((Collection)searchResultList, CouncilMeeting.class, CouncilMeetingJsonAdaptor.class) + "}";
        }
        return null;
    }

    @RequestMapping(value={"/searchmeeting-tocreatemom"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchMeetingAndToCreateMOM(Model model, @ModelAttribute CouncilMeeting councilMeeting) {
        List searchResultList = this.councilMeetingService.searchMeetingToCreateMOM(councilMeeting);
        return DATA + JsonUtils.toJSON((Collection)searchResultList, CouncilMeeting.class, CouncilMeetingJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/viewsmsemail"}, method={RequestMethod.GET})
    public String retrieveSmsAndEmailDetailsForCouncilMeeting(Model model) {
        CouncilMeeting councilMeeting = new CouncilMeeting();
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        model.addAttribute("mode", (Object)"view");
        return COUNCILMEETING_SEND_SMS_EMAIL;
    }

    @RequestMapping(value={"/sendsmsemail"}, method={RequestMethod.GET})
    @ResponseBody
    public String sendSmsAndEmailDetailsForCouncilMeeting(@RequestParam(value="id") Long id, @RequestParam(value="msg") String msg, Model model, HttpServletRequest request) {
        CouncilMeeting councilMeeting = this.councilMeetingService.findOne(id);
        this.councilSmsAndEmailService.sendSms(councilMeeting, msg);
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        String logoPath = url.concat("/egi").concat((String)request.getSession().getAttribute(CITYLOGO));
        this.councilSmsAndEmailService.sendEmail(councilMeeting, msg, this.councilReportService.generatePDFForAgendaDetails(councilMeeting, logoPath));
        return "{ \"success\":true }";
    }

    @RequestMapping(value={"/generateresolution/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewDemandNoticeReport(@PathVariable Long id, HttpSession session, HttpServletRequest request) {
        CouncilMeeting councilMeeting = this.councilMeetingService.findOne(id);
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        String logoPath = url.concat("/egi").concat((String)request.getSession().getAttribute(CITYLOGO));
        byte[] reportOutput = this.councilReportService.generatePDFForMom(councilMeeting, logoPath);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)APPLICATION_PDF));
        headers.add("content-disposition", "inline;filename=Resolution.pdf");
        return new ResponseEntity((Object)reportOutput, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/attendance/search"}, method={RequestMethod.GET})
    public String getSearchAttendance(Model model) {
        CouncilMeeting councilMeeting = new CouncilMeeting();
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        model.addAttribute("mode", (Object)"view");
        return COUNCILMEETING_ATTENDANCE_SEARCH;
    }

    @RequestMapping(value={"/attendance/report/search"}, method={RequestMethod.GET})
    public String getSearchReportForAttendance(Model model) {
        CouncilMeeting councilMeeting = new CouncilMeeting();
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        model.addAttribute("mode", (Object)"view");
        return COUNCILMEETING_ATTENDANCE_SEARCH;
    }

    @RequestMapping(value={"/attendance/search/view/{id}"}, method={RequestMethod.GET})
    public String viewAttendanceDetails(@PathVariable(value="id") CouncilMeeting councilMeeting, Model model) {
        model.addAttribute("id", (Object)councilMeeting.getId());
        model.addAttribute("currDate", (Object)new Date());
        return COUNCILMEETING_ATTENDANCE_VIEW;
    }

    @RequestMapping(value={"/attendance/result/{id}"}, method={RequestMethod.GET})
    public String showAttendanceResult(@PathVariable(value="id") CouncilMeeting councilMeeting, Model model) {
        model.addAttribute("id", (Object)councilMeeting.getId());
        model.addAttribute("currDate", (Object)new Date());
        return COUNCILMEETING_ATTENDANCE_RESULT;
    }

    @RequestMapping(value={"/attend/search/edit/{id}"}, method={RequestMethod.GET})
    public String editAttendance(@PathVariable(value="id") CouncilMeeting councilMeeting1, Model model) {
        CouncilMeeting councilMeeting = this.councilMeetingService.findOne(councilMeeting1.getId());
        if (councilMeeting != null && councilMeeting.getCommitteeType().getCommiteemembers().isEmpty()) {
            model.addAttribute(MESSAGE, (Object)"msg.committee.members.not.added");
            return COMMONERRORPAGE;
        }
        if (councilMeeting != null && councilMeeting.getStatus() != null && "ATTENDANCE FINALIZED".equals(councilMeeting.getStatus().getCode())) {
            model.addAttribute(MESSAGE, (Object)MSG_ATTENDANCE_ALREADY_FINALIZD);
            return COMMONERRORPAGE;
        }
        this.buildAttendanceDetails(councilMeeting);
        this.sortMeetingMomByItemNumber(councilMeeting);
        model.addAttribute(COUNCIL_MEETING, (Object)councilMeeting);
        return COUNCILMEETING_EDIT_ATTENDANCE;
    }

    private void buildAttendanceDetails(CouncilMeeting councilMeeting) {
        if (councilMeeting != null && councilMeeting.getCommitteeType() != null) {
            ArrayList<MeetingAttendence> attendencesList = new ArrayList<MeetingAttendence>();
            ArrayList<Long> attendenceIdList = new ArrayList<Long>();
            for (MeetingAttendence meetingAttendance : councilMeeting.getMeetingAttendence()) {
                if (!meetingAttendance.getAttendedMeeting().booleanValue()) continue;
                attendenceIdList.add(meetingAttendance.getCouncilMember().getId());
            }
            for (CommitteeMembers committeeMembers : this.committeeMemberService.findAllByCommitteTypeMemberIsActive(councilMeeting.getCommitteeType())) {
                MeetingAttendence attendence = new MeetingAttendence();
                attendence.setCouncilMember(committeeMembers.getCouncilMember());
                if (attendenceIdList.indexOf(committeeMembers.getCouncilMember().getId()) > -1) {
                    attendence.setAttendedMeeting(Boolean.valueOf(true));
                }
                attendencesList.add(attendence);
            }
            councilMeeting.setUpdateMeetingAttendance(attendencesList);
        }
    }

    @RequestMapping(value={"/attendance/update"}, method={RequestMethod.POST})
    public String updateAttendance(@Valid @ModelAttribute CouncilMeeting councilMeeting, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (councilMeeting != null && councilMeeting.getStatus() != null && "ATTENDANCE FINALIZED".equals(councilMeeting.getStatus().getCode())) {
            model.addAttribute(MESSAGE, (Object)MSG_ATTENDANCE_ALREADY_FINALIZD);
            return COMMONERRORPAGE;
        }
        this.deleteAtteandance(councilMeeting);
        this.setAttendanceDetails(councilMeeting);
        if (errors.hasErrors()) {
            return "redirect:councilmeeting/attend/search/edit/" + councilMeeting.getId();
        }
        this.buildAttendanceDetailsForMeeting(councilMeeting);
        this.councilMeetingService.update(councilMeeting);
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)this.messageSource.getMessage("msg.councilMeeting.attendance.success", null, null));
        return "redirect:result/" + councilMeeting.getId();
    }

    private void setAttendanceDetails(CouncilMeeting councilMeeting) {
        councilMeeting.setMeetingAttendence(councilMeeting.getUpdateMeetingAttendance());
    }

    private void deleteAtteandance(CouncilMeeting councilMeeting) {
        this.councilMeetingService.deleteAttendance(councilMeeting.getMeetingAttendence());
    }

    @RequestMapping(value={"/attendance/finalizeattendance"}, method={RequestMethod.POST})
    public String updateFinalizedAttendance(@Valid @ModelAttribute CouncilMeeting councilMeeting, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (councilMeeting != null && councilMeeting.getStatus() != null && "ATTENDANCE FINALIZED".equals(councilMeeting.getStatus().getCode())) {
            model.addAttribute(MESSAGE, (Object)MSG_ATTENDANCE_ALREADY_FINALIZD);
            return COMMONERRORPAGE;
        }
        this.deleteAtteandance(councilMeeting);
        if (councilMeeting != null && councilMeeting.getUpdateMeetingAttendance() != null) {
            this.setAttendanceDetails(councilMeeting);
        }
        if (errors.hasErrors()) {
            return "redirect:councilmeeting/attend/search/edit/" + councilMeeting.getId();
        }
        this.buildAttendanceDetailsForMeeting(councilMeeting);
        councilMeeting.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILMEETING", "ATTENDANCE FINALIZED"));
        this.councilMeetingService.update(councilMeeting);
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)this.messageSource.getMessage("msg.councilMeeting.attendance.success", null, null));
        return "redirect:result/" + councilMeeting.getId();
    }

    private void buildAttendanceDetailsForMeeting(CouncilMeeting councilMeeting) {
        for (MeetingAttendence attendence : councilMeeting.getMeetingAttendence()) {
            if (attendence.getChecked() != null && attendence.getChecked().booleanValue()) {
                attendence.setAttendedMeeting(Boolean.valueOf(true));
                continue;
            }
            attendence.setAttendedMeeting(Boolean.valueOf(false));
        }
    }

    @RequestMapping(value={"/downloadfile/{id}"})
    public void download(@PathVariable(value="id") Long id, HttpServletResponse response, HttpServletRequest request) throws IOException {
        CouncilMeeting councilMeeting = this.councilMeetingService.findOne(id);
        if (null != councilMeeting) {
            if (councilMeeting.getFilestore() != null) {
                this.fetchMeetingResolutionByFileStoreId(response, councilMeeting);
            } else if ("MOM FINALISED".equals(councilMeeting.getStatus().getCode())) {
                byte[] reportOutput = this.generatePdfByPassingMeetingObject(request, councilMeeting);
                if (reportOutput != null) {
                    councilMeeting.setFilestore(this.fileStoreService.store((InputStream)new ByteArrayInputStream(reportOutput), "MeetingResolution", APPLICATION_PDF, "COUNCIL"));
                    this.councilMeetingService.update(councilMeeting);
                }
                if (councilMeeting.getFilestore() != null) {
                    this.fetchMeetingResolutionByFileStoreId(response, councilMeeting);
                }
            }
        }
    }

    private byte[] generatePdfByPassingMeetingObject(HttpServletRequest request, CouncilMeeting councilMeeting) {
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        String logoPath = url.concat("/egi").concat((String)request.getSession().getAttribute(CITYLOGO));
        byte[] reportOutput = this.councilReportService.generatePDFForMom(councilMeeting, logoPath);
        return reportOutput;
    }

    private void fetchMeetingResolutionByFileStoreId(HttpServletResponse response, CouncilMeeting councilMeeting) throws IOException {
        this.fileStoreUtils.fetchFileAndWriteToStream(councilMeeting.getFilestore().getFileStoreId(), "COUNCIL", false, response);
    }

    @RequestMapping(value={"/attendance/ajaxsearch/{id}"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearc(@PathVariable(value="id") CouncilMeeting id, Model model) {
        List searchResultList = this.councilMeetingService.findListOfAttendance(id);
        return DATA + JsonUtils.toJSON((Collection)searchResultList, MeetingAttendence.class, MeetingAttendanceJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/generateagenda/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> printAgendaDetails(@PathVariable(value="id") Long id, Model model, HttpServletRequest request) {
        CouncilMeeting councilMeeting = this.councilMeetingService.findOne(id);
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        String logoPath = url.concat("/egi").concat((String)request.getSession().getAttribute(CITYLOGO));
        byte[] reportOutput = this.councilReportService.generatePDFForAgendaDetails(councilMeeting, logoPath);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)APPLICATION_PDF));
        headers.add("content-disposition", "inline;filename=AgendaNotice.pdf");
        return new ResponseEntity((Object)reportOutput, (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

