/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.commons.lang.StringEscapeUtils;
import org.egov.council.entity.CouncilPreamble;
import org.egov.council.entity.MeetingMOM;
import org.egov.infra.admin.master.entity.Boundary;

public class CouncilPreambleJsonAdaptor
implements JsonSerializer<CouncilPreamble> {
    public JsonElement serialize(CouncilPreamble councilPreamble, Type type, JsonSerializationContext jsc) {
        String meetingDate = "";
        String meetingType = "";
        JsonObject jsonObject = new JsonObject();
        StringBuilder bndryList = new StringBuilder();
        if (councilPreamble != null) {
            if (!councilPreamble.getWards().isEmpty()) {
                for (Boundary ward : councilPreamble.getWards()) {
                    bndryList.append(ward.getName());
                    bndryList.append(',');
                }
            }
            jsonObject.addProperty("ward", bndryList.toString());
            if (councilPreamble.getDepartment() != null) {
                jsonObject.addProperty("department", councilPreamble.getDepartment().getName());
            } else {
                jsonObject.addProperty("department", "");
            }
            if (councilPreamble.getType() != null) {
                jsonObject.addProperty("preambleType", councilPreamble.getType().toString());
            } else {
                jsonObject.addProperty("preambleType", "");
            }
            if (councilPreamble.getPreambleNumber() != null) {
                jsonObject.addProperty("preambleNumber", councilPreamble.getPreambleNumber());
            } else {
                jsonObject.addProperty("preambleNumber", "");
            }
            if (councilPreamble.getGistOfPreamble() != null) {
                jsonObject.addProperty("gistOfPreamble", StringEscapeUtils.escapeJava((String)councilPreamble.getGistOfPreamble().replaceAll("[\n\r]", "")));
            } else {
                jsonObject.addProperty("gistOfPreamble", "");
            }
            if (councilPreamble.getSanctionAmount() != null) {
                jsonObject.addProperty("sanctionAmount", (Number)councilPreamble.getSanctionAmount());
            } else {
                jsonObject.addProperty("sanctionAmount", "");
            }
            if (councilPreamble.getCreatedDate() != null) {
                jsonObject.addProperty("createdDate", councilPreamble.getCreatedDate().toString());
            } else {
                jsonObject.addProperty("createdDate", "");
            }
            if (councilPreamble.getStatus() != null) {
                jsonObject.addProperty("preambleUsedInAgenda", "PREAMBLE USED IN AGENDA".equals(councilPreamble.getStatus().getCode()) ? "Yes" : "No");
            } else {
                jsonObject.addProperty("preambleUsedInAgenda", "");
            }
            if (!councilPreamble.getMeetingMOMs().isEmpty()) {
                for (MeetingMOM meetingMOM : councilPreamble.getMeetingMOMs()) {
                    meetingDate = meetingMOM.getMeeting().getMeetingDate().toString();
                    meetingType = meetingMOM.getMeeting().getCommitteeType().getName();
                }
            }
            if (meetingDate != null) {
                jsonObject.addProperty("meetingDate", meetingDate);
            } else {
                jsonObject.addProperty("meetingDate", "");
            }
            if (meetingType != null) {
                jsonObject.addProperty("meetingType", meetingType);
            } else {
                jsonObject.addProperty("meetingType", "");
            }
            if (councilPreamble.getImplementationStatus() != null) {
                jsonObject.addProperty("implementationStatus", councilPreamble.getImplementationStatus().getCode());
            } else {
                jsonObject.addProperty("implementationStatus", "");
            }
            if (councilPreamble.getStatus() != null) {
                jsonObject.addProperty("status", councilPreamble.getStatus().getCode());
            } else {
                jsonObject.addProperty("status", "");
            }
            jsonObject.addProperty("id", (Number)councilPreamble.getId());
        }
        return jsonObject;
    }
}

