/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.log4j.Logger;
import org.egov.council.entity.CouncilMember;
import org.egov.council.entity.CouncilMemberStatus;
import org.egov.council.service.CouncilCasteService;
import org.egov.council.service.CouncilDesignationService;
import org.egov.council.service.CouncilMemberService;
import org.egov.council.service.CouncilPartyService;
import org.egov.council.service.CouncilQualificationService;
import org.egov.council.web.adaptor.CouncilMemberJsonAdaptor;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.FileStoreUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/councilmember"})
public class CouncilMemberController {
    private static final String COUNCILMEMBER_NEW = "councilmember-new";
    private static final String COUNCILMEMBER_RESULT = "councilmember-result";
    private static final String COUNCILMEMBER_EDIT = "councilmember-edit";
    private static final String COUNCILMEMBER_VIEW = "councilmember-view";
    private static final String COUNCILMEMBER_SEARCH = "councilmember-search";
    private static final String MODULE_NAME = "COUNCIL";
    @Autowired
    private CouncilMemberService councilMemberService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private CouncilDesignationService councilDesignationService;
    @Autowired
    private CouncilQualificationService councilQualificationService;
    @Autowired
    private CouncilCasteService councilCasteService;
    @Autowired
    private CouncilPartyService councilPartyService;
    @Qualifier(value="fileStoreService")
    @Autowired
    protected FileStoreService fileStoreService;
    @Autowired
    protected FileStoreUtils fileStoreUtils;
    private static final Logger LOGGER = Logger.getLogger(CouncilMemberController.class);

    private void prepareNewForm(Model model) {
        model.addAttribute("boundarys", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "ADMINISTRATION"));
        model.addAttribute("councilDesignations", (Object)this.councilDesignationService.getActiveDesignations());
        model.addAttribute("councilQualifications", (Object)this.councilQualificationService.getActiveQualifications());
        model.addAttribute("councilCastes", (Object)this.councilCasteService.getActiveCastes());
        model.addAttribute("councilPartys", (Object)this.councilPartyService.getActiveParties());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("councilMember", (Object)new CouncilMember());
        return COUNCILMEMBER_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute CouncilMember councilMember, BindingResult errors, @RequestParam MultipartFile attachments, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return COUNCILMEMBER_NEW;
        }
        if (councilMember != null && councilMember.getStatus() == null) {
            councilMember.setStatus(CouncilMemberStatus.ACTIVE);
        }
        if (attachments.getSize() > 0L) {
            try {
                councilMember.setPhoto(this.fileStoreService.store(attachments.getInputStream(), attachments.getOriginalFilename(), attachments.getContentType(), MODULE_NAME));
            }
            catch (IOException e) {
                LOGGER.error((Object)("Error in loading Employee photo" + e.getMessage()), (Throwable)e);
            }
        }
        this.councilMemberService.create(councilMember);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.councilMember.success", null, null));
        return "redirect:/councilmember/result/" + councilMember.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model, HttpServletResponse response) throws IOException {
        CouncilMember councilMember = this.councilMemberService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("councilMember", (Object)councilMember);
        return COUNCILMEMBER_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute CouncilMember councilMember, @RequestParam MultipartFile attachments, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return COUNCILMEMBER_EDIT;
        }
        if (attachments.getSize() > 0L) {
            try {
                councilMember.setPhoto(this.fileStoreService.store(attachments.getInputStream(), attachments.getOriginalFilename(), attachments.getContentType(), MODULE_NAME));
            }
            catch (IOException e) {
                LOGGER.error((Object)("Error in loading Employee photo" + e.getMessage()), (Throwable)e);
            }
        }
        this.councilMemberService.update(councilMember);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.councilMember.success", null, null));
        return "redirect:/councilmember/result/" + councilMember.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        CouncilMember councilMember = this.councilMemberService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("councilMember", (Object)councilMember);
        return COUNCILMEMBER_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        CouncilMember councilMember = this.councilMemberService.findOne(id);
        model.addAttribute("councilMember", (Object)councilMember);
        return COUNCILMEMBER_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        CouncilMember councilMember = new CouncilMember();
        this.prepareNewForm(model);
        model.addAttribute("councilMember", (Object)councilMember);
        return COUNCILMEMBER_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute CouncilMember councilMember) {
        List searchResultList = this.councilMemberService.search(councilMember);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    @RequestMapping(value={"/downloadfile/{fileStoreId}"})
    public void download(@PathVariable String fileStoreId, HttpServletResponse response) throws IOException {
        this.fileStoreUtils.fetchFileAndWriteToStream(fileStoreId, MODULE_NAME, false, response);
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(CouncilMember.class, (Object)new CouncilMemberJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

