/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.RandomStringUtils;
import org.egov.council.entity.CouncilQualification;
import org.egov.council.service.CouncilQualificationService;
import org.egov.council.web.adaptor.CouncilQualificationJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/councilqualification"})
public class CouncilQualificationController {
    private static final String COUNCILQUALIFICATION_NEW = "councilqualification-new";
    private static final String COUNCILQUALIFICATION_RESULT = "councilqualification-result";
    private static final String COUNCILQUALIFICATION_EDIT = "councilqualification-edit";
    private static final String COUNCILQUALIFICATION_VIEW = "councilqualification-view";
    private static final String COUNCILQUALIFICATION_SEARCH = "councilqualification-search";
    @Autowired
    private CouncilQualificationService councilQualificationService;
    @Autowired
    private MessageSource messageSource;

    private void prepareNewForm(Model model) {
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        CouncilQualification councilQualification = new CouncilQualification();
        if (councilQualification != null && councilQualification.getCode() == null) {
            councilQualification.setCode(RandomStringUtils.random((int)4, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE).toUpperCase());
        }
        model.addAttribute("councilQualification", (Object)councilQualification);
        return COUNCILQUALIFICATION_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute CouncilQualification councilQualification, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (councilQualification != null && councilQualification.getCode() == null) {
            councilQualification.setCode(RandomStringUtils.random((int)4, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE).toUpperCase());
        }
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return COUNCILQUALIFICATION_NEW;
        }
        this.councilQualificationService.create(councilQualification);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.councilQualification.success", null, null));
        return "redirect:/councilqualification/result/" + councilQualification.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        CouncilQualification councilQualification = this.councilQualificationService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("councilQualification", (Object)councilQualification);
        return COUNCILQUALIFICATION_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute CouncilQualification councilQualification, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return COUNCILQUALIFICATION_EDIT;
        }
        this.councilQualificationService.update(councilQualification);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.councilQualification.success", null, null));
        return "redirect:/councilqualification/result/" + councilQualification.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        CouncilQualification councilQualification = this.councilQualificationService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("councilQualification", (Object)councilQualification);
        return COUNCILQUALIFICATION_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        CouncilQualification councilQualification = this.councilQualificationService.findOne(id);
        model.addAttribute("councilQualification", (Object)councilQualification);
        return COUNCILQUALIFICATION_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        CouncilQualification councilQualification = new CouncilQualification();
        this.prepareNewForm(model);
        model.addAttribute("councilQualification", (Object)councilQualification);
        return COUNCILQUALIFICATION_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute CouncilQualification councilQualification) {
        List searchResultList = this.councilQualificationService.search(councilQualification);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(CouncilQualification.class, (Object)new CouncilQualificationJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

