/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.RandomStringUtils;
import org.egov.council.entity.CouncilParty;
import org.egov.council.service.CouncilPartyService;
import org.egov.council.web.adaptor.CouncilPartyJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/councilparty"})
public class CouncilPartyController {
    private static final String COUNCILPARTY_NEW = "councilparty-new";
    private static final String COUNCILPARTY_RESULT = "councilparty-result";
    private static final String COUNCILPARTY_EDIT = "councilparty-edit";
    private static final String COUNCILPARTY_VIEW = "councilparty-view";
    private static final String COUNCILPARTY_SEARCH = "councilparty-search";
    @Autowired
    private CouncilPartyService councilPartyService;
    @Autowired
    private MessageSource messageSource;

    private void prepareNewForm(Model model) {
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        CouncilParty councilParty = new CouncilParty();
        if (councilParty != null && councilParty.getCode() == null) {
            councilParty.setCode(RandomStringUtils.random((int)4, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE).toUpperCase());
        }
        model.addAttribute("councilParty", (Object)councilParty);
        return COUNCILPARTY_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute CouncilParty councilParty, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (councilParty != null && councilParty.getCode() == null) {
            councilParty.setCode(RandomStringUtils.random((int)4, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE).toUpperCase());
        }
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return COUNCILPARTY_NEW;
        }
        this.councilPartyService.create(councilParty);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.councilParty.success", null, null));
        return "redirect:/councilparty/result/" + councilParty.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        CouncilParty councilParty = this.councilPartyService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("councilParty", (Object)councilParty);
        return COUNCILPARTY_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute CouncilParty councilParty, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return COUNCILPARTY_EDIT;
        }
        this.councilPartyService.update(councilParty);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.councilParty.success", null, null));
        return "redirect:/councilparty/result/" + councilParty.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        CouncilParty councilParty = this.councilPartyService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("councilParty", (Object)councilParty);
        return COUNCILPARTY_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        CouncilParty councilParty = this.councilPartyService.findOne(id);
        model.addAttribute("councilParty", (Object)councilParty);
        return COUNCILPARTY_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        CouncilParty councilParty = new CouncilParty();
        this.prepareNewForm(model);
        model.addAttribute("councilParty", (Object)councilParty);
        return COUNCILPARTY_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute CouncilParty councilParty) {
        List searchResultList = this.councilPartyService.search(councilParty);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(CouncilParty.class, (Object)new CouncilPartyJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

