/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.RandomStringUtils;
import org.egov.council.entity.CouncilDesignation;
import org.egov.council.service.CouncilDesignationService;
import org.egov.council.web.adaptor.CouncilDesignationJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/councildesignation"})
public class CouncilDesignationController {
    private static final String COUNCILDESIGNATION_NEW = "councildesignation-new";
    private static final String COUNCILDESIGNATION_RESULT = "councildesignation-result";
    private static final String COUNCILDESIGNATION_EDIT = "councildesignation-edit";
    private static final String COUNCILDESIGNATION_VIEW = "councildesignation-view";
    private static final String COUNCILDESIGNATION_SEARCH = "councildesignation-search";
    @Autowired
    private CouncilDesignationService councilDesignationService;
    @Autowired
    private MessageSource messageSource;

    private void prepareNewForm(Model model) {
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        CouncilDesignation councilDesignation = new CouncilDesignation();
        if (councilDesignation != null && councilDesignation.getCode() == null) {
            councilDesignation.setCode(RandomStringUtils.random((int)4, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE).toUpperCase());
        }
        model.addAttribute("councilDesignation", (Object)councilDesignation);
        return COUNCILDESIGNATION_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute CouncilDesignation councilDesignation, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (councilDesignation != null && councilDesignation.getCode() == null) {
            councilDesignation.setCode(RandomStringUtils.random((int)4, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE).toUpperCase());
        }
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return COUNCILDESIGNATION_NEW;
        }
        this.councilDesignationService.create(councilDesignation);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.councilDesignation.success", null, null));
        return "redirect:/councildesignation/result/" + councilDesignation.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        CouncilDesignation councilDesignation = this.councilDesignationService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("councilDesignation", (Object)councilDesignation);
        return COUNCILDESIGNATION_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute CouncilDesignation councilDesignation, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return COUNCILDESIGNATION_EDIT;
        }
        this.councilDesignationService.update(councilDesignation);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.councilDesignation.success", null, null));
        return "redirect:/councildesignation/result/" + councilDesignation.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        CouncilDesignation councilDesignation = this.councilDesignationService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("councilDesignation", (Object)councilDesignation);
        return COUNCILDESIGNATION_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        CouncilDesignation councilDesignation = this.councilDesignationService.findOne(id);
        model.addAttribute("councilDesignation", (Object)councilDesignation);
        return COUNCILDESIGNATION_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        CouncilDesignation councilDesignation = new CouncilDesignation();
        this.prepareNewForm(model);
        model.addAttribute("councilDesignation", (Object)councilDesignation);
        return COUNCILDESIGNATION_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute CouncilDesignation councilDesignation) {
        List searchResultList = this.councilDesignationService.search(councilDesignation);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(CouncilDesignation.class, (Object)new CouncilDesignationJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

