/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service.es;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.egov.council.entity.CouncilMeeting;
import org.egov.council.entity.MeetingAttendence;
import org.egov.council.entity.MeetingMOM;
import org.egov.council.entity.es.CouncilMeetingDetailsSearchRequest;
import org.egov.council.entity.es.CouncilMeetingIndex;
import org.egov.council.repository.es.CouncilMeetingIndexRepository;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CouncilMeetingIndexService {
    private static final String COUNCILMEETING = "councilmeeting";
    private static final String MEETING_NUMBER = "meetingNumber";
    private static final String COMMITTEE_TYPE = "committeeType";
    private static final String APPLICATION_COUNT = "application_count";
    @Autowired
    private CityService cityService;
    @Autowired
    private CouncilMeetingIndexRepository councilMeetingIndexRepository;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public CouncilMeetingIndex createCouncilMeetingIndex(CouncilMeeting councilMeeting) throws ParseException {
        int noOfMembersPresent = 0;
        int noOfMembersAbsent = 0;
        int noOfPreamblesApproved = 0;
        int noOfPreamblesPostponed = 0;
        int noOfPreamblesRejected = 0;
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        CouncilMeetingIndex meetingIndex = new CouncilMeetingIndex();
        meetingIndex.setDistrictName(cityWebsite.getDistrictName());
        meetingIndex.setUlbGrade(cityWebsite.getGrade());
        meetingIndex.setUlbCode(cityWebsite.getCode());
        meetingIndex.setRegionName(cityWebsite.getRegionName());
        meetingIndex.setUlbName(cityWebsite.getName());
        SimpleDateFormat dateFormat = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
        if (councilMeeting != null) {
            meetingIndex.setId(cityWebsite.getCode().concat("-").concat(councilMeeting.getMeetingNumber()));
            meetingIndex.setCommitteeType(councilMeeting.getCommitteeType().getName() != null ? councilMeeting.getCommitteeType().getName() : "");
            String meetingDate = dateFormat.format(councilMeeting.getMeetingDate());
            meetingIndex.setMeetingDate(dateFormat.parse(meetingDate));
            meetingIndex.setCreatedDate(councilMeeting.getCreatedDate());
            meetingIndex.setMeetingLocation(councilMeeting.getMeetingLocation() != null ? councilMeeting.getMeetingLocation() : "");
            meetingIndex.setMeetingNumber(councilMeeting.getMeetingNumber() != null ? councilMeeting.getMeetingNumber() : "");
            meetingIndex.setMeetingTime(councilMeeting.getMeetingTime() != null ? councilMeeting.getMeetingTime() : "");
            meetingIndex.setStatus(councilMeeting.getStatus() != null ? councilMeeting.getStatus().getCode() : "");
            meetingIndex.setTotalNoOfCommitteMembers(councilMeeting != null && councilMeeting.getMeetingAttendence() != null ? councilMeeting.getMeetingAttendence().size() : 0);
            if (councilMeeting.getMeetingAttendence() != null) {
                for (MeetingAttendence attendence : councilMeeting.getMeetingAttendence()) {
                    if (attendence.getAttendedMeeting().booleanValue()) {
                        ++noOfMembersPresent;
                        continue;
                    }
                    ++noOfMembersAbsent;
                }
            }
            meetingIndex.setNoOfCommitteMembersPresent(noOfMembersPresent);
            meetingIndex.setNoOfCommitteMembersAbsent(noOfMembersAbsent);
            if (!councilMeeting.getMeetingMOMs().isEmpty()) {
                for (MeetingMOM mom : councilMeeting.getMeetingMOMs()) {
                    if ("APPROVED".equals(mom.getResolutionStatus().getCode())) {
                        ++noOfPreamblesApproved;
                        continue;
                    }
                    if ("ADJOURNED".equals(mom.getResolutionStatus().getCode())) {
                        ++noOfPreamblesPostponed;
                        continue;
                    }
                    if (!"REJECTED".equals(mom.getResolutionStatus().getCode())) continue;
                    ++noOfPreamblesRejected;
                }
            }
            meetingIndex.setTotalNoOfPreamblesUsed(councilMeeting.getMeetingMOMs().size());
            meetingIndex.setNoOfPreamblesApproved(noOfPreamblesApproved);
            meetingIndex.setNoOfPreamblesPostponed(noOfPreamblesPostponed);
            meetingIndex.setNoOfPreamblesRejected(noOfPreamblesRejected);
        }
        this.councilMeetingIndexRepository.save(meetingIndex);
        return meetingIndex;
    }

    public List<CouncilMeetingIndex> getQueryFilterForMeetingDetails(CouncilMeetingDetailsSearchRequest searchRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (searchRequest.getFrom() != null && searchRequest.getTo() != null) {
            boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"meetingDate").from((Object)searchRequest.getFrom()).to((Object)searchRequest.getTo()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getCommitteeType())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)COMMITTEE_TYPE, (Object)searchRequest.getCommitteeType()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getMeetingNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)MEETING_NUMBER, (Object)searchRequest.getMeetingNumber()));
        }
        FieldSortBuilder sort = new FieldSortBuilder(COMMITTEE_TYPE).order(SortOrder.DESC);
        return this.getSearchResultByBoolQuery(boolQuery, sort);
    }

    public List<CouncilMeetingIndex> getSearchResultByBoolQuery(BoolQueryBuilder boolQuery, FieldSortBuilder sort) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().addAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)APPLICATION_COUNT).field(MEETING_NUMBER)).withIndices(new String[]{COUNCILMEETING}).withQuery((QueryBuilder)boolQuery).build();
        Aggregations applicationCountAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, SearchResponse::getAggregations);
        ValueCount aggr = (ValueCount)applicationCountAggr.get(APPLICATION_COUNT);
        searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{COUNCILMEETING}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)APPLICATION_COUNT).field(MEETING_NUMBER)).withSort((SortBuilder)sort).withPageable((Pageable)new PageRequest(0, Math.toIntExact(aggr.getValue() == 0L ? 1L : aggr.getValue()))).build();
        return this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, CouncilMeetingIndex.class);
    }

    public BoolQueryBuilder prepareWhereClause(CouncilMeetingDetailsSearchRequest searchRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"ulbName", (Object)searchRequest.getUlbName()));
        if (searchRequest.getFrom() != null && searchRequest.getTo() != null) {
            boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"meetingDate").from((Object)searchRequest.getFrom()).to((Object)searchRequest.getTo()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getCommitteeType())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)COMMITTEE_TYPE, (Object)searchRequest.getCommitteeType()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getMeetingNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)MEETING_NUMBER, (Object)searchRequest.getMeetingNumber()));
        }
        return boolQuery;
    }
}

