/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.egov.council.entity.CouncilPreamble;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CouncilThirdPartyService {
    private static final String DEPARTMENT = "department";
    @Autowired
    private EisCommonService eisCommonService;

    public List<HashMap<String, Object>> getHistory(CouncilPreamble councilPreamble) {
        ArrayList<HashMap<String, Object>> historyTable = new ArrayList<HashMap<String, Object>>();
        State workflowState = councilPreamble.getState();
        HashMap<String, Object> workFlowHistory = new HashMap<String, Object>();
        if (null != workflowState) {
            User userObject;
            if (null != councilPreamble.getStateHistory() && !councilPreamble.getStateHistory().isEmpty()) {
                Collections.reverse(councilPreamble.getStateHistory());
            }
            for (StateHistory stateHistory : councilPreamble.getStateHistory()) {
                HashMap<String, Object> historyMap = new HashMap<String, Object>();
                historyMap.put("date", stateHistory.getDateInfo());
                historyMap.put("comments", stateHistory.getComments());
                historyMap.put("updatedBy", stateHistory.getLastModifiedBy().getUsername() + "::" + stateHistory.getLastModifiedBy().getName());
                historyMap.put("status", stateHistory.getValue());
                Position owner = (Position)stateHistory.getOwnerPosition();
                userObject = stateHistory.getOwnerUser();
                if (null != userObject) {
                    historyMap.put("user", userObject.getUsername() + "::" + userObject.getName());
                    historyMap.put(DEPARTMENT, null != this.eisCommonService.getDepartmentForUser(userObject.getId()) ? this.eisCommonService.getDepartmentForUser(userObject.getId()).getName() : "");
                } else if (null != owner && null != owner.getDeptDesig()) {
                    userObject = this.eisCommonService.getUserForPosition(owner.getId(), new Date());
                    historyMap.put("user", null != userObject.getUsername() ? userObject.getUsername() + "::" + userObject.getName() : "");
                    historyMap.put(DEPARTMENT, null != owner.getDeptDesig().getDepartment() ? owner.getDeptDesig().getDepartment().getName() : "");
                }
                historyTable.add(historyMap);
            }
            workFlowHistory.put("date", workflowState.getDateInfo());
            workFlowHistory.put("comments", workflowState.getComments() != null ? workflowState.getComments() : "");
            workFlowHistory.put("updatedBy", workflowState.getLastModifiedBy().getUsername() + "::" + workflowState.getLastModifiedBy().getName());
            workFlowHistory.put("status", workflowState.getValue());
            Position ownerPosition = (Position)workflowState.getOwnerPosition();
            userObject = workflowState.getOwnerUser();
            if (null != userObject) {
                workFlowHistory.put("user", userObject.getUsername() + "::" + userObject.getName());
                workFlowHistory.put(DEPARTMENT, null != this.eisCommonService.getDepartmentForUser(userObject.getId()) ? this.eisCommonService.getDepartmentForUser(userObject.getId()).getName() : "");
            } else if (null != ownerPosition && null != ownerPosition.getDeptDesig()) {
                userObject = this.eisCommonService.getUserForPosition(ownerPosition.getId(), new Date());
                workFlowHistory.put("user", null != userObject.getUsername() ? userObject.getUsername() + "::" + userObject.getName() : "");
                workFlowHistory.put(DEPARTMENT, null != ownerPosition.getDeptDesig().getDepartment() ? ownerPosition.getDeptDesig().getDepartment().getName() : "");
            }
            historyTable.add(workFlowHistory);
        }
        return historyTable;
    }
}

