/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.egov.council.entity.CommitteeMembers;
import org.egov.council.entity.CouncilMeeting;
import org.egov.council.entity.CouncilSmsDetails;
import org.egov.council.service.CouncilCommitteeMemberService;
import org.egov.council.service.CouncilMeetingService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.notification.service.NotificationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class CouncilSmsAndEmailService {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String AGENDAATTACHFILENAME = "agendadetails.rtf";
    @Autowired
    private NotificationService notificationService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource councilMessageSource;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private CouncilCommitteeMemberService committeeMemberService;
    @Autowired
    private CouncilMeetingService councilMeetingService;

    public void sendSms(CouncilMeeting councilMeeting, String customMessage) {
        Boolean smsEnabled = this.isSmsEnabled();
        if (smsEnabled.booleanValue()) {
            for (CommitteeMembers committeeMembers : this.committeeMemberService.findAllByCommitteTypeMemberIsActive(councilMeeting.getCommitteeType())) {
                String mobileNo = committeeMembers.getCouncilMember().getMobileNumber();
                if (mobileNo == null) continue;
                this.buildSmsForMeeting(mobileNo, councilMeeting.getCommitteeType().getName(), councilMeeting, customMessage);
            }
            List<User> listOfUsers = this.councilMeetingService.getUserListForMeeting(councilMeeting);
            for (User user : listOfUsers) {
                if (user.getMobileNumber() == null) continue;
                this.buildSmsForMeetingCouncilRoles(user.getUsername(), user.getMobileNumber(), councilMeeting, customMessage);
            }
            this.buildCouncilSmsDetails(customMessage, councilMeeting);
        }
    }

    public void sendEmail(CouncilMeeting councilMeeting, String customMessage, byte[] attachment) {
        Boolean emailEnabled = this.isEmailEnabled();
        if (emailEnabled.booleanValue()) {
            for (CommitteeMembers committeeMembers : this.committeeMemberService.findAllByCommitteTypeMemberIsActive(councilMeeting.getCommitteeType())) {
                String emailId = committeeMembers.getCouncilMember().getEmailId();
                if (emailId == null) continue;
                this.buildEmailForMeeting(emailId, councilMeeting.getCommitteeType().getName(), councilMeeting, customMessage, attachment);
            }
            List<User> listOfUsers = this.councilMeetingService.getUserListForMeeting(councilMeeting);
            for (User user : listOfUsers) {
                if (user.getEmailId() == null) continue;
                this.buildEmailForMeetingForCouncilRoles(user.getUsername(), user.getEmailId(), councilMeeting, customMessage, attachment);
            }
        }
    }

    private CouncilSmsDetails buildCouncilSmsDetails(String message, CouncilMeeting councilMeeting) {
        CouncilSmsDetails councilSmsDetails = new CouncilSmsDetails();
        councilSmsDetails.setSmsSentDate(new Date());
        councilSmsDetails.setSmsContent(message);
        councilSmsDetails.setMeeting(councilMeeting);
        councilMeeting.addSmsDetails(councilSmsDetails);
        return councilSmsDetails;
    }

    public void buildSmsForMeeting(String mobileNumber, String name, CouncilMeeting councilMeeting, String customMessage) {
        String smsMsg = "MOM FINALISED".equals(councilMeeting.getStatus().getCode()) ? this.smsBodyByCodeAndArgsWithType("msg.resolution.sms", name, councilMeeting, customMessage) : this.smsBodyByCodeAndArgsWithType("msg.meeting.sms", name, councilMeeting, customMessage);
        if (mobileNumber != null && smsMsg != null) {
            this.sendSMSOnSewerageForMeeting(mobileNumber, smsMsg);
        }
    }

    public void buildEmailForMeeting(String email, String name, CouncilMeeting councilMeeting, String customMessage, byte[] attachment) {
        String subject;
        String body;
        if ("MOM FINALISED".equals(councilMeeting.getStatus().getCode())) {
            body = this.emailBodyByCodeAndArgsWithType("email.resolution.body", name, councilMeeting, customMessage);
            subject = this.emailSubjectforEmailByCodeAndArgs("email.resolution.subject", name, councilMeeting);
        } else {
            body = this.emailBodyByCodeAndArgsWithType("email.meeting.body", name, councilMeeting, customMessage);
            subject = this.emailSubjectforEmailByCodeAndArgs("email.meeting.subject", name, councilMeeting);
        }
        if (email != null && body != null) {
            this.sendEmailOnSewerageForMeetingWithAttachment(email, body, subject, attachment);
        }
    }

    public void buildSmsForMeetingCouncilRoles(String userName, String mobileNumber, CouncilMeeting councilMeeting, String customMessage) {
        String smsMsg = "MOM FINALISED".equals(councilMeeting.getStatus().getCode()) ? this.smsBodyByCodeAndArgsWithType("msg.council.roles.resolution.sms", userName, councilMeeting, customMessage) : this.smsBodyByCodeAndArgsWithType("msg.council.roles.meeting.sms", userName, councilMeeting, customMessage);
        if (mobileNumber != null && smsMsg != null) {
            this.sendSMSOnSewerageForMeeting(mobileNumber, smsMsg);
        }
    }

    public void buildEmailForMeetingForCouncilRoles(String userName, String email, CouncilMeeting councilMeeting, String customMessage, byte[] attachment) {
        String body;
        String subject;
        if ("MOM FINALISED".equals(councilMeeting.getStatus().getCode())) {
            subject = this.emailSubjectforEmailByCodeAndArgs("email.council.roles.resolution.subject", userName, councilMeeting);
            body = this.emailBodyByCodeAndArgsWithType("email.council.roles.resolution.body", userName, councilMeeting, customMessage);
        } else {
            subject = this.emailSubjectforEmailByCodeAndArgs("email.council.roles.meeting.subject", userName, councilMeeting);
            body = this.emailBodyByCodeAndArgsWithType("email.council.roles.meeting.body", userName, councilMeeting, customMessage);
        }
        if (email != null && body != null) {
            this.sendEmailOnSewerageForMeetingWithAttachment(email, body, subject, attachment);
        }
    }

    public String emailBodyByCodeAndArgsWithType(String code, String name, CouncilMeeting councilMeeting, String customMessage) {
        SimpleDateFormat sf = new SimpleDateFormat(DATE_FORMAT);
        return this.councilMessageSource.getMessage(code, (Object[])new String[]{name, sf.format(councilMeeting.getMeetingDate()), String.valueOf(councilMeeting.getMeetingTime()), String.valueOf(councilMeeting.getMeetingLocation()), customMessage != null ? customMessage : " "}, LocaleContextHolder.getLocale());
    }

    public String smsBodyByCodeAndArgsWithType(String code, String name, CouncilMeeting councilMeeting, String customMessage) {
        SimpleDateFormat sf = new SimpleDateFormat(DATE_FORMAT);
        return this.councilMessageSource.getMessage(code, (Object[])new String[]{name, sf.format(councilMeeting.getMeetingDate()), String.valueOf(councilMeeting.getMeetingTime()), String.valueOf(councilMeeting.getMeetingLocation()), customMessage != null ? customMessage : " "}, LocaleContextHolder.getLocale());
    }

    public Boolean isSmsEnabled() {
        return this.getAppConfigValueByPassingModuleAndType("Council Management", "SENDSMSFORCOUNCILMEMBER");
    }

    private Boolean getAppConfigValueByPassingModuleAndType(String moduleName, String sendsmsoremail) {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, sendsmsoremail);
        return "YES".equalsIgnoreCase(appConfigValue != null && !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : "NO");
    }

    public Boolean isEmailEnabled() {
        return this.getAppConfigValueByPassingModuleAndType("Council Management", "SENDEMAILFORCOUNCILMEMBER");
    }

    public String emailSubjectforEmailByCodeAndArgs(String code, String name, CouncilMeeting councilMeeting) {
        SimpleDateFormat sf = new SimpleDateFormat(DATE_FORMAT);
        return this.councilMessageSource.getMessage(code, (Object[])new String[]{name, sf.format(councilMeeting.getMeetingDate()), String.valueOf(councilMeeting.getMeetingTime()), String.valueOf(councilMeeting.getMeetingLocation())}, LocaleContextHolder.getLocale());
    }

    public void sendSMSOnSewerageForMeeting(String mobileNumber, String smsBody) {
        this.notificationService.sendSMS(mobileNumber, smsBody);
    }

    public void sendEmailOnSewerageForMeetingWithAttachment(String email, String emailBody, String emailSubject, byte[] attachment) {
        this.notificationService.sendEmailWithAttachment(email, emailSubject, emailBody, "application/rtf", AGENDAATTACHFILENAME, attachment);
    }
}

