/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service;

import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.egov.council.entity.CouncilSequenceNumber;
import org.egov.council.repository.CouncilSequenceNumberRepository;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.Errors;

@Service
@Transactional(readOnly=true)
public class CouncilSequenceGenerationService {
    @Autowired
    private CouncilSequenceNumberRepository councilSequenceNumberRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public CouncilSequenceNumber create(CouncilSequenceNumber CouncilSequenceNumber2) {
        this.councilSequenceNumberRepository.save(CouncilSequenceNumber2);
        return CouncilSequenceNumber2;
    }

    @Transactional
    public void update(String sequenceName, String seqnumber) throws SQLException {
        int seqnum = Integer.parseInt(seqnumber) + 1;
        String sql = "alter sequence " + sequenceName + " restart " + seqnum;
        SQLQuery query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(sql);
        query.executeUpdate();
    }

    @Transactional
    public void updatesequences(CouncilSequenceNumber councilSequenceNumber) throws SQLException {
        String preamblesequence = "seq_egcncl_preamble_number";
        String agendasequence = "seq_egcncl_agenda_number";
        String resolutionsequence = "seq_egcncl_mom_number";
        if (councilSequenceNumber.getPreambleSeqNumber() != null) {
            this.update(preamblesequence, councilSequenceNumber.getPreambleSeqNumber());
        }
        if (councilSequenceNumber.getAgendaSeqNumber() != null) {
            this.update(agendasequence, councilSequenceNumber.getAgendaSeqNumber());
        }
        if (councilSequenceNumber.getResolutionSeqNumber() != null) {
            this.update(resolutionsequence, councilSequenceNumber.getResolutionSeqNumber());
        }
    }

    @Transactional
    public String getPreambleLastSeq() {
        String sql = "select last_value from seq_egcncl_preamble_number ";
        Query query = this.entityManager.createNativeQuery(sql);
        return query.getSingleResult() != null ? query.getSingleResult().toString() : "";
    }

    @Transactional
    public String getAgendaLastSeq() {
        String sql = "select last_value from seq_egcncl_agenda_number";
        Query query = this.entityManager.createNativeQuery(sql);
        return query.getSingleResult() != null ? query.getSingleResult().toString() : "";
    }

    @Transactional
    public String getresolutionsequence() {
        String sql = "select last_value from seq_egcncl_mom_number";
        Query query = this.entityManager.createNativeQuery(sql);
        return query.getSingleResult() != null ? query.getSingleResult().toString() : "";
    }

    public void validate(Errors error, CouncilSequenceNumber councilSequenceNumber, String preambleseq, String resolutionseq, String agendaSeq) {
        if (councilSequenceNumber.getPreambleSeqNumber() != null && Integer.valueOf(councilSequenceNumber.getPreambleSeqNumber()).compareTo(Integer.valueOf(preambleseq)) <= 0) {
            error.rejectValue("preambleSeqNumber", "err.preamble.sequence");
        }
        if (councilSequenceNumber.getAgendaSeqNumber() != null && Integer.valueOf(councilSequenceNumber.getAgendaSeqNumber()).compareTo(Integer.valueOf(agendaSeq)) <= 0) {
            error.rejectValue("agendaSeqNumber", "err.agenda.sequence");
        }
        if (councilSequenceNumber.getResolutionSeqNumber() != null && Integer.valueOf(councilSequenceNumber.getResolutionSeqNumber()).compareTo(Integer.valueOf(resolutionseq)) <= 0) {
            error.rejectValue("resolutionSeqNumber", "err.resolution.sequence");
        }
    }
}

