/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.EgwStatus;
import org.egov.council.autonumber.SumotoNumberGenerator;
import org.egov.council.entity.CouncilPreamble;
import org.egov.council.entity.MeetingMOM;
import org.egov.council.entity.enums.PreambleType;
import org.egov.council.repository.CouncilPreambleRepository;
import org.egov.council.service.workflow.PreambleWorkflowCustomImpl;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CouncilPreambleService {
    private static final String STATUS_CODE = "status.code";
    private final CouncilPreambleRepository councilPreambleRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PreambleWorkflowCustomImpl preambleWorkflowCustomImpl;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    protected AutonumberServiceBeanResolver autonumberServiceBeanResolver;

    @Autowired
    public CouncilPreambleService(CouncilPreambleRepository councilPreambleRepository) {
        this.councilPreambleRepository = councilPreambleRepository;
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public CouncilPreamble create(CouncilPreamble councilPreamble, Long approvalPosition, String approvalComment, String workFlowAction) {
        if (approvalPosition != null && approvalPosition > 0L && StringUtils.isNotEmpty((String)workFlowAction)) {
            this.preambleWorkflowCustomImpl.createCommonWorkflowTransition(councilPreamble, approvalPosition, approvalComment, workFlowAction);
        }
        this.councilPreambleRepository.save((Object)councilPreamble);
        return councilPreamble;
    }

    @Transactional
    public CouncilPreamble update(CouncilPreamble councilPreamble, Long approvalPosition, String approvalComment, String workFlowAction) {
        if (approvalPosition != null && StringUtils.isNotEmpty((String)workFlowAction)) {
            this.preambleWorkflowCustomImpl.createCommonWorkflowTransition(councilPreamble, approvalPosition, approvalComment, workFlowAction);
        }
        this.councilPreambleRepository.save((Object)councilPreamble);
        return councilPreamble;
    }

    @Transactional
    public CouncilPreamble updateImplementationStatus(CouncilPreamble councilPreamble) {
        this.councilPreambleRepository.save((Object)councilPreamble);
        return councilPreamble;
    }

    public CouncilPreamble findOne(Long id) {
        return this.councilPreambleRepository.findById(id);
    }

    public CouncilPreamble findbyPreambleNumber(String preambleNumber) {
        return this.councilPreambleRepository.findByPreambleNumber(preambleNumber);
    }

    public Boolean autoGenerationModeEnabled(String moduleName, String keyName) {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, keyName);
        return !appConfigValues.isEmpty() && "YES".equals(((AppConfigValues)appConfigValues.get(0)).getValue());
    }

    public List<CouncilPreamble> searchForPreamble(CouncilPreamble councilPreamble) {
        Criteria criteria = this.buildSearchCriteria(councilPreamble);
        criteria.add(Restrictions.in((String)STATUS_CODE, (Object[])new Object[]{"APPROVED", "ADJOURNED"}));
        return criteria.list();
    }

    public List<CouncilPreamble> searchPreambleForWardwiseReport(CouncilPreamble councilPreamble) {
        Criteria criteria = this.buildSearchCriteria(councilPreamble);
        criteria.add((Criterion)Restrictions.ne((String)STATUS_CODE, (Object)"REJECTED"));
        return criteria.list();
    }

    public List<CouncilPreamble> search(CouncilPreamble councilPreamble) {
        Criteria criteria = this.buildSearchCriteria(councilPreamble);
        criteria.add((Criterion)Restrictions.ne((String)STATUS_CODE, (Object)"REJECTED"));
        return criteria.list();
    }

    public List<CouncilPreamble> searchFinalizedPreamble(CouncilPreamble councilPreamble) {
        Criteria criteria = this.buildSearchCriteria(councilPreamble);
        criteria.createAlias("councilPreamble.implementationStatus", "implementationStatus", CriteriaSpecification.LEFT_JOIN).add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"implementationStatus.code"), (Criterion)Restrictions.ne((String)"implementationStatus.code", (Object)"Finished"))).add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.in((String)STATUS_CODE, (Object[])new Object[]{"Resolution Approved"})}));
        return criteria.list();
    }

    public CouncilPreamble buildSumotoPreamble(MeetingMOM meetingMOM, EgwStatus preambleStatus) {
        CouncilPreamble councilPreamble = new CouncilPreamble();
        SumotoNumberGenerator sumotoResolutionNumberGenerator = (SumotoNumberGenerator)this.autonumberServiceBeanResolver.getAutoNumberServiceFor(SumotoNumberGenerator.class);
        councilPreamble.setPreambleNumber(sumotoResolutionNumberGenerator.getNextNumber(councilPreamble));
        councilPreamble.setStatus(preambleStatus);
        councilPreamble.setDepartment(meetingMOM.getPreamble().getDepartment());
        councilPreamble.setGistOfPreamble(meetingMOM.getPreamble().getGistOfPreamble());
        councilPreamble.setSanctionAmount(meetingMOM.getPreamble().getSanctionAmount());
        councilPreamble.setType(PreambleType.SUMOTO);
        return councilPreamble;
    }

    public Criteria buildSearchCriteria(CouncilPreamble councilPreamble) {
        Criteria criteria = this.getCurrentSession().createCriteria(CouncilPreamble.class, "councilPreamble").createAlias("councilPreamble.status", "status");
        if (councilPreamble.getDepartment() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"councilPreamble.department", (Object)councilPreamble.getDepartment()));
        }
        if (councilPreamble.getFromDate() != null && councilPreamble.getToDate() != null) {
            criteria.add(Restrictions.between((String)"councilPreamble.createdDate", (Object)councilPreamble.getFromDate(), (Object)DateUtils.addDays((Date)councilPreamble.getToDate(), (int)1)));
        }
        if (councilPreamble.getPreambleNumber() != null) {
            criteria.add(Restrictions.ilike((String)"councilPreamble.preambleNumber", (String)councilPreamble.getPreambleNumber(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (councilPreamble.getWards() != null && !councilPreamble.getWards().isEmpty()) {
            ArrayList<Long> boundaryid = new ArrayList<Long>();
            for (Boundary bndry : councilPreamble.getWards()) {
                boundaryid.add(bndry.getId());
            }
            if (!boundaryid.isEmpty()) {
                criteria.createAlias("councilPreamble.wards", "wards").add(Restrictions.in((String)"wards.id", boundaryid));
            }
        }
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return criteria;
    }
}

